/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.projectintelligence.client.gui.guielements;

import com.brandon3055.brandonscore.client.gui.modulargui.IModularGui;
import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.lib.FileDownloadManager;
import com.brandon3055.brandonscore.lib.PairKV;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.projectintelligence.client.StyleHandler;
import com.brandon3055.projectintelligence.client.gui.guielements.StyledGuiRect;
import com.brandon3055.projectintelligence.docmanagement.PIUpdateManager;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;

public class GuiActiveDownloads
extends MGuiElementBase<GuiActiveDownloads> {
    private int completionTimeOut = 0;
    private IModularGui parent;
    private Map<File, DLInfo> downloads = new HashMap<File, DLInfo>();
    private double overallProgress = 0.0;
    private int textColour = 0;

    public GuiActiveDownloads(IModularGui parent) {
        this.parent = parent;
        this.setEnabled(false);
    }

    public void addChildElements() {
        super.addChildElements();
        this.addChild(((StyledGuiRect)((StyledGuiRect)new StyledGuiRect("user_dialogs").bindSize(this, false)).setXPosMod((s, i) -> this.xPos())).setYPosMod((s, i) -> this.yPos()));
        this.setXSize(200);
    }

    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        this.setXSize(200);
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        this.drawCenteredString(this.fontRenderer, I18n.func_135052_a((String)"pi.update_manager.title", (Object[])new Object[0]), (float)this.xPos() + (float)this.xSize() / 2.0f, this.yPos() + 2, this.textColour, false);
        String status = I18n.func_135052_a((String)PIUpdateManager.updateStage.getUnlocalizedName(), (Object[])new Object[0]);
        if (PIUpdateManager.updateStage != PIUpdateManager.UpdateStage.INACTIVE && PIUpdateManager.updateStage != PIUpdateManager.UpdateStage.RELOAD_DOCUMENTATION) {
            status = status + " " + Utils.round((double)(this.overallProgress * 100.0), (double)100.0) + "%";
        }
        this.drawCenteredString(this.fontRenderer, status, (float)this.xPos() + (float)this.xSize() / 2.0f, this.yPos() + 12, this.textColour, false);
        if (!this.downloads.isEmpty()) {
            this.drawColouredRect(this.xPos() + 3, this.yPos() + 22, this.xSize() - 6, this.ySize() - 25, -11513776);
            int y = this.yPos() + 23;
            for (DLInfo info : this.downloads.values()) {
                int colour = info.failed ? 0xAA0000 : (info.progress == 1.0 ? 0x55FF55 : 0xFFFF55);
                String progress = Utils.round((double)(info.progress * 100.0), (double)100.0) + "%";
                int pw = this.fontRenderer.func_78256_a(progress) + 3;
                this.drawString(this.fontRenderer, progress, this.maxXPos() - pw, y, colour);
                File file = (File)PIUpdateManager.tempFileToFileMap.getOrDefault(info.file, (PairKV<String, File>)new PairKV((Object)"", (Object)info.file)).getValue();
                String fileName = file.getName();
                int fileWidth = this.xSize() - pw - 6;
                if (this.fontRenderer.func_78256_a(fileName) > fileWidth) {
                    fileName = this.fontRenderer.func_78269_a(fileName, fileWidth - 4) + "..";
                }
                this.drawString(this.fontRenderer, fileName, this.xPos() + 4, y, colour);
                y += 9;
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean onUpdate() {
        FileDownloadManager manager = PIUpdateManager.downloadManager;
        if (PIUpdateManager.updateStage == PIUpdateManager.UpdateStage.INACTIVE && this.downloads.isEmpty()) {
            if (this.completionTimeOut < 50) {
                ++this.completionTimeOut;
            } else {
                this.setEnabled(false);
            }
        } else {
            this.completionTimeOut = 0;
            this.setEnabled(true);
            this.overallProgress = manager.getDownloadProgressTotal();
            Map progressMap = manager.getActiveProgress();
            for (Map.Entry entry2 : progressMap.entrySet()) {
                if (!this.downloads.containsKey(entry2.getKey())) {
                    this.downloads.put((File)entry2.getKey(), new DLInfo((Double)entry2.getValue(), (File)entry2.getKey()));
                    continue;
                }
                this.downloads.get(entry2.getKey()).progress = (Double)entry2.getValue();
            }
            this.downloads.values().forEach(dlInfo -> {
                if (manager.failedFiles.containsValue(dlInfo.file)) {
                    dlInfo.failed = true;
                }
                if (!progressMap.containsKey(dlInfo.file)) {
                    ++dlInfo.finishedTime;
                    dlInfo.progress = 1.0;
                }
            });
            if (this.downloads.size() > 20) {
                DLInfo oldest = null;
                for (DLInfo info : this.downloads.values()) {
                    if (oldest != null && (info.finishedTime <= oldest.finishedTime || info.failed)) continue;
                    oldest = info;
                }
                if (oldest != null) {
                    this.downloads.remove(oldest.file);
                }
            }
            this.downloads.entrySet().removeIf(entry -> ((DLInfo)entry.getValue()).finishedTime > (((DLInfo)entry.getValue()).failed ? 200 : 10));
            int newY = this.downloads.size() * 9 + (this.downloads.isEmpty() ? 22 : 25);
            this.setYSize(Math.min(PIUpdateManager.updateStage == PIUpdateManager.UpdateStage.INACTIVE || PIUpdateManager.updateStage == PIUpdateManager.UpdateStage.RELOAD_DOCUMENTATION ? newY : Math.max(this.ySize(), newY), this.parent.ySize() - 50));
            this.setPos(this.parent.guiLeft() + this.parent.xSize() - this.xSize() - 2, this.parent.guiTop() + this.parent.ySize() - this.ySize() - 2);
            this.textColour = StyleHandler.getInt("user_dialogs.text_colour");
        }
        return super.onUpdate();
    }

    private static class DLInfo {
        public double progress;
        public File file;
        public int finishedTime = 0;
        public boolean failed = false;

        public DLInfo(double progress, File file) {
            this.progress = progress;
            this.file = file;
        }

        public String toString() {
            return this.progress + "";
        }
    }
}

