/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.prettybeaches;

import net.blay09.mods.prettybeaches.FloodingHandler;
import net.blay09.mods.prettybeaches.PrettyBeachesConfig;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="prettybeaches", name="Pretty Beaches", acceptedMinecraftVersions="[1.12]", acceptableRemoteVersions="*")
public class PrettyBeaches {
    public static final String MOD_ID = "prettybeaches";
    @Mod.Instance(value="prettybeaches")
    public static PrettyBeaches instance;
    public static Logger logger;
    private final FloodingHandler floodingHandler = new FloodingHandler();

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this.floodingHandler);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        PrettyBeachesConfig.onConfigReload();
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MOD_ID)) {
            ConfigManager.sync((String)MOD_ID, (Config.Type)Config.Type.INSTANCE);
            PrettyBeachesConfig.onConfigReload();
        }
    }

    @SubscribeEvent
    public void onBucketFilled(FillBucketEvent event) {
        if (!PrettyBeachesConfig.infiniteBucketWater) {
            return;
        }
        if (event.getEmptyBucket().func_77973_b() == Items.field_151133_ar && event.getEntityPlayer() != null && !(event.getEntityPlayer() instanceof FakePlayer)) {
            BlockPos.MutableBlockPos mutPos = new BlockPos.MutableBlockPos();
            for (EnumFacing facing : EnumFacing.Plane.HORIZONTAL) {
                int waterLevel;
                mutPos.func_189533_g((Vec3i)event.getTarget().func_178782_a()).func_189536_c(facing);
                IBlockState state = event.getWorld().func_180495_p((BlockPos)mutPos);
                int n = waterLevel = state.func_177230_c() == Blocks.field_150358_i ? (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) : -1;
                if (state.func_177230_c() != Blocks.field_150355_j && waterLevel != 0) continue;
                event.getWorld().func_180501_a(event.getTarget().func_178782_a(), Blocks.field_150358_i.func_176223_P(), 11);
                this.floodingHandler.scheduleForFlooding(event.getWorld(), event.getTarget().func_178782_a(), 0);
                return;
            }
        }
    }

    @SubscribeEvent
    public void onHarvestBlock(BlockEvent.HarvestDropsEvent event) {
        if (PrettyBeachesConfig.isBlockAffected(event.getState().func_177230_c()) && event.getHarvester() != null && !(event.getHarvester() instanceof FakePlayer)) {
            BlockPos.MutableBlockPos mutPos = new BlockPos.MutableBlockPos();
            for (EnumFacing facing : EnumFacing.Plane.HORIZONTAL) {
                int waterLevel;
                mutPos.func_189533_g((Vec3i)event.getPos()).func_189536_c(facing);
                IBlockState state = event.getWorld().func_180495_p((BlockPos)mutPos);
                int n = waterLevel = state.func_177230_c() == Blocks.field_150358_i ? (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) : -1;
                if (state.func_177230_c() != Blocks.field_150355_j && waterLevel != 0) continue;
                event.getWorld().func_180501_a(event.getPos(), Blocks.field_150358_i.func_176223_P(), 11);
                this.floodingHandler.scheduleForFlooding(event.getWorld(), event.getPos(), 0);
                return;
            }
        }
    }

    static {
        logger = LogManager.getLogger((String)MOD_ID);
    }
}

