/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.tile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.api.IRecipeList;
import thelm.packagedauto.api.IRecipeListItem;
import thelm.packagedauto.client.gui.GuiEncoder;
import thelm.packagedauto.container.ContainerEncoder;
import thelm.packagedauto.inventory.InventoryEncoder;
import thelm.packagedauto.inventory.InventoryEncoderPattern;
import thelm.packagedauto.tile.TileBase;

public class TileEncoder
extends TileBase {
    public static int patternSlots = 20;
    public static Set<String> disabledRecipeTypes = Collections.emptySet();
    public final InventoryEncoderPattern[] patternInventories = new InventoryEncoderPattern[patternSlots];
    public int patternIndex;

    public TileEncoder() {
        this.setInventory(new InventoryEncoder(this));
        for (int i = 0; i < this.patternInventories.length; ++i) {
            this.patternInventories[i] = new InventoryEncoderPattern(this);
        }
    }

    @Override
    protected String getLocalizedName() {
        return I18n.func_74838_a((String)"tile.packagedauto.encoder.name");
    }

    public void func_145834_a(World world) {
        super.func_145834_a(world);
        for (InventoryEncoderPattern inv : this.patternInventories) {
            inv.updateRecipeInfo(false);
        }
    }

    @Override
    public void readSyncNBT(NBTTagCompound nbt) {
        super.readSyncNBT(nbt);
        this.patternIndex = nbt.func_74771_c("PatternIndex");
        for (int i = 0; i < this.patternInventories.length; ++i) {
            this.patternInventories[i].readFromNBT(nbt.func_74775_l(String.format("Pattern%02d", i)));
        }
    }

    @Override
    public NBTTagCompound writeSyncNBT(NBTTagCompound nbt) {
        super.writeSyncNBT(nbt);
        nbt.func_74774_a("PatternIndex", (byte)this.patternIndex);
        for (int i = 0; i < this.patternInventories.length; ++i) {
            NBTTagCompound subNBT = new NBTTagCompound();
            this.patternInventories[i].writeToNBT(subNBT);
            nbt.func_74782_a(String.format("Pattern%02d", i), (NBTBase)subNBT);
        }
        return nbt;
    }

    public void setPatternIndex(int patternIndex) {
        this.patternIndex = patternIndex;
        this.syncTile(false);
        this.func_70296_d();
    }

    public void saveRecipeList(boolean single) {
        ItemStack stack = this.inventory.func_70301_a(0);
        if (stack.func_77973_b() instanceof IRecipeListItem) {
            ArrayList<IRecipeInfo> recipeList = new ArrayList<IRecipeInfo>();
            if (!single) {
                for (InventoryEncoderPattern inv : this.patternInventories) {
                    if (inv.recipeInfo == null) continue;
                    recipeList.add(inv.recipeInfo);
                }
            } else {
                InventoryEncoderPattern inv = this.patternInventories[this.patternIndex];
                if (inv.recipeInfo != null) {
                    recipeList.add(inv.recipeInfo);
                }
            }
            IRecipeList recipeListItem = ((IRecipeListItem)stack.func_77973_b()).getRecipeList(stack);
            recipeListItem.setRecipeList(recipeList);
            NBTTagCompound nbt = recipeListItem.writeToNBT(new NBTTagCompound());
            stack.func_77982_d(nbt);
        }
    }

    public void loadRecipeList(boolean single) {
        block8: {
            block5: {
                List<IRecipeInfo> recipeList;
                block6: {
                    InventoryEncoderPattern inv;
                    block7: {
                        ItemStack stack = this.inventory.func_70301_a(0);
                        if (!(stack.func_77973_b() instanceof IRecipeListItem)) break block5;
                        IRecipeList recipeListItem = ((IRecipeListItem)stack.func_77973_b()).getRecipeList(stack);
                        recipeList = recipeListItem.getRecipeList();
                        if (!single) break block6;
                        inv = this.patternInventories[this.patternIndex];
                        if (recipeList.isEmpty()) break block7;
                        int i = recipeList.size() > this.patternIndex ? this.patternIndex : 0;
                        IRecipeInfo recipe = recipeList.get(i);
                        inv.recipeType = recipe.getRecipeType();
                        if (!recipe.isValid()) break block8;
                        inv.setRecipe(recipe.getEncoderStacks());
                        break block8;
                    }
                    inv.setRecipe(null);
                    break block8;
                }
                for (int i = 0; i < this.patternInventories.length; ++i) {
                    InventoryEncoderPattern inv = this.patternInventories[i];
                    if (i < recipeList.size()) {
                        IRecipeInfo recipe = recipeList.get(i);
                        inv.recipeType = recipe.getRecipeType();
                        if (!recipe.isValid()) continue;
                        inv.setRecipe(recipe.getEncoderStacks());
                        continue;
                    }
                    inv.setRecipe(null);
                }
                break block8;
            }
            if (single) {
                this.patternInventories[this.patternIndex].setRecipe(null);
            } else {
                for (InventoryEncoderPattern inv : this.patternInventories) {
                    inv.setRecipe(null);
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getClientGuiElement(EntityPlayer player, Object ... args) {
        return new GuiEncoder(new ContainerEncoder(player.field_71071_by, this));
    }

    @Override
    public Container getServerGuiElement(EntityPlayer player, Object ... args) {
        return new ContainerEncoder(player.field_71071_by, this);
    }
}

