/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.recipe;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IRecipeType;
import thelm.packagedauto.api.MiscUtil;
import thelm.packagedauto.container.ContainerEmpty;
import thelm.packagedauto.recipe.IRecipeInfoCrafting;
import thelm.packagedauto.recipe.RecipeTypeCrafting;
import thelm.packagedauto.util.PatternHelper;

public class RecipeInfoCrafting
implements IRecipeInfoCrafting {
    IRecipe recipe;
    List<ItemStack> input = new ArrayList<ItemStack>();
    InventoryCrafting matrix = new InventoryCrafting((Container)new ContainerEmpty(), 3, 3);
    ItemStack output = ItemStack.field_190927_a;
    List<IPackagePattern> patterns = new ArrayList<IPackagePattern>();

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        int i;
        this.input.clear();
        this.output = ItemStack.field_190927_a;
        this.patterns.clear();
        this.recipe = CraftingManager.func_193373_a((ResourceLocation)new ResourceLocation(nbt.func_74779_i("Recipe")));
        ArrayList<ItemStack> matrixList = new ArrayList<ItemStack>();
        MiscUtil.loadAllItems(nbt.func_150295_c("Matrix", 10), matrixList);
        for (i = 0; i < 9 && i < matrixList.size(); ++i) {
            this.matrix.func_70299_a(i, (ItemStack)matrixList.get(i));
        }
        if (this.recipe != null) {
            this.output = this.recipe.func_77572_b(this.matrix).func_77946_l();
        }
        this.input.addAll(MiscUtil.condenseStacks((IInventory)this.matrix));
        i = 0;
        while (i * 9 < this.input.size()) {
            this.patterns.add(new PatternHelper(this, i));
            ++i;
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.recipe != null) {
            nbt.func_74778_a("Recipe", this.recipe.getRegistryName().toString());
        }
        ArrayList<ItemStack> matrixList = new ArrayList<ItemStack>();
        for (int i = 0; i < 9; ++i) {
            matrixList.add(this.matrix.func_70301_a(i));
        }
        NBTTagList matrixTag = MiscUtil.saveAllItems(new NBTTagList(), matrixList);
        nbt.func_74782_a("Matrix", (NBTBase)matrixTag);
        return nbt;
    }

    @Override
    public IRecipeType getRecipeType() {
        return RecipeTypeCrafting.INSTANCE;
    }

    @Override
    public boolean isValid() {
        return this.recipe != null;
    }

    @Override
    public List<IPackagePattern> getPatterns() {
        return Collections.unmodifiableList(this.patterns);
    }

    @Override
    public List<ItemStack> getInputs() {
        return Collections.unmodifiableList(this.input);
    }

    @Override
    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    @Override
    public IRecipe getRecipe() {
        return this.recipe;
    }

    @Override
    public InventoryCrafting getMatrix() {
        return this.matrix;
    }

    @Override
    public List<ItemStack> getRemainingItems() {
        return this.recipe.func_179532_b(this.matrix);
    }

    @Override
    public void generateFromStacks(List<ItemStack> input, List<ItemStack> output, World world) {
        this.recipe = null;
        this.input.clear();
        this.patterns.clear();
        int[] slotArray = RecipeTypeCrafting.SLOTS.toIntArray();
        for (int i = 0; i < 9; ++i) {
            ItemStack toSet = input.get(slotArray[i]);
            toSet.func_190920_e(1);
            this.matrix.func_70299_a(i, toSet.func_77946_l());
        }
        IRecipe recipe = CraftingManager.func_192413_b((InventoryCrafting)this.matrix, (World)world);
        if (recipe != null) {
            this.recipe = recipe;
            this.input.addAll(MiscUtil.condenseStacks((IInventory)this.matrix));
            this.output = recipe.func_77572_b(this.matrix).func_77946_l();
            int i = 0;
            while (i * 9 < this.input.size()) {
                this.patterns.add(new PatternHelper(this, i));
                ++i;
            }
            return;
        }
        this.matrix.func_174888_l();
    }

    @Override
    public Int2ObjectMap<ItemStack> getEncoderStacks() {
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        int[] slotArray = RecipeTypeCrafting.SLOTS.toIntArray();
        for (int i = 0; i < 9; ++i) {
            map.put(slotArray[i], (Object)this.matrix.func_70301_a(i));
        }
        return map;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof RecipeInfoCrafting) {
            RecipeInfoCrafting other = (RecipeInfoCrafting)obj;
            return MiscUtil.recipeEquals(this, this.recipe, other, other.recipe);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return MiscUtil.recipeHashCode(this, this.recipe);
    }
}

