/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.impl.os3;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mcmoddev.orespawn.OreSpawn;
import com.mcmoddev.orespawn.api.IFeature;
import com.mcmoddev.orespawn.api.exceptions.MissingVersionException;
import com.mcmoddev.orespawn.api.exceptions.NotAProperConfigException;
import com.mcmoddev.orespawn.api.exceptions.OldVersionException;
import com.mcmoddev.orespawn.api.exceptions.UnknownVersionException;
import com.mcmoddev.orespawn.api.os3.IBiomeBuilder;
import com.mcmoddev.orespawn.api.os3.IBlockBuilder;
import com.mcmoddev.orespawn.api.os3.IDimensionBuilder;
import com.mcmoddev.orespawn.api.os3.IFeatureBuilder;
import com.mcmoddev.orespawn.api.os3.IReplacementBuilder;
import com.mcmoddev.orespawn.api.os3.IReplacementEntry;
import com.mcmoddev.orespawn.api.os3.ISpawnBuilder;
import com.mcmoddev.orespawn.api.os3.ISpawnEntry;
import com.mcmoddev.orespawn.api.os3.OS3API;
import com.mcmoddev.orespawn.data.Constants;
import com.mcmoddev.orespawn.data.FeatureRegistry;
import com.mcmoddev.orespawn.data.PresetsStorage;
import com.mcmoddev.orespawn.data.ReplacementsRegistry;
import com.mcmoddev.orespawn.impl.os3.BiomeBuilder;
import com.mcmoddev.orespawn.impl.os3.BlockBuilder;
import com.mcmoddev.orespawn.impl.os3.DimensionBuilder;
import com.mcmoddev.orespawn.impl.os3.FeatureBuilder;
import com.mcmoddev.orespawn.impl.os3.ReplacementBuilder;
import com.mcmoddev.orespawn.impl.os3.SpawnBuilder;
import com.mcmoddev.orespawn.json.OreSpawnReader;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.util.ResourceLocation;

public class OS3APIImpl
implements OS3API {
    private static final Map<ResourceLocation, ISpawnEntry> spawns;
    private static final FeatureRegistry features;
    private static final ReplacementsRegistry replacements;
    private static final PresetsStorage presets;
    private static final String ORE_SPAWN_VERSION = "OreSpawn Version";
    private static final Map<String, Path> spawnsToSourceFiles;

    @Override
    public void loadConfigFiles() {
        Object report;
        Stream<Path> stream;
        String failedReadingConfigsFrom = "Failed reading configs from ";
        PathMatcher featuresFiles = FileSystems.getDefault().getPathMatcher("glob:**/features-*.json");
        PathMatcher replacementsFiles = FileSystems.getDefault().getPathMatcher("glob:**/replacements-*.json");
        PathMatcher jsonMatcher = FileSystems.getDefault().getPathMatcher("glob:**/*.json");
        try {
            stream = Files.walk(Constants.SYSCONF, 1, new FileVisitOption[0]);
            Throwable throwable = null;
            try {
                stream.filter(featuresFiles::matches).map(Path::toFile).forEach(features::loadFeaturesFile);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            report = CrashReport.func_85055_a((Throwable)e, (String)("Failed reading configs from " + Constants.SYSCONF.toString()));
            report.func_85056_g().func_71507_a(ORE_SPAWN_VERSION, (Object)"3.3.1");
            OreSpawn.LOGGER.info(report.func_71502_e());
        }
        try {
            stream = Files.walk(Constants.SYSCONF, 1, new FileVisitOption[0]);
            report = null;
            try {
                stream.filter(replacementsFiles::matches).forEach(replacements::loadFile);
            }
            catch (Throwable throwable) {
                report = throwable;
                throw throwable;
            }
            finally {
                if (stream != null) {
                    if (report != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)report).addSuppressed(throwable);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            report = CrashReport.func_85055_a((Throwable)e, (String)("Failed reading configs from " + Constants.SYSCONF.toString()));
            report.func_85056_g().func_71507_a(ORE_SPAWN_VERSION, (Object)"3.3.1");
            OreSpawn.LOGGER.info(report.func_71502_e());
        }
        if (Constants.SYSCONF.resolve("presets-default.json").toFile().exists()) {
            presets.load(Constants.SYSCONF.resolve("presets-default.json"));
        }
        try {
            stream = Files.walk(Constants.CONFDIR, 1, new FileVisitOption[0]);
            report = null;
            try {
                stream.filter(jsonMatcher::matches).forEach(conf -> {
                    try {
                        OreSpawnReader.tryReadFile(conf);
                    }
                    catch (MissingVersionException | NotAProperConfigException | OldVersionException | UnknownVersionException e) {
                        CrashReport report = CrashReport.func_85055_a((Throwable)e, (String)("Failed reading config " + conf.toString()));
                        report.func_85056_g().func_71507_a(ORE_SPAWN_VERSION, (Object)"3.3.1");
                        OreSpawn.LOGGER.info(report.func_71502_e());
                    }
                });
            }
            catch (Throwable throwable) {
                report = throwable;
                throw throwable;
            }
            finally {
                if (stream != null) {
                    if (report != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)report).addSuppressed(throwable);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            report = CrashReport.func_85055_a((Throwable)e, (String)("Failed reading configs from " + Constants.CONFDIR.toString()));
            report.func_85056_g().func_71507_a(ORE_SPAWN_VERSION, (Object)"3.3.1");
            OreSpawn.LOGGER.info(report.func_71502_e());
        }
    }

    @Override
    public void addSpawn(ISpawnEntry spawnEntry) {
        if (spawnEntry != null) {
            spawns.put(new ResourceLocation(spawnEntry.getSpawnName()), spawnEntry);
        }
    }

    @Override
    public void addFeature(String featureName, IFeature feature) {
        features.addFeature(featureName, feature);
    }

    @Override
    public void addReplacement(IReplacementEntry replacementEntry) {
        replacements.addReplacement(replacementEntry);
    }

    @Override
    public ISpawnBuilder getSpawnBuilder() {
        return new SpawnBuilder();
    }

    @Override
    public IDimensionBuilder getDimensionBuilder() {
        return new DimensionBuilder();
    }

    @Override
    public IFeatureBuilder getFeatureBuilder() {
        return new FeatureBuilder();
    }

    @Override
    public IBlockBuilder getBlockBuilder() {
        return new BlockBuilder();
    }

    @Override
    public IBiomeBuilder getBiomeBuilder() {
        return new BiomeBuilder();
    }

    @Override
    public IReplacementBuilder getReplacementBuilder() {
        return new ReplacementBuilder();
    }

    @Override
    public Map<String, IReplacementEntry> getReplacements() {
        HashMap temp = new HashMap();
        replacements.getReplacements().entrySet().stream().forEach(e -> {
            IReplacementEntry cfr_ignored_0 = (IReplacementEntry)temp.put(((ResourceLocation)e.getKey()).func_110623_a(), e.getValue());
        });
        return ImmutableMap.copyOf(temp);
    }

    @Override
    public IReplacementEntry getReplacement(String replacementName) {
        return replacements.getReplacement(replacementName);
    }

    @Override
    public List<ISpawnEntry> getSpawns(int dimensionID) {
        return ImmutableList.copyOf((Collection)spawns.entrySet().stream().filter(e -> ((ISpawnEntry)e.getValue()).dimensionAllowed(dimensionID)).map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    @Override
    public ISpawnEntry getSpawn(String spawnName) {
        return spawns.get(new ResourceLocation(spawnName));
    }

    @Override
    public Map<String, ISpawnEntry> getAllSpawns() {
        HashMap sp = new HashMap();
        spawns.entrySet().forEach(ent -> {
            ISpawnEntry cfr_ignored_0 = (ISpawnEntry)sp.put(((ResourceLocation)ent.getKey()).func_110623_a(), ent.getValue());
        });
        return ImmutableMap.copyOf(sp);
    }

    @Override
    public boolean featureExists(String featureName) {
        return this.featureExists(new ResourceLocation(featureName.contains(":") ? featureName : String.format(Locale.ENGLISH, "orespawn:%s", featureName)));
    }

    @Override
    public boolean featureExists(ResourceLocation featureName) {
        return features.hasFeature(featureName);
    }

    @Override
    public IFeature getFeature(String featureName) {
        return this.getFeature(new ResourceLocation(featureName));
    }

    @Override
    public IFeature getFeature(ResourceLocation featureName) {
        return features.getFeature(featureName);
    }

    @Override
    public PresetsStorage copyPresets() {
        PresetsStorage copy = new PresetsStorage();
        presets.copy(copy);
        return copy;
    }

    @Override
    public List<IBlockState> getDimensionDefaultReplacements(int dimensionID) {
        return replacements.getDimensionDefault(dimensionID);
    }

    @Override
    public boolean hasReplacement(ResourceLocation resourceLocation) {
        return replacements.has(resourceLocation);
    }

    @Override
    public boolean hasReplacement(String name) {
        return this.hasReplacement(new ResourceLocation(name.contains(":") ? name : String.format(Locale.ENGLISH, "orespawn:%s", name)));
    }

    @Override
    public void mapEntryToFile(Path p, String entryName) {
        spawnsToSourceFiles.put(entryName, p);
    }

    @Override
    public List<String> getSpawnsForFile(String fileName) {
        Path p = Constants.CONFDIR.resolve(fileName);
        List values = spawnsToSourceFiles.entrySet().stream().filter(ent -> ((Path)ent.getValue()).equals(p)).map(Map.Entry::getKey).collect(Collectors.toList());
        return ImmutableList.copyOf(values);
    }

    @Override
    public Map<Path, List<String>> getSpawnsByFile() {
        HashMap temp = new HashMap();
        spawnsToSourceFiles.entrySet().stream().forEach(ent -> {
            if (temp.containsKey(ent.getValue())) {
                ((List)temp.get(ent.getValue())).add(ent.getKey());
            } else {
                temp.put(ent.getValue(), Lists.newLinkedList(Arrays.asList((String)ent.getKey())));
            }
        });
        return ImmutableMap.copyOf(temp);
    }

    static {
        spawnsToSourceFiles = new TreeMap<String, Path>();
        spawns = new ConcurrentHashMap<ResourceLocation, ISpawnEntry>();
        features = new FeatureRegistry();
        replacements = new ReplacementsRegistry();
        presets = new PresetsStorage();
    }
}

