/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.impl.features;

import com.google.gson.JsonObject;
import com.mcmoddev.orespawn.OreSpawn;
import com.mcmoddev.orespawn.api.FeatureBase;
import com.mcmoddev.orespawn.api.IFeature;
import com.mcmoddev.orespawn.api.os3.ISpawnEntry;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;

public class ClusterGenerator
extends FeatureBase
implements IFeature {
    private ClusterGenerator(Random rand) {
        super(rand);
    }

    public ClusterGenerator() {
        this(new Random());
    }

    @Override
    public void generate(World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider, ISpawnEntry spawnData, ChunkPos posIn) {
        ChunkPos pos = posIn;
        JsonObject params = spawnData.getFeature().getFeatureParameters();
        int chunkX = pos.field_77276_a;
        int chunkZ = pos.field_77275_b;
        ClusterGenerator.mergeDefaults(params, this.getDefaultParameters());
        this.runCache(chunkX, chunkZ, world, spawnData);
        int blockX = chunkX * 16 + 8;
        int blockZ = chunkZ * 16 + 8;
        int maxSpread = params.get("maxSpread").getAsInt();
        int minHeight = params.get("minHeight").getAsInt();
        int maxHeight = params.get("maxHeight").getAsInt();
        int variance = params.get("variation").getAsInt();
        int frequency = params.get("frequency").getAsInt();
        int triesMin = params.get("minAttempts").getAsInt();
        int triesMax = params.get("maxAttempts").getAsInt();
        int clusterSize = params.get("size").getAsInt();
        int clusterCount = params.get("numObjects").getAsInt();
        for (int tries = triesMax == triesMin ? triesMax : this.random.nextInt(triesMax - triesMin) + triesMin; tries > 0; --tries) {
            if (this.random.nextInt(100) > frequency) continue;
            int xRand = this.random.nextInt(16);
            int zRand = this.random.nextInt(16);
            int x = blockX + xRand - maxSpread / 2;
            int y = this.random.nextInt(maxHeight - minHeight) + minHeight;
            int z = blockZ + zRand - maxSpread / 2;
            this.spawnCluster(new SpawnParameters(clusterSize, variance, clusterCount, maxSpread, minHeight, maxHeight), spawnData, world, new BlockPos(x, y, z));
        }
    }

    private void spawnCluster(SpawnParameters params, ISpawnEntry spawnData, World world, BlockPos pos) {
        int r = params.clusterSize - params.variance;
        if (params.variance > 0) {
            r += this.random.nextInt(2 * params.variance) - params.variance;
        }
        this.spawnChunk(world, pos, spawnData, r);
        int count = this.random.nextInt(params.clusterCount - 1);
        if (params.variance > 0) {
            count += this.random.nextInt(2 * params.variance) - params.variance;
        }
        while (count >= 0) {
            r = params.clusterSize - params.variance;
            if (params.variance > 0) {
                r += this.random.nextInt(2 * params.variance) - params.variance;
            }
            int radius = params.maxSpread / 2;
            int xp = this.getPoint(-radius, radius, 0);
            int yp = this.getPoint(params.minHeight, params.maxHeight, (params.maxHeight - params.minHeight) / 2);
            int zp = this.getPoint(-radius, radius, 0);
            BlockPos p = pos.func_177982_a(xp, yp, zp);
            this.spawnChunk(world, p, spawnData, r);
            count -= r;
        }
    }

    private void spawnChunk(World world, BlockPos pos, ISpawnEntry spawnData, int quantity) {
        int count = quantity;
        int lutType = quantity < 8 ? offsetIndexRef_small.length : offsetIndexRef.length;
        int[] lut = quantity < 8 ? offsetIndexRef_small : offsetIndexRef;
        Vec3i[] offs = new Vec3i[lutType];
        System.arraycopy(quantity < 8 ? offsets_small : offsets, 0, offs, 0, lutType);
        int dimension = world.field_73011_w.getDimension();
        if (quantity < 27) {
            int[] scrambledLUT = new int[lutType];
            System.arraycopy(lut, 0, scrambledLUT, 0, scrambledLUT.length);
            this.scramble(scrambledLUT, this.random);
            int z = 0;
            while (count > 0) {
                IBlockState oreBlock = spawnData.getBlocks().getRandomBlock(this.random);
                if (oreBlock.func_177230_c().equals(Blocks.field_150350_a)) {
                    return;
                }
                if (!this.spawn(oreBlock, world, pos.func_177971_a(offs[scrambledLUT[--count]]), dimension, true, spawnData)) {
                    ++count;
                    ++z;
                    this.scramble(scrambledLUT, this.random);
                } else {
                    z = 0;
                }
                if (z <= 5) continue;
                --count;
                z = 0;
                OreSpawn.LOGGER.warn("Unable to place block for chunk after 5 tries");
            }
            return;
        }
        this.doSpawnFill(this.random.nextBoolean(), count, spawnData, world, pos);
    }

    private void doSpawnFill(boolean nextBoolean, int quantity, ISpawnEntry spawnData, World world, BlockPos pos) {
        int count = quantity;
        double radius = Math.pow(quantity, 0.3333333333333333) * 0.238732414637843 + 2.0;
        int rSqr = (int)(radius * radius);
        if (nextBoolean) {
            this.spawnMungeNE(world, pos, rSqr, radius, spawnData, count);
        } else {
            this.spawnMungeSW(world, pos, rSqr, radius, spawnData, count);
        }
    }

    @Override
    public void setRandom(Random rand) {
        this.random = rand;
    }

    @Override
    public JsonObject getDefaultParameters() {
        JsonObject defParams = new JsonObject();
        defParams.addProperty("maxSpread", (Number)16);
        defParams.addProperty("size", (Number)8);
        defParams.addProperty("numObjects", (Number)8);
        defParams.addProperty("minHeight", (Number)8);
        defParams.addProperty("maxHeight", (Number)24);
        defParams.addProperty("variation", (Number)4);
        defParams.addProperty("frequency", (Number)25);
        defParams.addProperty("minAttempts", (Number)4);
        defParams.addProperty("maxAttempts", (Number)8);
        return defParams;
    }

    private class SpawnParameters {
        public final int clusterSize;
        public final int variance;
        public final int clusterCount;
        public final int maxSpread;
        public final int minHeight;
        public final int maxHeight;

        SpawnParameters(int clusterSize, int variance, int clusterCount, int maxSpread, int minHeight, int maxHeight) {
            this.clusterSize = clusterSize;
            this.variance = variance;
            this.clusterCount = clusterCount;
            this.maxSpread = maxSpread;
            this.minHeight = minHeight;
            this.maxHeight = maxHeight;
        }
    }
}

