/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import openblocks.OpenBlocks;
import openblocks.client.gui.GuiVacuumHopper;
import openblocks.common.FluidXpUtils;
import openblocks.common.container.ContainerVacuumHopper;
import openblocks.common.entity.EntityItemProjectile;
import openmods.OpenMods;
import openmods.api.IActivateAwareTile;
import openmods.api.IHasGui;
import openmods.api.INeighbourAwareTile;
import openmods.api.IValueProvider;
import openmods.fixers.GenericInventoryTeFixerWalker;
import openmods.fixers.RegisterFixer;
import openmods.include.IncludeInterface;
import openmods.inventory.GenericInventory;
import openmods.inventory.IInventoryProvider;
import openmods.inventory.ItemMover;
import openmods.inventory.TileEntityInventory;
import openmods.liquids.SidedFluidCapabilityWrapper;
import openmods.sync.ISyncListener;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncMap;
import openmods.sync.SyncableBoolean;
import openmods.sync.SyncableSides;
import openmods.sync.SyncableTank;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.EnchantmentUtils;
import openmods.utils.InventoryUtils;
import openmods.utils.ItemUtils;
import openmods.utils.SidedInventoryAdapter;
import openmods.utils.SidedItemHandlerAdapter;
import openmods.utils.bitmap.BitMapUtils;
import openmods.utils.bitmap.IReadableBitMap;
import openmods.utils.bitmap.IRpcDirectionBitMap;
import openmods.utils.bitmap.IWriteableBitMap;

@RegisterFixer(value=GenericInventoryTeFixerWalker.class)
public class TileEntityVacuumHopper
extends SyncedTileEntity
implements IInventoryProvider,
IActivateAwareTile,
IHasGui,
INeighbourAwareTile,
ITickable {
    public static final int TANK_CAPACITY = FluidXpUtils.xpJuiceConverter.xpToFluid(EnchantmentUtils.getExperienceForLevel((int)5));
    public static final String OUTPUT_ITEMS = "items";
    public static final String OUTPUT_FLUIDS = "fluids";
    public static final String OUTPUT_BOTH = "both";
    private SyncableTank tank;
    public SyncableSides xpOutputs;
    public SyncableSides itemOutputs;
    public SyncableBoolean vacuumDisabled;
    private boolean needsTankUpdate;
    private final GenericInventory inventory = this.registerInventoryCallback((GenericInventory)new TileEntityInventory((TileEntity)this, "vacuumhopper", true, 10));
    @IncludeInterface(value=ISidedInventory.class)
    private final SidedInventoryAdapter sided = new SidedInventoryAdapter((IInventory)this.inventory);
    private final SidedItemHandlerAdapter itemHandlerCapability = new SidedItemHandlerAdapter(this.inventory.getHandler());
    private final SidedFluidCapabilityWrapper tankCapability = SidedFluidCapabilityWrapper.wrap((IFluidHandler)this.tank, (IReadableBitMap)this.xpOutputs, (boolean)true, (boolean)false);
    private Map<String, String> outputState = ImmutableMap.of();
    private final Predicate<Entity> entitySelector = entity -> {
        if (entity.field_70128_L) {
            return false;
        }
        if (entity instanceof EntityItemProjectile) {
            return entity.field_70181_x < 0.01;
        }
        if (entity instanceof EntityItem) {
            ItemStack stack = ((EntityItem)entity).func_92059_d();
            return InventoryUtils.canInsertStack((IItemHandler)this.inventory.getHandler(), (ItemStack)stack);
        }
        if (entity instanceof EntityXPOrb) {
            return this.tank.getSpace() > 0;
        }
        return false;
    };

    protected void createSyncedFields() {
        this.tank = new SyncableTank(TANK_CAPACITY, new Fluid[]{OpenBlocks.Fluids.xpJuice});
        this.xpOutputs = new SyncableSides();
        this.itemOutputs = new SyncableSides();
        this.vacuumDisabled = new SyncableBoolean();
    }

    public TileEntityVacuumHopper() {
        this.sided.registerAllSlots((IReadableBitMap)this.itemOutputs, false, true);
        this.itemHandlerCapability.registerAllSlots((IReadableBitMap)this.itemOutputs, false, true);
    }

    protected void onSyncMapCreate(SyncMap syncMap) {
        syncMap.addSyncListener(this.itemHandlerCapability.createSyncListener());
        syncMap.addUpdateListener(new ISyncListener(){

            public void onSync(Set<ISyncableObject> changes) {
                if (changes.contains(TileEntityVacuumHopper.this.xpOutputs) || changes.contains(TileEntityVacuumHopper.this.itemOutputs)) {
                    this.updateOutputStates();
                    TileEntityVacuumHopper.this.field_145850_b.func_175704_b(TileEntityVacuumHopper.this.field_174879_c, TileEntityVacuumHopper.this.field_174879_c);
                }
            }

            private void updateOutputStates() {
                ImmutableMap.Builder newOutputState = ImmutableMap.builder();
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    boolean outputItems = TileEntityVacuumHopper.this.itemOutputs.get(side);
                    boolean outputXp = TileEntityVacuumHopper.this.xpOutputs.get(side);
                    if (outputItems) {
                        if (outputXp) {
                            newOutputState.put((Object)side.func_176610_l(), (Object)TileEntityVacuumHopper.OUTPUT_BOTH);
                            continue;
                        }
                        newOutputState.put((Object)side.func_176610_l(), (Object)TileEntityVacuumHopper.OUTPUT_ITEMS);
                        continue;
                    }
                    if (!outputXp) continue;
                    newOutputState.put((Object)side.func_176610_l(), (Object)TileEntityVacuumHopper.OUTPUT_FLUIDS);
                }
                TileEntityVacuumHopper.this.outputState = (Map)newOutputState.build();
            }
        });
    }

    public IReadableBitMap<EnumFacing> getReadableXpOutputs() {
        return this.xpOutputs;
    }

    public IWriteableBitMap<EnumFacing> getWriteableXpOutputs() {
        return BitMapUtils.createRpcAdapter((IRpcDirectionBitMap)((IRpcDirectionBitMap)this.createRpcProxy((ISyncableObject)this.xpOutputs, IRpcDirectionBitMap.class, new Class[0])));
    }

    public IReadableBitMap<EnumFacing> getReadableItemOutputs() {
        return this.itemOutputs;
    }

    public IWriteableBitMap<EnumFacing> getWriteableItemOutputs() {
        return BitMapUtils.createRpcAdapter((IRpcDirectionBitMap)((IRpcDirectionBitMap)this.createRpcProxy((ISyncableObject)this.itemOutputs, IRpcDirectionBitMap.class, new Class[0])));
    }

    public IValueProvider<FluidStack> getFluidProvider() {
        return this.tank;
    }

    public void func_73660_a() {
        if (this.vacuumDisabled.get()) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            this.spawnParticle(EnumParticleTypes.PORTAL, this.field_145850_b.field_73012_v.nextDouble() - 0.5, this.field_145850_b.field_73012_v.nextDouble() - 1.0, this.field_145850_b.field_73012_v.nextDouble() - 0.5, new int[0]);
        }
        List interestingItems = this.field_145850_b.func_175647_a(Entity.class, this.getBB().func_186662_g(3.0), this.entitySelector);
        boolean needsSync = false;
        for (Entity entity : interestingItems) {
            double dz;
            double dy;
            double dx = (double)this.field_174879_c.func_177958_n() + 0.5 - entity.field_70165_t;
            double distance = Math.sqrt(dx * dx + (dy = (double)this.field_174879_c.func_177956_o() + 0.5 - entity.field_70163_u) * dy + (dz = (double)this.field_174879_c.func_177952_p() + 0.5 - entity.field_70161_v) * dz);
            if (distance < 1.1) {
                needsSync |= this.onEntityCollidedWithBlock(entity);
                continue;
            }
            double var11 = 1.0 - distance / 15.0;
            if (!(var11 > 0.0)) continue;
            var11 *= var11;
            entity.field_70159_w += dx / distance * var11 * 0.05;
            entity.field_70181_x += dy / distance * var11 * 0.2;
            entity.field_70179_y += dz / distance * var11 * 0.05;
        }
        if (!this.field_145850_b.field_72995_K && (needsSync |= this.outputToNeighbors())) {
            this.sync();
        }
    }

    private boolean outputToNeighbors() {
        if (OpenMods.proxy.getTicks(this.field_145850_b) % 10L == 0L) {
            if (this.needsTankUpdate) {
                this.tank.updateNeighbours(this.field_145850_b, this.field_174879_c);
                this.needsTankUpdate = false;
            }
            this.tank.distributeToSides(50, this.field_145850_b, this.field_174879_c, this.xpOutputs.getValue());
            this.autoInventoryOutput();
            return true;
        }
        return false;
    }

    private void autoInventoryOutput() {
        boolean outputSides = this.itemOutputs.getValue().isEmpty();
        if (outputSides) {
            return;
        }
        ItemMover mover = new ItemMover(this.field_145850_b, this.field_174879_c).breakAfterFirstTry().randomizeSides().setSides(this.itemOutputs.getValue());
        for (int i = 0; i < this.inventory.func_70302_i_() && (this.inventory.func_70301_a(i).func_190926_b() || mover.pushFromSlot((IItemHandler)this.inventory.getHandler(), i) <= 0); ++i) {
        }
    }

    public Object getServerGui(EntityPlayer player) {
        return new ContainerVacuumHopper((IInventory)player.field_71071_by, this);
    }

    public Object getClientGui(EntityPlayer player) {
        return new GuiVacuumHopper(new ContainerVacuumHopper((IInventory)player.field_71071_by, this));
    }

    public boolean canOpenGui(EntityPlayer player) {
        return true;
    }

    public boolean onBlockActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!this.field_145850_b.field_72995_K && hand == EnumHand.MAIN_HAND && player.func_70093_af() && player.func_184614_ca().func_190926_b()) {
            this.vacuumDisabled.toggle();
            return true;
        }
        return false;
    }

    public boolean onEntityCollidedWithBlock(Entity entity) {
        if (!this.field_145850_b.field_72995_K) {
            if (entity instanceof EntityItem && !entity.field_70128_L) {
                EntityItem item = (EntityItem)entity;
                ItemStack toConsume = item.func_92059_d().func_77946_l();
                ItemStack leftover = ItemHandlerHelper.insertItem((IItemHandler)this.inventory.getHandler(), (ItemStack)toConsume, (boolean)false);
                ItemUtils.setEntityItemStack((EntityItem)item, (ItemStack)leftover);
                return true;
            }
            if (entity instanceof EntityXPOrb && this.tank.getSpace() > 0) {
                EntityXPOrb orb = (EntityXPOrb)entity;
                int xpAmount = FluidXpUtils.xpJuiceConverter.xpToFluid(orb.func_70526_d());
                FluidStack newFluid = new FluidStack(OpenBlocks.Fluids.xpJuice, xpAmount);
                this.tank.fill(newFluid, true);
                entity.func_70106_y();
                return true;
            }
        }
        return false;
    }

    public IInventory getInventory() {
        return this.inventory;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        this.inventory.writeToNBT(tag);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.readFromNBT(tag);
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.needsTankUpdate = true;
    }

    public void onNeighbourChanged(BlockPos neighbourPos, Block neighbourBlock) {
        this.needsTankUpdate = true;
    }

    public Map<String, String> getOutputState() {
        return this.outputState;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandlerCapability.hasHandler(facing);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.tankCapability.hasHandler(facing);
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tankCapability.getHandler(facing);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandlerCapability.getHandler(facing);
        }
        return (T)super.getCapability(capability, facing);
    }
}

