/*
 * Decompiled with CFR 0.152.
 */
package org.icannt.netherendingores.lib;

import net.minecraft.util.math.MathHelper;
import org.icannt.netherendingores.common.registry.BlockData;
import org.icannt.netherendingores.common.registry.OreDictionaryOtherData;
import org.icannt.netherendingores.lib.ConfigEx;
import org.icannt.netherendingores.lib.Log;
import org.icannt.netherendingores.proxy.CommonProxy;

public class Config {
    public static boolean advancedDebugging = false;
    public static final int PRIMED_ORE_ENTITY_ID = 668;
    public static final int NETHERFISH_ENTITY_ID = 667;
    public static final int NETHERFISH_TRACKING_RANGE = 50;
    public static final int NETHERFISH_SPAWN_EGG_PRIMARY_COLOR = 12325908;
    public static final int NETHERFISH_SPAWN_EGG_SECONDARY_COLOR = 16761600;
    public static double netherfishAttackDamage = 0.5;
    private static final double netherfishAttackDamageMin = 0.0;
    private static final double netherfishAttackDamageMax = 1000.0;
    public static double netherfishKnockbackResistance = 0.0;
    private static final double netherfishKnockbackResistanceMin = 0.0;
    private static final double netherfishKnockbackResistanceMax = 100.0;
    public static double netherfishMaxHealth = 10.0;
    private static final double netherfishMaxHealthMin = 1.0;
    private static final double netherfishMaxHealthMax = 1000.0;
    public static double netherfishMovementSpeed = 0.2;
    private static final double netherfishMovementSpeedMin = 0.0;
    private static final double netherfishMovementSpeedMax = 1.0;
    public static boolean netherfishSetFire = true;
    public static boolean netherfishWAILA = true;
    public static boolean endermiteEndermanHostility = true;
    public static boolean endermiteWAILA = true;
    public static boolean zombiePigmanAnger = true;
    public static int zombiePigmanAngerRangeHeight = 16;
    private static final int zombiePigmanAngerRangeHeightMin = 1;
    private static final int zombiePigmanAngerRangeHeightMax = 32;
    public static int zombiePigmanAngerRangeRadius = 32;
    private static final int zombiePigmanAngerRangeRadiusMin = 1;
    private static final int zombiePigmanAngerRangeRadiusMax = 64;
    public static boolean zombiePigmanAngerSilkTouch = true;
    public static boolean dropItems = false;
    public static boolean dropItemsOverride = false;
    public static boolean preferredMods = false;
    public static final int ORE_EXPLOSION_FUSE_LENGTH_TICKS = 80;
    public static boolean oreExplosion = true;
    public static double oreExplosionChance = 0.125;
    private static final double oreExplosionChanceMin = 0.0;
    private static final double oreExplosionChanceMax = 1.0;
    public static boolean oreExplosionFortune = true;
    public static boolean oreExplosionOverride = false;
    public static boolean oreExplosionSilkTouch = true;
    public static double oreExplosionStrength = 4.0;
    private static final double oreExplosionStrengthMin = 0.0;
    private static final double oreExplosionStrengthMax = 20.0;
    public static boolean furnaceToItem = false;
    public static boolean furnaceToItemOverride = false;
    public static boolean immersiveEngineeringRecipes = true;
    public static boolean industrialCraft2Recipes = true;
    public static boolean mekanismRecipes = true;
    public static boolean thermalExpansionRecipes = true;
    public static boolean tinkersConstructRecipes = true;
    public static boolean vanillaCraftingRecipes = true;
    public static boolean vanillaFurnaceRecipes = true;
    public static final float IE_MACHINE_TIME_MULTIPLIER_MIN = 0.001f;
    public static final float IE_MACHINE_TIME_MULTIPLIER_MAX = 1000.0f;
    public static float crusher2xOreTimeMultiplier = 1.8f;
    public static float crusher3xOreTimeMultiplier = 2.5f;
    private static final float outputFactorMin = 0.5f;
    private static final float fullOutputFactorMax = 3.0f;
    private static final float reducedOutputFactorMax = 1.0f;
    public static boolean inductionSmelterFullOutput = false;
    public static float inductionSmelterFullOutputAmountFactor = 1.0f;
    public static float inductionSmelterFullOutputEnergyFactor = 2.0f;
    public static float inductionSmelterReducedOutputAmountFactor = 0.6666667f;
    public static float inductionSmelterReducedOutputEnergyFactor = 0.6f;
    public static boolean pulverizerFullOutput = false;
    public static float pulverizerFullOutputAmountFactor = 1.0f;
    public static float pulverizerFullOutputEnergyFactor = 2.0f;
    public static float pulverizerReducedOutputAmountFactor = 0.6666667f;
    public static float pulverizerReducedOutputEnergyFactor = 0.6f;
    public static boolean redstoneFurnaceFullOutput = false;
    public static float redstoneFurnaceFullOutputAmountFactor = 1.0f;
    public static float redstoneFurnaceFullOutputEnergyFactor = 2.0f;
    public static float redstoneFurnaceReducedOutputAmountFactor = 0.6666667f;
    public static float redstoneFurnaceReducedOutputEnergyFactor = 0.6f;
    private static int recipeMultiplierOverride;
    private static final int recipeMultiplierOverrideMin;
    private static final int recipeMultiplierMin = 0;
    private static final int recipeMultiplierMax = 3;
    private static final String CATEGORY_GENERAL = "general";
    private static final String CATEGORY_MOBS = "mobs";
    private static final String CATEGORY_MOBS__ENDERMITE = "mobs.endermite";
    private static final String CATEGORY_MOBS__NETHERRFISH = "mobs.netherfish";
    private static final String CATEGORY_MOBS__ZOMBIE_PIGMAN = "mobs.zombie pigman";
    private static final String CATEGORY_ORES = "ores";
    private static final String CATEGORY_ORES__DROP_ITEMS = "ores.drop items";
    private static final String CATEGORY_ORES__DROP_ITEMS__DROP_ITEM_ORES = "ores.drop items.drop item ores";
    private static final String CATEGORY_ORES__ORE_DICTIONARY = "ores.ore dictionary";
    private static final String CATEGORY_ORES__ORE_DICTIONARY_PREFERRED_MODS = "ores.ore dictionary preferred mods";
    private static final String CATEGORY_ORES__ORE_DICTIONARY_PREFERRED_MODS__ORE_DICTIONARY_PREFERRED_MOD_ORES = "ores.ore dictionary preferred mods.ore dictionary preferred mod ores";
    private static final String CATEGORY_ORES__ORE_EXPLOSIONS = "ores.ore explosions";
    private static final String CATEGORY_ORES__ORE_EXPLOSIONS__ORE_EXPLOSION_ORES = "ores.ore explosions.ore explosion ores";
    private static final String CATEGORY_RECIPES = "recipes";
    private static final String CATEGORY_RECIPES__FURNACE_TO_ITEMS = "recipes.furnace to items";
    private static final String CATEGORY_RECIPES__FURNACE_TO_ITEMS__FURNACE_TO_ITEM_ORES = "recipes.furnace to items.furnace to item ores";
    private static final String CATEGORY_RECIPES__INTEGRATION = "recipes.integration";
    private static final String CATEGORY_RECIPES__INTEGRATION__IMMERSIVE_ENGINEERING = "recipes.integration.immersive engineering";
    private static final String CATEGORY_RECIPES__INTEGRATION__THERMAL_EXPANSION = "recipes.integration.thermal expansion";
    private static final String CATEGORY_RECIPES__RECIPE_MULTIPLIERS = "recipes.recipe multipliers";
    private static final String CATEGORY_RECIPES__RECIPE_MULTIPLIERS__RECIPE_MULTIPLIER_ORES = "recipes.recipe multipliers.recipe multiplier ores";

    public static void readConfig() {
        ConfigEx cfg = CommonProxy.config;
        try {
            cfg.load();
            Config.loadCategoryCommentStrings(cfg);
            Config.loadCategories(cfg);
        }
        catch (Exception e1) {
            Log.error("Problem loading config file!", e1);
        }
        finally {
            if (cfg.hasChanged()) {
                cfg.save();
            }
        }
    }

    private static void loadCategories(ConfigEx cfg) {
        Config.initGeneralSettingsConfig(cfg, CATEGORY_GENERAL);
        Config.initMobsNetherfishConfig(cfg, CATEGORY_MOBS__NETHERRFISH);
        Config.initMobsEndermiteConfig(cfg, CATEGORY_MOBS__ENDERMITE);
        Config.initMobsZombiePigmanConfig(cfg, CATEGORY_MOBS__ZOMBIE_PIGMAN);
        Config.initOresOreDictionaryConfig(cfg, CATEGORY_ORES__ORE_DICTIONARY);
        Config.initOresOreDictionaryPreferredModsConfig(cfg, CATEGORY_ORES__ORE_DICTIONARY_PREFERRED_MODS);
        Config.initOresOreDictionaryPreferredModsOreDictionaryPreferredModOresConfig(cfg, CATEGORY_ORES__ORE_DICTIONARY_PREFERRED_MODS__ORE_DICTIONARY_PREFERRED_MOD_ORES);
        Config.initOresDropItems(cfg, CATEGORY_ORES__DROP_ITEMS);
        Config.initOresDropItemsDropItemOres(cfg, CATEGORY_ORES__DROP_ITEMS__DROP_ITEM_ORES);
        Config.initOresOreExplosionsConfig(cfg, CATEGORY_ORES__ORE_EXPLOSIONS);
        Config.initOresOreExplosionOresConfig(cfg, CATEGORY_ORES__ORE_EXPLOSIONS__ORE_EXPLOSION_ORES);
        Config.initRecipesFurnaceToItemsConfig(cfg, CATEGORY_RECIPES__FURNACE_TO_ITEMS);
        Config.initRecipesFurnaceToItemsFurnaceToItemOresConfig(cfg, CATEGORY_RECIPES__FURNACE_TO_ITEMS__FURNACE_TO_ITEM_ORES);
        Config.initRecipesIntegrationConfig(cfg, CATEGORY_RECIPES__INTEGRATION);
        Config.initRecipesIntegrationImmersiveEngineeringConfig(cfg, CATEGORY_RECIPES__INTEGRATION__IMMERSIVE_ENGINEERING);
        Config.initRecipesIntegrationThermalExpansionConfig(cfg, CATEGORY_RECIPES__INTEGRATION__THERMAL_EXPANSION);
        Config.initRecipesRecipeMultipliersConfig(cfg, CATEGORY_RECIPES__RECIPE_MULTIPLIERS);
        Config.initRecipesRecipeMultipliersRecipeMultiplierOresConfig(cfg, CATEGORY_RECIPES__RECIPE_MULTIPLIERS__RECIPE_MULTIPLIER_ORES);
    }

    private static void loadCategoryCommentStrings(ConfigEx cfg) {
        cfg.setCategoryComment(CATEGORY_GENERAL, "General Settings.");
        cfg.setCategoryComment(CATEGORY_MOBS, "Mob Settings.");
        cfg.setCategoryComment(CATEGORY_ORES, "Ore Settings.");
        cfg.setCategoryComment(CATEGORY_ORES__DROP_ITEMS, "If any of the following ores is set to true, that ore will drop items instead of ore blocks.\r\nRequires drop items to be enabled.\r\nThere is an override so all ores will drop items.");
        cfg.setCategoryComment(CATEGORY_RECIPES, "Recipe Settings.");
        cfg.setCategoryComment(CATEGORY_RECIPES__FURNACE_TO_ITEMS, "If any of the following ores is set to true, that item will furnace direct to item.\r\nRequires furnace to items to be enabled.\r\nThere is an override so all ores will smelt to item.");
        cfg.setCategoryComment(CATEGORY_RECIPES__INTEGRATION__IMMERSIVE_ENGINEERING, "Settings for Immersive Engineering machine processing.");
        cfg.setCategoryComment(CATEGORY_RECIPES__INTEGRATION__THERMAL_EXPANSION, "Settings for Thermal Expansion machine processing.\r\nPlease ask the mod author trab if you need assistance understanding how this works.");
        cfg.setCategoryComment(CATEGORY_RECIPES__RECIPE_MULTIPLIERS, "-1 = Only used by the override.\r\n 0 = No recipes/standard oredict, ideal for crafttweaker.\r\n     Oredict entries prefixed with \"neo\" for easy crafttweaker use.\r\n 1 = Oredict mode uses the same oredict name as the target ore, also adds recipe to craft target ore if needed.\r\n 2 = Crush to dust at 2x rate with mod specific bonuses | Smelt to 2x oredict ore.\r\n     Oredict entries prefixed with \"oreEnd\", \"oreNether\" or \"oreOverworld\" respectively.\r\n 3 = Crush to 4x oredict ore | Smelt to 3x oredict ore.\r\n     Oredict entries prefixed with \"oreDenseEnd\", \"oreDenseNether\" or \"oreDenseOverworld\" respectively.");
    }

    private static void initGeneralSettingsConfig(ConfigEx cfg, String category) {
        advancedDebugging = cfg.getBoolean("Advanced debugging", category, advancedDebugging, "Enable advanced debugging. Show all trace level messages in debug.log. Only enable if you really need it.");
    }

    private static void initMobsEndermiteConfig(ConfigEx cfg, String category) {
        endermiteEndermanHostility = cfg.getBoolean("Endermite Enderman hostility", category, endermiteEndermanHostility, "Player spawned Endermites from monster eggs are treated as hostile by Endermen. Can trap players in bad situations.");
        endermiteWAILA = cfg.getBoolean("Endermite waila/hwyla", category, endermiteWAILA, "Enables the Endermite spawn blocks to be hidden from WAILA/HWYLA i.e. show as End Stone.");
    }

    private static void initMobsNetherfishConfig(ConfigEx cfg, String category) {
        netherfishAttackDamage = cfg.getDouble("Netherfish attack damage", category, netherfishAttackDamage, 0.0, 1000.0, "Netherfish attack damage multiplier.");
        netherfishKnockbackResistance = cfg.getDouble("Netherfish knockback resistance", category, netherfishKnockbackResistance, 0.0, 100.0, "Netherfish knockback resistance multiplier.");
        netherfishMaxHealth = cfg.getDouble("Netherfish maximum health", category, netherfishMaxHealth, 1.0, 1000.0, "Netherfish maximum health in half hearts.");
        netherfishMovementSpeed = cfg.getDouble("Netherfish movement speed", category, netherfishMovementSpeed, 0.0, 1.0, "Netherfish movement speed multiplier.");
        netherfishSetFire = cfg.getBoolean("Netherfish set fire", category, netherfishSetFire, "Enables the Netherfish to set the player on fire during attack.");
        netherfishWAILA = cfg.getBoolean("Netherfish waila/hwyla", category, netherfishWAILA, "Enables the Netherfish spawn blocks to be hidden from WAILA/HWYLA i.e. show as Netherrack.");
    }

    private static void initMobsZombiePigmanConfig(ConfigEx cfg, String category) {
        zombiePigmanAnger = cfg.getBoolean("Zombie Pigman anger", category, zombiePigmanAnger, "Enables the Zombie Pigman anger reaction to mining ores.");
        zombiePigmanAngerRangeHeight = cfg.getInt("Zombie Pigman anger range height", category, zombiePigmanAngerRangeHeight, 1, 32, "Zombie Pigman anger reaction range height in blocks up and down of the player.");
        zombiePigmanAngerRangeRadius = cfg.getInt("Zombie Pigman anger range radius", category, zombiePigmanAngerRangeRadius, 1, 64, "Zombie Pigman anger reaction range square radius in blocks around the player.");
        zombiePigmanAngerSilkTouch = cfg.getBoolean("Zombie Pigman anger silk touch", category, zombiePigmanAngerSilkTouch, "If ores are mined with a silk touch enchantment Zombie pigmen won't react.");
    }

    private static void initOresOreDictionaryConfig(ConfigEx cfg, String category) {
        boolean setting = false;
        for (OreDictionaryOtherData oD : OreDictionaryOtherData.values()) {
            setting = cfg.getBoolean(oD.getModItemDescName(), category, oD.getDefaultSetting(), "Add " + oD.getModItemDescName() + " from " + oD.getModDescName() + " to the Ore Dictionary as " + oD.func_176610_l() + "." + oD.getConfigExtraDesc());
            oD.setEnabled(setting);
        }
    }

    private static void initOresOreDictionaryPreferredModsConfig(ConfigEx cfg, String category) {
        preferredMods = cfg.getBoolean("Preferred Mods Output", category, preferredMods, "Enable preferred mods outout, setting a mod name for an ore name makes the mod search for that name in the Ore Dictionary and use that as a priority.");
    }

    private static void initOresOreDictionaryPreferredModsOreDictionaryPreferredModOresConfig(ConfigEx cfg, String category) {
        String setting = "";
        for (BlockData blockData : BlockData.values()) {
            setting = cfg.getBlockProperty(blockData.func_176610_l(), category, blockData.getPreferredMod());
            blockData.setPreferredMod(setting);
        }
    }

    private static void initOresDropItems(ConfigEx cfg, String category) {
        dropItems = cfg.getBoolean("Drop items", category, dropItems, "Drop items instead of blocks from mined ores. Metallic ores will try to drop dusts over ingots.");
        dropItemsOverride = cfg.getBoolean("Drop items override", category, dropItemsOverride, "All ores will drop items ignoring per ore settings, drop items must be enabled or this will be ignored.");
    }

    private static void initOresDropItemsDropItemOres(ConfigEx cfg, String category) {
        for (BlockData blockData : BlockData.values()) {
            boolean setting = cfg.getBlockProperty(blockData.func_176610_l(), category, blockData.getDropItems());
            if (dropItems && dropItemsOverride) {
                setting = true;
            }
            if (!dropItems) {
                setting = false;
            }
            blockData.setDropItems(setting);
        }
    }

    private static void initOresOreExplosionsConfig(ConfigEx cfg, String category) {
        oreExplosion = cfg.getBoolean("Ore explosion", category, oreExplosion, "Enables the ability for ores to explode.");
        oreExplosionChance = cfg.getDouble("Ore explosion chance", category, oreExplosionChance, 0.0, 1.0, "Ore explosion chance, 1 = all the time.");
        oreExplosionFortune = cfg.getBoolean("Ore explosion fortune", category, oreExplosionFortune, "If ores are mined with a fortune enchantment their explosion chance is multiplied by the recipe multiplier. Only affects ores that are set to drop items.");
        oreExplosionOverride = cfg.getBoolean("Ore explosion override", category, oreExplosionOverride, "All ores will explode ignoring per ore settings, ore explosions must be enabled or this will be ignored.");
        oreExplosionSilkTouch = cfg.getBoolean("Ore explosion silk touch", category, oreExplosionSilkTouch, "If ores are mined with a silk touch enchantment they won't explode at all.");
        oreExplosionStrength = cfg.getDouble("Ore explosion strength", category, oreExplosionStrength, 0.0, 20.0, "Ore explosion strength, 4 = TNT strength.");
    }

    private static void initOresOreExplosionOresConfig(ConfigEx cfg, String category) {
        for (BlockData blockData : BlockData.values()) {
            boolean setting = cfg.getBlockProperty(blockData.func_176610_l(), category, blockData.getOreExplosion());
            if (oreExplosion && oreExplosionOverride) {
                setting = true;
            }
            if (!oreExplosion) {
                setting = false;
            }
            blockData.setOreExplosion(setting);
        }
    }

    private static void initRecipesFurnaceToItemsConfig(ConfigEx cfg, String category) {
        furnaceToItem = cfg.getBoolean("Furnace to item", category, furnaceToItem, "Enables the ability to furnace direct to items, recipe multiplier will control output count.");
        furnaceToItemOverride = cfg.getBoolean("Furnace to item override", category, furnaceToItemOverride, "All ores will furnace direct to items ignoring per ore settings, furnace to item must be enabled or this will be ignored.");
    }

    private static void initRecipesFurnaceToItemsFurnaceToItemOresConfig(ConfigEx cfg, String category) {
        for (BlockData blockData : BlockData.values()) {
            boolean setting = cfg.getBlockProperty(blockData.func_176610_l(), category, blockData.getFurnaceRecipeToItem());
            if (furnaceToItem && furnaceToItemOverride) {
                setting = true;
            }
            if (!furnaceToItem) {
                setting = false;
            }
            blockData.setFurnaceRecipeToItem(setting);
        }
    }

    private static void initRecipesIntegrationConfig(ConfigEx cfg, String category) {
        immersiveEngineeringRecipes = cfg.getBoolean("Immersive Engineering recipes", category, immersiveEngineeringRecipes, "Enable Immersive Engineering recipe integration.");
        industrialCraft2Recipes = cfg.getBoolean("Industrial Craft 2 recipes", category, industrialCraft2Recipes, "Enable Industrial Craft 2 recipe integration.");
        mekanismRecipes = cfg.getBoolean("Mekanism recipes", category, mekanismRecipes, "Enable Mekanism recipe integration.");
        thermalExpansionRecipes = cfg.getBoolean("Thermal Expansion recipes", category, thermalExpansionRecipes, "Enable Thermal Expansion recipe integration.");
        tinkersConstructRecipes = cfg.getBoolean("Tinkers' Construct recipes", category, tinkersConstructRecipes, "Enable Tinkers' Construct recipe integration.");
        vanillaCraftingRecipes = cfg.getBoolean("Vanilla crafting recipes", category, vanillaCraftingRecipes, "Enable crafting recipes to convert to oredict ores, only works with 1x recipe multiplier.");
        vanillaFurnaceRecipes = cfg.getBoolean("Vanilla furnace recipes", category, vanillaFurnaceRecipes, "Enable furnace recipes to smelt to oredict ores.");
    }

    private static void initRecipesIntegrationImmersiveEngineeringConfig(ConfigEx cfg, String category) {
        crusher2xOreTimeMultiplier = cfg.getFloat("Crusher 2x recipe multiplier time multiplier", category, crusher2xOreTimeMultiplier, 0.001f, 1000.0f, "Multiplies the crusher time taken at the 2x recipe multiplier by this amount.");
        crusher3xOreTimeMultiplier = cfg.getFloat("Crusher 3x recipe multiplier time multiplier", category, crusher3xOreTimeMultiplier, 0.001f, 1000.0f, "Multiplies the crusher time taken at the 3x recipe multiplier by this amount.");
    }

    private static void initRecipesIntegrationThermalExpansionConfig(ConfigEx cfg, String category) {
        inductionSmelterFullOutput = cfg.getBoolean("Induction Smelter full output", category, inductionSmelterFullOutput, "Enable full Induction Smelter output. Do not reduce output for augment compensation, uses much more energy.");
        inductionSmelterFullOutputAmountFactor = cfg.getFloat("Induction Smelter full output amount factor", category, inductionSmelterFullOutputAmountFactor, 0.5f, 3.0f, "Induction Smelter full output amount factor.");
        inductionSmelterFullOutputEnergyFactor = cfg.getFloat("Induction Smelter full output energy factor", category, inductionSmelterFullOutputEnergyFactor, 0.5f, 3.0f, "Induction Smelter full output energy factor.");
        inductionSmelterReducedOutputAmountFactor = cfg.getFloat("Induction Smelter reduced output amount factor", category, inductionSmelterReducedOutputAmountFactor, 0.5f, 1.0f, "Induction Smelter reduced output amount factor.");
        inductionSmelterReducedOutputEnergyFactor = cfg.getFloat("Induction Smelter reduced output energy factor", category, inductionSmelterReducedOutputEnergyFactor, 0.5f, 1.0f, "Induction Smelter reduced output energy factor.");
        pulverizerFullOutput = cfg.getBoolean("Pulverizer full output", category, pulverizerFullOutput, "Enable full Pulverizer output. Do not reduce output for augment compensation, uses much more energy.");
        pulverizerFullOutputAmountFactor = cfg.getFloat("Pulverizer full output amount factor", category, pulverizerFullOutputAmountFactor, 0.5f, 3.0f, "Pulverizer full output amount factor.");
        pulverizerFullOutputEnergyFactor = cfg.getFloat("Pulverizer full output energy factor", category, pulverizerFullOutputEnergyFactor, 0.5f, 3.0f, "Pulverizer full output energy factor.");
        pulverizerReducedOutputAmountFactor = cfg.getFloat("Pulverizer reduced output amount factor", category, pulverizerReducedOutputAmountFactor, 0.5f, 1.0f, "Pulverizer reduced output amount factor.");
        pulverizerReducedOutputEnergyFactor = cfg.getFloat("Pulverizer reduced output energy factor", category, pulverizerReducedOutputEnergyFactor, 0.5f, 1.0f, "Pulverizer reduced output energy factor.");
        redstoneFurnaceFullOutput = cfg.getBoolean("Redstone Furnace full output", category, redstoneFurnaceFullOutput, "Enable full Redstone Furnace output. Do not reduce output for augment compensation, uses much more energy.");
        redstoneFurnaceFullOutputAmountFactor = cfg.getFloat("Redstone Furnace full output amount factor", category, redstoneFurnaceFullOutputAmountFactor, 0.5f, 3.0f, "Redstone Furnace full output amount factor.");
        redstoneFurnaceFullOutputEnergyFactor = cfg.getFloat("Redstone Furnace full output energy factor", category, redstoneFurnaceFullOutputEnergyFactor, 0.5f, 3.0f, "Redstone Furnace full output energy factor.");
        redstoneFurnaceReducedOutputAmountFactor = cfg.getFloat("Redstone Furnace reduced output amount factor", category, redstoneFurnaceReducedOutputAmountFactor, 0.5f, 1.0f, "Redstone Furnace reduced output amount factor.");
        redstoneFurnaceReducedOutputEnergyFactor = cfg.getFloat("Redstone Furnace reduced output energy factor", category, redstoneFurnaceReducedOutputEnergyFactor, 0.5f, 1.0f, "Redstone Furnace reduced output energy factor.");
    }

    private static void initRecipesRecipeMultipliersConfig(ConfigEx cfg, String category) {
        recipeMultiplierOverride = cfg.getInt("Override Multipliers", category, recipeMultiplierOverride, recipeMultiplierOverrideMin, 3, "Change this setting to override all recipe multipliers, -1 means ignore.");
        recipeMultiplierOverride = MathHelper.func_76125_a((int)recipeMultiplierOverride, (int)recipeMultiplierOverrideMin, (int)3);
    }

    private static void initRecipesRecipeMultipliersRecipeMultiplierOresConfig(ConfigEx cfg, String category) {
        for (BlockData blockData : BlockData.values()) {
            int setting = cfg.getBlockProperty(blockData.func_176610_l(), category, blockData.getRecipeMultiplier());
            setting = MathHelper.func_76125_a((int)setting, (int)0, (int)3);
            if (recipeMultiplierOverride > recipeMultiplierOverrideMin) {
                setting = MathHelper.func_76125_a((int)recipeMultiplierOverride, (int)0, (int)3);
            }
            blockData.setRecipeMultiplier(setting);
        }
    }

    static {
        recipeMultiplierOverrideMin = recipeMultiplierOverride = -1;
    }
}

