/*
 * Decompiled with CFR 0.152.
 */
package moretweaker.betweenlands;

import com.blamejared.mtlib.helpers.InputHelper;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.ArrayList;
import moretweaker.Inputs;
import net.minecraft.entity.EntityList;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import thebetweenlands.api.IBetweenlandsAPI;
import thebetweenlands.api.recipes.IAnimatorRecipe;
import thebetweenlands.common.BetweenlandsAPI;
import thebetweenlands.common.recipe.misc.AnimatorRecipe;

@ZenClass(value="moretweaker.betweenlands.Animator")
@ZenRegister
@ModOnly(value="thebetweenlands")
public class Animator {
    @ZenMethod
    public static void addRecipe(IItemStack input, final int fuel, final int life, IItemStack output) {
        final ItemStack in = InputHelper.toStack((IItemStack)input);
        final ItemStack out = InputHelper.toStack((IItemStack)output);
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                AnimatorRecipe recipe = new AnimatorRecipe(in, fuel, life, out);
                BetweenlandsAPI.getInstance().registerAnimatorRecipe((IAnimatorRecipe)recipe);
            }

            public String describe() {
                return "Adds an animator recipe with item output";
            }
        });
    }

    @ZenMethod
    public static void addRecipe(IItemStack input, final int fuel, final int life, String entity) {
        final ItemStack in = InputHelper.toStack((IItemStack)input);
        final ResourceLocation entityLocation = new ResourceLocation(entity);
        final Class entityClass = EntityList.getClass((ResourceLocation)entityLocation);
        if (entityClass == null) {
            CraftTweakerAPI.logError((String)("No entity found for id: " + entity));
            return;
        }
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                AnimatorRecipe recipe = new AnimatorRecipe(in, fuel, life, entityClass);
                recipe.setRenderEntity(entityLocation);
                BetweenlandsAPI.getInstance().registerAnimatorRecipe((IAnimatorRecipe)recipe);
            }

            public String describe() {
                return "Adds an animator recipe with entity output";
            }
        });
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        final Object out = Inputs.getObject(output);
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                ArrayList recipes = new ArrayList();
                BetweenlandsAPI.getInstance().getAnimatorRecipes().forEach(r -> {
                    if (Inputs.matchesForRemoval(out, r.getResult(Animator.guessInput(r)))) {
                        recipes.add(r);
                    }
                });
                recipes.forEach(arg_0 -> ((IBetweenlandsAPI)BetweenlandsAPI.getInstance()).unregisterAnimatorRecipe(arg_0));
            }

            public String describe() {
                return "Removes some animator recipes by item output";
            }
        });
    }

    @ZenMethod
    public static void removeRecipe(String entityOutput) {
        ResourceLocation entityLocation = new ResourceLocation(entityOutput);
        final Class entityClass = EntityList.getClass((ResourceLocation)entityLocation);
        if (entityClass == null) {
            CraftTweakerAPI.logError((String)("No entity found for id: " + entityOutput));
            return;
        }
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                ArrayList recipes = new ArrayList();
                BetweenlandsAPI.getInstance().getAnimatorRecipes().forEach(r -> {
                    Class spawnClass = r.getSpawnEntityClass(Animator.guessInput(r));
                    if (spawnClass != null && entityClass.isAssignableFrom(spawnClass)) {
                        recipes.add(r);
                    }
                });
                recipes.forEach(arg_0 -> ((IBetweenlandsAPI)BetweenlandsAPI.getInstance()).unregisterAnimatorRecipe(arg_0));
            }

            public String describe() {
                return "Removes some animator recipes by entity output";
            }
        });
    }

    @ZenMethod
    public static void removeAll() {
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                ArrayList allRecipes = new ArrayList(BetweenlandsAPI.getInstance().getAnimatorRecipes());
                allRecipes.forEach(arg_0 -> ((IBetweenlandsAPI)BetweenlandsAPI.getInstance()).unregisterAnimatorRecipe(arg_0));
            }

            public String describe() {
                return "Removes all recipes for the Animator";
            }
        });
    }

    private static ItemStack guessInput(IAnimatorRecipe recipe) {
        if (recipe instanceof AnimatorRecipe) {
            return ((AnimatorRecipe)recipe).getInput();
        }
        return ItemStack.field_190927_a;
    }
}

