/*
 * Decompiled with CFR 0.152.
 */
package magicbees.integration.thaumcraft;

import com.google.common.base.Preconditions;
import forestry.api.recipes.RecipeManagers;
import forestry.apiculture.items.EnumPropolis;
import java.util.Arrays;
import magicbees.init.ItemRegister;
import magicbees.item.types.EnumCombType;
import magicbees.item.types.EnumPropolisType;
import magicbees.item.types.EnumResourceType;
import magicbees.item.types.EnumWaxType;
import magicbees.util.CentrifugeRecipe;
import magicbees.util.MagicBeesResourceLocation;
import magicbees.util.Utils;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.items.resources.ItemCrystalEssence;

public class ThaumcraftRecipes {
    static void addRecipes() {
        ThaumcraftRecipes.registerNormalRecipes();
        ThaumcraftRecipes.registerCentrifugeRecipes();
        ThaumcraftRecipes.registerCarpenterRecipes();
        ThaumcraftRecipes.registerThaumcraftRecipes();
    }

    private static void registerNormalRecipes() {
        ItemStack lf = ItemRegister.resourceItem.getStackFromType(EnumResourceType.LORE_FRAGMENT);
        GameRegistry.addShapedRecipe((ResourceLocation)new MagicBeesResourceLocation("lore_fragment"), null, (ItemStack)new ItemStack(ItemsTC.amber), (Object[])new Object[]{"lll", "lll", "lll", Character.valueOf('l'), lf});
        Arrays.stream(EnumResourceType.values()).filter(r -> r.toString().startsWith("TC_DUST_")).forEach(dust -> {
            Aspect aspect1;
            String aspect = dust.toString().replace("TC_DUST_", "").toLowerCase();
            try {
                aspect1 = (Aspect)Aspect.class.getDeclaredField(aspect.toUpperCase()).get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException("Aspect " + aspect + " not found.");
            }
            ItemCrystalEssence crystalEssence = (ItemCrystalEssence)ItemsTC.crystalEssence;
            ItemStack result = new ItemStack((Item)crystalEssence);
            crystalEssence.setAspects(result, new AspectList().add((Aspect)Preconditions.checkNotNull((Object)aspect1), 8));
            GameData.register_impl((IForgeRegistryEntry)new ShapelessRecipes("", result, NonNullList.func_191197_a((int)4, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemRegister.resourceItem.getStackFromType((EnumResourceType)dust)}))).setRegistryName((ResourceLocation)new MagicBeesResourceLocation("tc_shard_" + aspect)));
        });
    }

    private static void registerCentrifugeRecipes() {
        ItemStack magicWax = ItemRegister.waxItem.getStackFromType(EnumWaxType.MAGIC);
        ItemStack propolis = Utils.getApicultureItems().propolis.get(EnumPropolis.NORMAL, 1);
        CentrifugeRecipe recipe = new CentrifugeRecipe(EnumCombType.TC_AIR);
        recipe.addProduct(magicWax, 1.0f);
        recipe.addProduct(new ItemStack(Items.field_151008_G), 0.6f);
        recipe.addProduct(ThaumcraftRecipes.getPropolis(EnumPropolisType.AIR), 0.8f);
        recipe.register(20);
        recipe = new CentrifugeRecipe(EnumCombType.TC_FIRE);
        recipe.addProduct(magicWax, 1.0f);
        recipe.addProduct(new ItemStack(Items.field_151065_br), 0.6f);
        recipe.addProduct(ThaumcraftRecipes.getPropolis(EnumPropolisType.FIRE), 0.8f);
        recipe.register(20);
        recipe = new CentrifugeRecipe(EnumCombType.TC_WATER);
        recipe.addProduct(magicWax, 1.0f);
        recipe.addProduct(new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.LIGHT_BLUE.func_176765_a()), 0.6f);
        recipe.addProduct(ThaumcraftRecipes.getPropolis(EnumPropolisType.WATER), 0.8f);
        recipe.register(20);
        recipe = new CentrifugeRecipe(EnumCombType.TC_EARTH);
        recipe.addProduct(magicWax, 1.0f);
        recipe.addProduct(new ItemStack(Items.field_151119_aD), 0.6f);
        recipe.addProduct(ThaumcraftRecipes.getPropolis(EnumPropolisType.EARTH), 0.8f);
        recipe.register(20);
        recipe = new CentrifugeRecipe(EnumCombType.TC_ORDER);
        recipe.addProduct(magicWax, 1.0f);
        recipe.addProduct(new ItemStack(Items.field_151137_ax), 0.6f);
        recipe.addProduct(ThaumcraftRecipes.getPropolis(EnumPropolisType.ORDER), 0.8f);
        recipe.register(20);
        recipe = new CentrifugeRecipe(EnumCombType.TC_ENTROPY);
        recipe.addProduct(magicWax, 1.0f);
        recipe.addProduct(new ItemStack(Items.field_151016_H), 0.6f);
        recipe.addProduct(ThaumcraftRecipes.getPropolis(EnumPropolisType.ENTROPY), 0.8f);
        recipe.register(20);
        recipe = new CentrifugeRecipe(EnumPropolisType.AIR);
        recipe.addProduct(propolis, 1.0f);
        recipe.addProduct(ThaumcraftRecipes.getResource(EnumResourceType.TC_DUST_AIR), 0.9f);
        recipe.register(8);
        recipe = new CentrifugeRecipe(EnumPropolisType.FIRE);
        recipe.addProduct(propolis, 1.0f);
        recipe.addProduct(ThaumcraftRecipes.getResource(EnumResourceType.TC_DUST_FIRE), 0.9f);
        recipe.register(8);
        recipe = new CentrifugeRecipe(EnumPropolisType.WATER);
        recipe.addProduct(propolis, 1.0f);
        recipe.addProduct(ThaumcraftRecipes.getResource(EnumResourceType.TC_DUST_WATER), 0.8f);
        recipe.register(8);
        recipe = new CentrifugeRecipe(EnumPropolisType.EARTH);
        recipe.addProduct(propolis, 1.0f);
        recipe.addProduct(ThaumcraftRecipes.getResource(EnumResourceType.TC_DUST_EARTH), 0.8f);
        recipe.register(8);
        recipe = new CentrifugeRecipe(EnumPropolisType.ORDER);
        recipe.addProduct(propolis, 1.0f);
        recipe.addProduct(ThaumcraftRecipes.getResource(EnumResourceType.TC_DUST_ORDER), 0.8f);
        recipe.register(8);
        recipe = new CentrifugeRecipe(EnumPropolisType.ENTROPY);
        recipe.addProduct(propolis, 1.0f);
        recipe.addProduct(ThaumcraftRecipes.getResource(EnumResourceType.TC_DUST_ENTROPY), 0.8f);
        recipe.register(8);
    }

    private static void registerCarpenterRecipes() {
        RecipeManagers.carpenterManager.addRecipe(200, new FluidStack(FluidRegistry.WATER, 1000), ItemStack.field_190927_a, new ItemStack(ItemRegister.thaumaturgeBackpackT2), new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), Items.field_151045_i, Character.valueOf('W'), Utils.getCoreItems().craftingMaterial.getWovenSilk(), Character.valueOf('T'), new ItemStack(ItemRegister.thaumaturgeBackpackT1)});
    }

    private static void registerThaumcraftRecipes() {
    }

    private static ItemStack getPropolis(EnumPropolisType propolis) {
        return ItemRegister.propolisItem.getStackFromType(propolis);
    }

    private static ItemStack getResource(EnumResourceType resource) {
        return ItemRegister.resourceItem.getStackFromType(resource);
    }
}

