/*
 * Decompiled with CFR 0.152.
 */
package magicbees.bees;

import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IAlleleBeeSpeciesBuilder;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.climate.IClimateProvider;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleEffect;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IMutationCondition;
import java.util.function.IntFunction;
import javax.annotation.Nonnull;
import magicbees.bees.EnumBeeSpecies;
import magicbees.elec332.corerepack.compat.forestry.EffectData;
import magicbees.elec332.corerepack.compat.forestry.ForestryAlleles;
import magicbees.elec332.corerepack.compat.forestry.allele.AlleleEffectThrottled;
import magicbees.elec332.corerepack.compat.forestry.allele.AlleleFlowerProvider;
import magicbees.elec332.corerepack.compat.forestry.bee.BeeGenomeTemplate;
import magicbees.util.MagicBeesResourceLocation;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class BeeIntegrationInterface {
    public static final ResourceLocation bot_flowers_name = new MagicBeesResourceLocation("flowersBotania");
    public static final ResourceLocation bot_dreaming_name = new MagicBeesResourceLocation("effectDreaming");
    public static final ResourceLocation te_spawnBlizz_name = new MagicBeesResourceLocation("spawnBlizz");
    public static final ResourceLocation te_spawnBlitz_name = new MagicBeesResourceLocation("spawnBlitz");
    public static final ResourceLocation te_spawnBasalz_name = new MagicBeesResourceLocation("spawnBasalz");
    public static final ResourceLocation tc_visRecharge_name = new MagicBeesResourceLocation("visRecharge");
    public static final ResourceLocation tc_nodeEmpower_name = new MagicBeesResourceLocation("nodeEmpower");
    public static final ResourceLocation tc_nodeRepair_name = new MagicBeesResourceLocation("nodeRepair");
    public static final ResourceLocation tc_nodeConversionTaint_name = new MagicBeesResourceLocation("nodeConversionTaint");
    public static final ResourceLocation tc_nodeConversionPure_name = new MagicBeesResourceLocation("nodeConversionPure");
    public static final ResourceLocation tc_nodeConversionHungry_name = new MagicBeesResourceLocation("nodeConversionHungry");
    public static final ResourceLocation tc_spawnWhisp_name = new MagicBeesResourceLocation("spawnWhisp");
    public static final ResourceLocation tc_flowers_name = new MagicBeesResourceLocation("flowersThaumcraft");
    public static final ResourceLocation tc_flowersAuraNode_name = new MagicBeesResourceLocation("flowersThaumcraftAuraNode");
    public static IBlockState blockRSAFluxedElectrum;
    public static ItemStack itemRSAFluxedElectrumNugget;
    public static IAlleleEffect effectSpawnBlizz;
    public static IAlleleEffect effectSpawnBlitz;
    public static IAlleleEffect effectSpawnBasalz;
    public static AlleleFlowerProvider flowersBotania;
    public static IAlleleEffect effectDreaming;
    public static IBlockState livingWood;
    public static IBlockState aeSkyStone;
    public static Item itemPetal;
    public static Item itemPastureSeed;
    public static Item itemManaResource;
    public static int seedTypes;
    public static AlleleFlowerProvider flowerAuraNode;
    public static AlleleFlowerProvider flowersThaumcraft;
    public static IAlleleEffect effectNodeEmpower;
    public static IAlleleEffect effectNodeRepair;
    public static IAlleleEffect effectNodeConversionTaint;
    public static IAlleleEffect effectNodeConversionPure;
    public static IAlleleEffect effectNodeConversionHungry;
    public static IAlleleEffect effectVisRecharge;
    public static IAlleleEffect effectSpawnWhisp;
    public static Block blockTCAirShard;
    public static Block blockTCFireShard;
    public static Block blockTCWaterShard;
    public static Block blockTCEarthShard;
    public static Block blockTCOrderShard;
    public static Block blockTCEntropyShard;
    public static Block blockTCFluxShard;
    public static IntFunction<IMutationCondition> TCVisMutationRequirement;
    public static ItemStack zombieBrain;
    public static ItemStack nuggetPork;
    public static ItemStack nuggetBeef;
    public static ItemStack nuggetChicken;
    public static ItemStack voidMetalNugget;

    public static void getTemplateTE(BeeGenomeTemplate template) {
        BeeGenomeTemplate ret = new BeeGenomeTemplate();
        ret.setHumidityTolerance(ForestryAlleles.TOLERANCE_BOTH_2);
        ret.setTemperatureTolerance(ForestryAlleles.TOLERANCE_BOTH_2);
        ret.setToleratesRain(ForestryAlleles.TRUE_RECESSIVE);
        ret.setSpeed(ForestryAlleles.SPEED_FAST);
        ret.setFertility(ForestryAlleles.FERTILITY_HIGH);
        ret.setLifeSpan(ForestryAlleles.LIFESPAN_LONGER);
        for (int i = 1; i < ret.getAlleles().length; ++i) {
            template.getAlleles()[i] = ret.getAlleles()[i];
        }
    }

    public static void getTemplateTENether(BeeGenomeTemplate template) {
        BeeIntegrationInterface.getTemplateTE(template);
        template.setHumidityTolerance(ForestryAlleles.TOLERANCE_NONE);
        template.setTemperatureTolerance(ForestryAlleles.TOLERANCE_NONE);
        template.setCaveDwelling(ForestryAlleles.TRUE_RECESSIVE);
        template.setSpeed(ForestryAlleles.SPEED_SLOW);
        template.setFertility(ForestryAlleles.FERTILITY_NORMAL);
        template.setFlowerProvider(ForestryAlleles.FLOWERS_NETHER);
        template.setEffect((IAlleleEffect)EnumBeeSpecies.getForestryAllele("effectIgnition"));
        template.setNeverSleeps(ForestryAlleles.TRUE_RECESSIVE);
    }

    public static void getTemplateTEEnd(BeeGenomeTemplate template) {
        BeeIntegrationInterface.getTemplateTE(template);
        template.setNeverSleeps(ForestryAlleles.TRUE_RECESSIVE);
        template.setCaveDwelling(ForestryAlleles.TRUE_RECESSIVE);
        template.setSpeed(ForestryAlleles.SPEED_FASTEST);
        template.setLifeSpan(ForestryAlleles.LIFESPAN_LONGEST);
    }

    public static void addPetals(IAlleleBeeSpeciesBuilder species, float chance) {
        if (itemPetal == null) {
            return;
        }
        for (int i = 0; i < EnumDyeColor.values().length; ++i) {
            species.addSpecialty(new ItemStack(itemPetal, 1, i), Float.valueOf(chance));
        }
    }

    private BeeIntegrationInterface() {
        throw new RuntimeException();
    }

    private static IAlleleBeeEffect getPlaceholderEffect(ResourceLocation name) {
        return new AlleleEffectThrottled(name){

            @Override
            public IEffectData doEffectThrottled(IBeeGenome beeGenome, IEffectData effectData, IBeeHousing beeHousing) {
                return effectData;
            }

            @Override
            public IEffectData validateStorage(IEffectData effectData) {
                if (effectData == null) {
                    return new EffectData(1, 0, 0);
                }
                return effectData;
            }
        };
    }

    static {
        Item nullItem = Items.field_151162_bE;
        IBlockState nullBlock = Blocks.field_150327_N.func_176223_P();
        flowersBotania = new AlleleFlowerProvider(bot_flowers_name, ForestryAlleles.FLOWERS_VANILLA.getProvider());
        effectDreaming = BeeIntegrationInterface.getPlaceholderEffect(bot_dreaming_name);
        effectSpawnBlizz = BeeIntegrationInterface.getPlaceholderEffect(te_spawnBlizz_name);
        effectSpawnBlitz = BeeIntegrationInterface.getPlaceholderEffect(te_spawnBlitz_name);
        effectSpawnBasalz = BeeIntegrationInterface.getPlaceholderEffect(te_spawnBasalz_name);
        livingWood = aeSkyStone = nullBlock;
        blockRSAFluxedElectrum = aeSkyStone;
        itemPastureSeed = itemManaResource = nullItem;
        itemPetal = itemManaResource;
        itemRSAFluxedElectrumNugget = new ItemStack(nullItem);
        blockTCEntropyShard = blockTCFluxShard = Blocks.field_150483_bI;
        blockTCOrderShard = blockTCFluxShard;
        blockTCWaterShard = blockTCFluxShard;
        blockTCFireShard = blockTCFluxShard;
        blockTCEarthShard = blockTCFluxShard;
        blockTCAirShard = blockTCFluxShard;
        TCVisMutationRequirement = integer -> new IMutationCondition(){

            public float getChance(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IAllele allele0, @Nonnull IAllele allele1, @Nonnull IGenome genome0, @Nonnull IGenome genome1, @Nonnull IClimateProvider climate) {
                return 0.0f;
            }

            @Nonnull
            public String getDescription() {
                return "No mutations for you...";
            }
        };
        nuggetChicken = voidMetalNugget = new ItemStack(nullItem);
        nuggetBeef = voidMetalNugget;
        nuggetPork = voidMetalNugget;
        zombieBrain = voidMetalNugget;
        effectVisRecharge = BeeIntegrationInterface.getPlaceholderEffect(tc_visRecharge_name);
        effectNodeEmpower = BeeIntegrationInterface.getPlaceholderEffect(tc_nodeEmpower_name);
        effectNodeRepair = BeeIntegrationInterface.getPlaceholderEffect(tc_nodeRepair_name);
        effectNodeConversionTaint = BeeIntegrationInterface.getPlaceholderEffect(tc_nodeConversionTaint_name);
        effectNodeConversionPure = BeeIntegrationInterface.getPlaceholderEffect(tc_nodeConversionPure_name);
        effectNodeConversionHungry = BeeIntegrationInterface.getPlaceholderEffect(tc_nodeConversionHungry_name);
        effectSpawnWhisp = BeeIntegrationInterface.getPlaceholderEffect(tc_spawnWhisp_name);
        flowersThaumcraft = new AlleleFlowerProvider(tc_flowers_name, ForestryAlleles.FLOWERS_VANILLA.getProvider());
        flowerAuraNode = new AlleleFlowerProvider(tc_flowersAuraNode_name, ForestryAlleles.FLOWERS_VANILLA.getProvider());
    }
}

