/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.util;

import com.mcmoddev.lib.util.Config;
import com.mcmoddev.lib.util.IntegrationConfigOptions;
import java.io.File;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MMDLibConfig
extends Config {
    private static Configuration configuration;
    private static final String CONFIG_FILE = "config/MMDLib.cfg";
    private static final String GENERAL_CAT = "General";
    private static final String HAMMER_RECIPES_CAT = "Crack Hammer Recipes";
    private static final String TOOLS_CAT = "Tools and Items";
    private static final String MISC_CAT = "Miscelanneous Shared Settings";
    private static final IntegrationConfigOptions[] INTEGRATION_CONFIG_OPTIONS;

    @SubscribeEvent
    public void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("mmdlib")) {
            MMDLibConfig.init();
        }
    }

    public static void init() {
        if (configuration == null) {
            configuration = new Configuration(new File(CONFIG_FILE));
            MinecraftForge.EVENT_BUS.register((Object)new MMDLibConfig());
        }
        Config.Options.setRequireMMDOreSpawn(configuration.getBoolean("using_orespawn", GENERAL_CAT, true, "If false, then Base Metals will not require MMD Ore Spawn mod. \nSet to false if using another mod to manually handle ore generation."));
        Config.Options.setFallbackOreSpawn(configuration.getBoolean("fallback_orespawn", GENERAL_CAT, true, "disable this and using_orespawn to make MMDLib based mods not spawn any ores"));
        Config.Options.setDisableAllHammerRecipes(configuration.getBoolean("disable_crack_hammer", GENERAL_CAT, false, "If true, then the crack hammer cannot be crafted."));
        Config.Options.setEnforceHardness(configuration.getBoolean("enforce_hardness", GENERAL_CAT, true, "If true, then the crack hammer cannot crush ingots into powders if that \ncrackhammer is not hard enough to crush the ingot's ore."));
        Config.Options.setStrongHammers(configuration.getBoolean("strong_hammers", GENERAL_CAT, true, "If true, then the crack hammer can crush ingots/ores that a pickaxe of the same \nmaterial can harvest. If false, then your crack hammer must be made of a harder \nmaterial than the ore you are crushing."));
        Config.Options.setAutoDetectRecipes(configuration.getBoolean("automatic_recipes", GENERAL_CAT, true, "If true, then MMDLib will scan the Ore Dictionary to automatically add a \nCrack Hammer recipe for every material that has an ore, dust, and ingot."));
        Config.Options.setEnableAchievements(configuration.getBoolean("achievements", GENERAL_CAT, true, "If false, then MMDLib Achievements will be disabled (This is currently required if you disable any metals"));
        Config.Options.setCrackHammerFullStack(configuration.getBoolean("crackhammer_full_stacks", GENERAL_CAT, false, "If true then you can crackhammer full stacks of dropped items."));
        Config.Options.setEnablePlateRepairs(configuration.getBoolean("repair_using_plates", GENERAL_CAT, true, "Repair shields and armor with metal plates of the same type"));
        Config.Options.setEnableShieldUpgrades(configuration.getBoolean("upgrade_shields", GENERAL_CAT, true, "Upgrade a fully repaired shield to a material at least as hard as the shields current one using a plate of that material in the Anvil"));
        Config.Options.setTwoDustDrop(configuration.getBoolean("hammer_produces_two_dust", GENERAL_CAT, true, "If true, then the crack hammer when crushing ingots/ores two dust will drop"));
        Config.Options.thingEnabled("ic2withoutplugin", configuration.getBoolean("Enable IC2 Items", GENERAL_CAT, false, "Enable the items for IC2 support even if the IC2 plugin is disabled"));
        Config.Options.thingEnabled("mekwithoutplugin", configuration.getBoolean("Enable Mekanism Items", GENERAL_CAT, false, "Enable the items for Mekanism support even if the Mekanism plugin is disabled"));
        Config.Options.thingEnabled("villager_trades", configuration.getBoolean("Enable Villager Trades", GENERAL_CAT, true, "No, not the Village People, trades with Villagers.\nBasically... if you don't want BaseMetals (or other *Metals items and blocks) registered as trades with various villagers, set this to false"));
        Config.Options.thingEnabled("ic2withoutplugin", configuration.getBoolean("Enable IC2 Items", GENERAL_CAT, false, "Enable the items for IC2 support even if the IC2 plugin is disabled"));
        Config.Options.thingEnabled("mekwithoutplugin", configuration.getBoolean("Enable Mekanism Items", GENERAL_CAT, false, "Enable the items for Mekanism support even if the Mekanism plugin is disabled"));
        MMDLibConfig.configIntegrationOptions(INTEGRATION_CONFIG_OPTIONS, configuration);
        Config.Options.setGearQuantity(configuration.getInt("Gear Quantity", TOOLS_CAT, 4, 1, 64, "Number of Gears per recipe"));
        Config.Options.setPlateQuantity(configuration.getInt("Plate Quantity", TOOLS_CAT, 3, 1, 64, "Number of Plates per recipe"));
        Config.Options.setRodQuantity(configuration.getInt("Rod Quantity", TOOLS_CAT, 4, 1, 64, "Number of Rods per recipe"));
        Config.Options.setFurnaceCheese(configuration.getBoolean("Furnace Cheese", TOOLS_CAT, true, "Melt down armor and tools for full value"));
        Config.Options.setFurnace1112(configuration.getBoolean("Furnace1112", TOOLS_CAT, true, "Mimic 1.11.2 armor and tool melting.\n Overridden by Furnace Cheese"));
        Config.Options.thingEnabled("Basics", configuration.getBoolean("Enable Basics", TOOLS_CAT, true, "Set to false to disable: Nuggets, Ingots, Powders, Blends, Blocks and Ores"));
        Config.Options.thingEnabled("BasicTools", configuration.getBoolean("Enable Basic Tools", TOOLS_CAT, true, "Set to false to disable: Axe, Hoe, Pickaxe, Shovel and Sword"));
        Config.Options.thingEnabled("BowAndArrow", configuration.getBoolean("Enable Bow and Arrow", TOOLS_CAT, true, "Set to false to turn off custom bows and arrows"));
        Config.Options.thingEnabled("CrossbowAndBolt", configuration.getBoolean("Enable Crossbow and Bolts", TOOLS_CAT, true, "Set to false to disable custom crossbows and bolts"));
        Config.Options.thingEnabled("Armor", configuration.getBoolean("Enable Armor", TOOLS_CAT, true, "Set to false to disable: Helmet, Chestplate, Leggings and Boots"));
        Config.Options.thingEnabled("CrackHammer", configuration.getBoolean("Enable Crackhammer", TOOLS_CAT, true, "Why would you want to disable a valuable early-game tool ?\nThe question we're all asking though is will it blend?"));
        Config.Options.thingEnabled("FishingRod", configuration.getBoolean("Enable Fishing Rod", TOOLS_CAT, true, "Set to false to turn off added fishing rods"));
        Config.Options.thingEnabled("HorseArmor", configuration.getBoolean("Enable Horse Armor", TOOLS_CAT, true, "Set to false to disable extra Horse Armor"));
        Config.Options.thingEnabled("Shears", configuration.getBoolean("Enable Shears", TOOLS_CAT, true, "I love Shears, do you? If you're a Shears hater, set this to false"));
        Config.Options.thingEnabled("SmallDust", configuration.getBoolean("Enable Small Dust", TOOLS_CAT, true, "Turn this off to disable nugget-sized piles of dust.\n(Dust is a drug and drugs are bad. Don't do drugs, mmm-kay ?"));
        Config.Options.thingEnabled("Rod", configuration.getBoolean("Enable Rod", TOOLS_CAT, true, "Spare the Rod... Wait, no, that's Biblical...\nThis controls whether or not rods of various materials (similar to Tinkers' Construct Tool Rod) sare available"));
        Config.Options.thingEnabled("Gear", configuration.getBoolean("Enable Gear", TOOLS_CAT, true, "A lot of mods have Gears, we can provide them. Turn this off if you think you don't need them."));
        Config.Options.thingEnabled("Shield", configuration.getBoolean("Enable Shield", TOOLS_CAT, true, "The Combat Update brought Shields to Vanilla Minecraft. Turn this off if you don't want them to multiply"));
        Config.Options.thingEnabled("Bars", configuration.getBoolean("Enable Bars", TOOLS_CAT, true, "No, not the kind you drink at. The kind you find on jail-cells."));
        Config.Options.thingEnabled("Plate", configuration.getBoolean("Enable Plates", TOOLS_CAT, true, "IC2, Tech Reborn and a number of other mods require plates of material. This provides recipes for them."));
        Config.Options.thingEnabled("Door", configuration.getBoolean("Enable Door", TOOLS_CAT, true, "Doors of many wondrous materials"));
        Config.Options.thingEnabled("Trapdoor", configuration.getBoolean("Enable Trapdoors", TOOLS_CAT, true, "Do you want trapdoors? Because that's how you get trapdoors!"));
        Config.Options.thingEnabled("Button", configuration.getBoolean("Enable Buttons", TOOLS_CAT, true, "Ooooh, what does this button do?"));
        Config.Options.thingEnabled("Slab", configuration.getBoolean("Enable Slab", TOOLS_CAT, true, "Slabs of all the materials that get added"));
        Config.Options.thingEnabled("Lever", configuration.getBoolean("Enable Lever", TOOLS_CAT, true, "Levers of all different materials - they even have different hardness's"));
        Config.Options.thingEnabled("PressurePlate", configuration.getBoolean("Enable Pressure-plates", TOOLS_CAT, true, "Now your traps can be hidden in even more places!"));
        Config.Options.thingEnabled("Stairs", configuration.getBoolean("Enable Stairs", TOOLS_CAT, true, "Stairs of our wonderful metals! Come and get your own - or don't. It's up to you."));
        Config.Options.thingEnabled("Wall", configuration.getBoolean("Enable Wall", TOOLS_CAT, true, "Hey, Teachers! Leave those kids alone!"));
        Config.Options.thingEnabled("experimental", configuration.getBoolean("Enable Experimental", TOOLS_CAT, false, "Enable experimental features (Don't blame us if they burn down your cat or kill your house)"));
        Config.Options.setEnableModderSupportThings(configuration.getBoolean("Enable Mod Support", TOOLS_CAT, true, "Enable some pieces to support other mods and integrating with them (currently just 'casings' and 'dense plates')"));
        Config.Options.thingEnabled("anvil", Config.Options.isThingEnabled("experimental"));
        Config.Options.thingEnabled("bookshelf", Config.Options.isThingEnabled("experimental"));
        Config.Options.thingEnabled("flowerpot", Config.Options.isThingEnabled("experimental"));
        Config.Options.thingEnabled("ladder", Config.Options.isThingEnabled("experimental"));
        Config.Options.thingEnabled("tripwire", Config.Options.isThingEnabled("experimental"));
        Config.Options.thingEnabled("scythe", configuration.getBoolean("Enable Scythe", TOOLS_CAT, false, "Enable Scythe"));
        Config.Options.thingEnabled("enableFurnaceSmelting", configuration.getBoolean("enableFurnaceSmelting", MISC_CAT, true, "Enable Furnace Smelting"));
        Config.Options.thingEnabled("smeltToIngots", configuration.getBoolean("smeltToIngots", MISC_CAT, false, "By default some ores (Nether and End at this point) smelt to 2 standard ores - with this option you get 2 ingots"));
        Config.Options.thingEnabled("makeDusts", configuration.getBoolean("makeDusts", MISC_CAT, false, "Normally hitting a Some Ores with a Crackhammer gives you 2 more standard ores. With this option you get 4 dusts"));
        Config.Options.setDisabledRecipes(MMDLibConfig.parseDisabledRecipes(configuration.getString("DisabledCrackhammerRecipes", GENERAL_CAT, "", "Disable the recipes by putting the input materials ore dictionary name ore registry name in this key.\nThe format is a semicolon (;) separate list of ore dictionary names (ie:  oreGold;oreIron;oreCopper - this would blacklist Gold, Iron and Copper ores from working")));
        ConfigCategory userRecipeCat = configuration.getCategory(HAMMER_RECIPES_CAT);
        userRecipeCat.setComment("This section allows you to add your own recipes for the Crack Hammer (and other rock \ncrushers). Recipes are specified in semicolon (;) delimited lists of formulas in the \nformat modid:name#y->x*modid:name#y, where x is the number of items in a stack and y \nis the metadata value. Note that both x and y are optional, so you can use the \nformula modid:name->modid:name for most items/blocks. \n\nAll properties in this section will be parsed for formulas, regardless their name. \nThis lets you organize your recipe lists for easier reading.");
        if (userRecipeCat.keySet().isEmpty()) {
            Property prop = new Property("custom", "", Property.Type.STRING);
            prop.setComment("Example: minecraft:stained_glass#11->minecraft:dye#4; minecraft:wool->4*minecraft:string");
            userRecipeCat.put("custom", prop);
        }
        MMDLibConfig.manageUserHammerRecipes(userRecipeCat.values());
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    static {
        INTEGRATION_CONFIG_OPTIONS = new IntegrationConfigOptions[]{new IntegrationConfigOptions("Ender IO", "enderio", true), new IntegrationConfigOptions("IC2", "ic2", true), new IntegrationConfigOptions("Mekanism", "mekanism", true), new IntegrationConfigOptions("Thaumcraft", "thaumcraft", true), new IntegrationConfigOptions("Tinkers Construct", "tconstruct", true), new IntegrationConfigOptions("Constructs Armory", "conarm", true), new IntegrationConfigOptions("VeinMiner", "veinminer", true), new IntegrationConfigOptions("TAIGA", "taiga", true), new IntegrationConfigOptions("Dense Ores", "denseores", true), new IntegrationConfigOptions("Thermal Expansion", "thermalexpansion", true)};
    }
}

