/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.util;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public final class FluidUtils {
    private FluidUtils() {
    }

    @Nullable
    public static IFluidHandlerItem getHandler(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        return (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
    }

    public static boolean canFillFrom(IFluidTank tank, ItemStack source) {
        return FluidUtils.canFillFrom(tank, source, 0, 1000);
    }

    public static boolean canFillFrom(IFluidTank tank, ItemStack source, int minAmount, int maxAmount) {
        IFluidHandlerItem sourceHandler = FluidUtils.getHandler(source);
        return FluidUtils.canFillFrom(tank, sourceHandler, minAmount, maxAmount);
    }

    public static boolean canFillFrom(IFluidTank tank, @Nullable IFluidHandlerItem source) {
        return FluidUtils.canFillFrom(tank, source, 0, 1000);
    }

    public static boolean canFillFrom(IFluidTank tank, @Nullable IFluidHandlerItem source, int minAmount, int maxAmount) {
        if (source == null) {
            return false;
        }
        int actualMin = minAmount <= 0 ? maxAmount : minAmount;
        FluidStack fluid = source.drain(maxAmount, false);
        return fluid != null && fluid.amount >= actualMin && tank.fill(fluid, false) >= actualMin;
    }

    public static ItemStack fillFrom(IFluidTank tank, ItemStack source) {
        return FluidUtils.fillFrom(tank, source, 0, 1000);
    }

    public static ItemStack fillFrom(IFluidTank tank, ItemStack source, int minAmount, int maxAmount) {
        IFluidHandlerItem sourceHandler = FluidUtils.getHandler(source);
        return FluidUtils.fillFrom(tank, sourceHandler, minAmount, maxAmount);
    }

    public static ItemStack fillFrom(IFluidTank tank, @Nullable IFluidHandlerItem source) {
        return FluidUtils.fillFrom(tank, source, 0, 1000);
    }

    public static ItemStack fillFrom(IFluidTank tank, @Nullable IFluidHandlerItem source, int minAmount, int maxAmount) {
        int filled;
        if (source == null) {
            return ItemStack.field_190927_a;
        }
        int actualMin = minAmount <= 0 ? maxAmount : minAmount;
        FluidStack fluid = source.drain(maxAmount, false);
        if (fluid != null && fluid.amount >= actualMin && (filled = tank.fill(fluid, false)) >= actualMin) {
            tank.fill(fluid, true);
            source.drain(filled, true);
        }
        return source.getContainer();
    }

    public static boolean canDrainInto(IFluidTank tank, ItemStack target) {
        return FluidUtils.canDrainInto(tank, target, 0, 1000);
    }

    public static boolean canDrainInto(IFluidTank tank, ItemStack target, int minAmount, int maxAmount) {
        IFluidHandlerItem sourceHandler = FluidUtils.getHandler(target);
        return FluidUtils.canDrainInto(tank, sourceHandler, minAmount, maxAmount);
    }

    public static boolean canDrainInto(IFluidTank tank, @Nullable IFluidHandlerItem target) {
        return FluidUtils.canDrainInto(tank, target, 0, 1000);
    }

    public static boolean canDrainInto(IFluidTank tank, @Nullable IFluidHandlerItem target, int minAmount, int maxAmount) {
        if (target == null) {
            return false;
        }
        int actualMin = minAmount <= 0 ? maxAmount : minAmount;
        FluidStack fluid = tank.drain(maxAmount, false);
        return fluid != null && fluid.amount >= actualMin && target.fill(fluid, false) >= actualMin;
    }

    public static ItemStack drainInto(IFluidTank tank, ItemStack target) {
        return FluidUtils.drainInto(tank, target, 0, 1000);
    }

    public static ItemStack drainInto(IFluidTank tank, ItemStack target, int minAmount, int maxAmount) {
        IFluidHandlerItem sourceHandler = FluidUtils.getHandler(target);
        return FluidUtils.drainInto(tank, sourceHandler, minAmount, maxAmount);
    }

    public static ItemStack drainInto(IFluidTank tank, @Nullable IFluidHandlerItem target) {
        return FluidUtils.drainInto(tank, target, 0, 1000);
    }

    public static ItemStack drainInto(IFluidTank tank, @Nullable IFluidHandlerItem target, int minAmount, int maxAmount) {
        int filled;
        if (target == null) {
            return ItemStack.field_190927_a;
        }
        int actualMin = minAmount <= 0 ? maxAmount : minAmount;
        FluidStack fluid = tank.drain(maxAmount, false);
        if (fluid != null && fluid.amount >= actualMin && (filled = target.fill(fluid, false)) >= actualMin) {
            target.fill(fluid, true);
            tank.drain(filled, true);
        }
        return target.getContainer();
    }
}

