/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.tile;

import com.mcmoddev.lib.capability.CapabilitiesContainer;
import com.mcmoddev.lib.container.IWidgetContainer;
import com.mcmoddev.lib.container.gui.GuiContext;
import com.mcmoddev.lib.container.gui.IWidgetGui;
import com.mcmoddev.lib.container.gui.layout.VerticalStackLayout;
import com.mcmoddev.lib.container.widget.IWidget;
import com.mcmoddev.lib.feature.FeatureDirtyLevel;
import com.mcmoddev.lib.feature.IFeature;
import com.mcmoddev.lib.feature.IFeatureHolder;
import com.mcmoddev.lib.feature.IServerFeature;
import com.mcmoddev.lib.tile.MMDTileEntity;
import com.mcmoddev.lib.util.LoggingUtil;
import com.mcmoddev.lib.util.NBTUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MMDFeaturesTileEntity
extends MMDTileEntity
implements IFeatureHolder,
ITickable,
IWidgetContainer {
    private final List<IFeature> features = new ArrayList<IFeature>();
    private final CapabilitiesContainer capContainer = new CapabilitiesContainer();
    private final Map<FeatureDirtyLevel, Set<String>> dirtyFeatures = new HashMap<FeatureDirtyLevel, Set<String>>();

    protected MMDFeaturesTileEntity() {
    }

    @Override
    public <T extends IFeature> T addFeature(T feature) {
        this.features.add(feature);
        feature.setHolder(this);
        feature.initCapabilities(this.capContainer);
        this.featureChanged(feature, FeatureDirtyLevel.LOAD);
        return feature;
    }

    @Override
    public final IFeature[] getFeatures() {
        return this.features.toArray(new IFeature[this.features.size()]);
    }

    @Override
    public void featureChanged(IFeature feature, FeatureDirtyLevel level) {
        this.dirtyFeatures.putIfAbsent(level, new HashSet());
        this.dirtyFeatures.get((Object)level).add(feature.getKey());
        this.func_70296_d();
    }

    public final void func_73660_a() {
        for (IFeature feature : this.features) {
            if (!(feature instanceof ITickable)) continue;
            ((ITickable)feature).func_73660_a();
        }
        this.doWork();
        this.testForDirtyFeatures();
    }

    protected void doWork() {
    }

    protected void testForDirtyFeatures() {
        NBTTagCompound nbt;
        if (this.dirtyFeatures.size() > 0 && !this.func_145831_w().field_72995_K && (nbt = this.getFeaturesUpdateTag(FeatureDirtyLevel.TICK, true)).func_186856_d() > 0) {
            LoggingUtil.logNbtMessage(this, "TICK UPDATE TAG", (NBTBase)nbt);
            this.sendToListeningClients(nbt);
        }
    }

    @Override
    public List<IWidget> getWidgets(GuiContext context) {
        ArrayList<IWidget> widgets = new ArrayList<IWidget>();
        for (IFeature feature : this.features) {
            if (!(feature instanceof IWidgetContainer)) continue;
            IWidgetContainer container = (IWidgetContainer)((Object)feature);
            widgets.addAll(container.getWidgets(context));
        }
        return widgets;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IWidgetGui getRootWidgetGui(GuiContext context) {
        VerticalStackLayout layout = new VerticalStackLayout();
        for (IFeature feature : this.features) {
            if (!(feature instanceof IWidgetContainer)) continue;
            IWidgetContainer provider = (IWidgetContainer)((Object)feature);
            layout.addPiece(provider.getRootWidgetGui(context));
        }
        return layout;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound featuresNBT = new NBTTagCompound();
        for (IFeature feature : this.features) {
            NBTTagCompound nbt = (NBTTagCompound)feature.serializeNBT();
            if (nbt == null) continue;
            featuresNBT.func_74782_a(feature.getKey(), (NBTBase)nbt);
        }
        if (featuresNBT.func_186856_d() > 0) {
            LoggingUtil.logNbtMessage(this, "WRITE FEATURES NBT", (NBTBase)featuresNBT);
            compound.func_74782_a("features", (NBTBase)featuresNBT);
        }
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        if (compound.func_186856_d() >= 3) {
            super.func_145839_a(compound);
        }
        if (compound.func_150297_b("features", 10)) {
            NBTTagCompound featuresNBT = compound.func_74775_l("features");
            LoggingUtil.logNbtMessage(this, "READ FEATURES NBT", (NBTBase)featuresNBT);
            for (IFeature feature : this.features) {
                if (!featuresNBT.func_150297_b(feature.getKey(), 10)) continue;
                feature.deserializeNBT((NBTBase)featuresNBT.func_74775_l(feature.getKey()));
            }
        }
    }

    @Override
    @Nullable
    public NBTTagCompound getGuiUpdateTag(boolean resetDirtyFlag) {
        return this.getFeaturesUpdateTag(FeatureDirtyLevel.GUI, resetDirtyFlag);
    }

    private NBTTagCompound getFeaturesUpdateTag(FeatureDirtyLevel level, boolean resetDirtyFlag) {
        NBTTagCompound nbt = new NBTTagCompound();
        HashSet featureKeys = new HashSet();
        this.dirtyFeatures.forEach((key, value) -> {
            if (key.isMatchOrHigher(level)) {
                featureKeys.addAll(value);
            }
        });
        for (IFeature feature : this.features) {
            NBTTagCompound updateTag;
            if (!(feature instanceof IServerFeature) || !featureKeys.contains(feature.getKey()) || (updateTag = ((IServerFeature)IServerFeature.class.cast(feature)).getGuiUpdateTag(resetDirtyFlag)) == null) continue;
            nbt.func_74782_a(feature.getKey(), (NBTBase)updateTag);
        }
        this.dirtyFeatures.clear();
        return nbt.func_186856_d() > 0 ? NBTUtils.wrapCompound(nbt, "features") : nbt;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return this.capContainer.hasCapability(capability, facing) || this.features.stream().filter(f -> f instanceof ICapabilityProvider).anyMatch(f -> ((ICapabilityProvider)f).hasCapability(capability, facing)) || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        T cap = this.capContainer.getCapability(capability, facing);
        if (cap == null) {
            cap = this.features.stream().filter(f -> f instanceof ICapabilityProvider).map(f -> ((ICapabilityProvider)f).getCapability(capability, facing)).filter(Objects::nonNull).findFirst().orElse(null);
        }
        return (T)(cap != null ? cap : super.getCapability(capability, facing));
    }
}

