/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.proxy;

import com.mcmoddev.lib.capability.MMDCapabilities;
import com.mcmoddev.lib.container.MMDGuiHandler;
import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.events.MMDLibRegisterBlockTypes;
import com.mcmoddev.lib.events.MMDLibRegisterBlocks;
import com.mcmoddev.lib.events.MMDLibRegisterFluids;
import com.mcmoddev.lib.events.MMDLibRegisterItemTypes;
import com.mcmoddev.lib.events.MMDLibRegisterItems;
import com.mcmoddev.lib.events.MMDLibRegisterMaterialProperties;
import com.mcmoddev.lib.events.MMDLibRegisterMaterials;
import com.mcmoddev.lib.events.MMLibPreInitSync;
import com.mcmoddev.lib.init.Fluids;
import com.mcmoddev.lib.init.Items;
import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.init.Recipes;
import com.mcmoddev.lib.init.VillagerTrades;
import com.mcmoddev.lib.integration.IntegrationManager;
import com.mcmoddev.lib.material.MMDMaterial;
import com.mcmoddev.lib.oregen.FallbackGeneratorData;
import com.mcmoddev.lib.util.Config;
import com.mcmoddev.lib.util.MMDLibItemGroups;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class CommonProxy {
    public void preInit(FMLPreInitializationEvent event) {
        MMDGuiHandler.init();
        MMDCapabilities.init();
        MMDLibItemGroups.init();
        Materials.init();
        Items.init();
        Fluids.init();
        VillagerTrades.init();
        MinecraftForge.EVENT_BUS.post((Event)new MMDLibRegisterBlockTypes());
        MinecraftForge.EVENT_BUS.post((Event)new MMDLibRegisterItemTypes());
        Items.addToMetList();
        MinecraftForge.EVENT_BUS.post((Event)new MMDLibRegisterMaterialProperties());
        MinecraftForge.EVENT_BUS.post((Event)new MMDLibRegisterMaterials());
        MinecraftForge.EVENT_BUS.post((Event)new MMDLibRegisterBlocks());
        MinecraftForge.EVENT_BUS.post((Event)new MMDLibRegisterItems());
        MinecraftForge.EVENT_BUS.post((Event)new MMDLibRegisterFluids());
        Recipes.init();
        IntegrationManager.INSTANCE.preInit(event);
        MinecraftForge.EVENT_BUS.post((Event)new MMLibPreInitSync());
        IntegrationManager.INSTANCE.preInitPhase();
    }

    public void init(FMLInitializationEvent event) {
        for (MMDMaterial material : Materials.getAllMaterials()) {
            if (!material.hasBlock(Names.ORE)) continue;
            FallbackGeneratorData.getInstance().addMaterial(material.getName(), Names.ORE.toString(), material.getDefaultDimension());
            if (material.hasBlock(Names.NETHERORE)) {
                FallbackGeneratorData.getInstance().addMaterial(material.getName(), Names.NETHERORE.toString(), -1);
            }
            if (!material.hasBlock(Names.ENDORE)) continue;
            FallbackGeneratorData.getInstance().addMaterial(material.getName(), Names.ENDORE.toString(), 1);
        }
        MMDLibItemGroups.setupIcons("iron");
        IntegrationManager.INSTANCE.initPhase();
    }

    public void postInit(FMLPostInitializationEvent event) {
        Config.postInit();
        FallbackGeneratorData.getInstance().setup();
        IntegrationManager.INSTANCE.postInitPhase();
    }
}

