/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.oregen;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.material.MMDMaterial;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.feature.WorldGenMinable;

public class FallbackGeneratorData {
    private static final Map<Integer, Map<MMDMaterial, List<String>>> materials = new TreeMap<Integer, Map<MMDMaterial, List<String>>>();
    private static final FallbackGeneratorData INSTANCE = new FallbackGeneratorData();
    private static final Map<Integer, List<WorldGenMinable>> spawns = new HashMap<Integer, List<WorldGenMinable>>();

    private FallbackGeneratorData() {
    }

    public void addMaterial(@Nonnull String materialName, @Nonnull String blockName, @Nullable Integer dimension) {
        MMDMaterial mat = Materials.getMaterialByName(materialName);
        int targetDim = dimension != null ? dimension : Integer.MIN_VALUE;
        Map blockMap = materials.getOrDefault(targetDim, new HashMap());
        List blocks = blockMap.getOrDefault((Object)mat, new ArrayList());
        if (!blocks.contains(blockName)) {
            blocks.add(blockName);
        }
        blockMap.put(mat, blocks);
        materials.put(targetDim, blockMap);
    }

    public void setup() {
        for (Map.Entry<Integer, Map<MMDMaterial, List<String>>> matMap : materials.entrySet()) {
            Map<MMDMaterial, List<String>> mats = matMap.getValue();
            List spawnList = spawns.getOrDefault(matMap.getKey(), new ArrayList());
            Predicate<IBlockState> pred = this.getPredicateForDimension(matMap.getKey());
            for (Map.Entry<MMDMaterial, List<String>> matList : mats.entrySet()) {
                MMDMaterial mat = matList.getKey();
                matList.getValue().stream().forEach(blockName -> spawnList.add(new WorldGenMinable(mat.getBlock((String)blockName).func_176223_P(), mat.getSpawnSize() > 0 ? mat.getSpawnSize() : 8, pred)));
            }
            spawns.put(matMap.getKey(), spawnList);
        }
    }

    private Predicate<IBlockState> getPredicateForDimension(Integer key) {
        switch (key) {
            case -1: {
                return new NetherPredicate();
            }
            case 1: {
                return new EndPredicate();
            }
        }
        return new StonePredicate();
    }

    public List<WorldGenMinable> getSpawnsForDimension(int dimension) {
        return ImmutableList.copyOf((Collection)spawns.getOrDefault(dimension, Collections.emptyList()));
    }

    public static FallbackGeneratorData getInstance() {
        return INSTANCE;
    }

    static final class EndPredicate
    implements Predicate<IBlockState> {
        private EndPredicate() {
        }

        public boolean apply(@Nullable IBlockState comp) {
            if (comp != null) {
                Block b = comp.func_177230_c();
                return b.equals(Blocks.field_150377_bs);
            }
            return false;
        }
    }

    static final class NetherPredicate
    implements Predicate<IBlockState> {
        private NetherPredicate() {
        }

        public boolean apply(@Nullable IBlockState comp) {
            if (comp != null) {
                Block b = comp.func_177230_c();
                return b.equals(Blocks.field_150424_aL);
            }
            return false;
        }
    }

    static final class StonePredicate
    implements Predicate<IBlockState> {
        private StonePredicate() {
        }

        public boolean apply(@Nullable IBlockState comp) {
            if (comp != null && comp.func_177230_c() == Blocks.field_150348_b) {
                BlockStone.EnumType block = (BlockStone.EnumType)comp.func_177229_b((IProperty)BlockStone.field_176247_a);
                return block.func_190912_e();
            }
            return false;
        }
    }
}

