/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.network;

import com.mcmoddev.lib.MMDLib;
import com.mcmoddev.lib.network.INBTMessageReceiver;
import com.mcmoddev.lib.network.NBTBasedTileMessage;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class NBTBasedTileHandlerServer
implements IMessageHandler<NBTBasedTileMessage, IMessage> {
    public static final NBTBasedTileHandlerServer INSTANCE = new NBTBasedTileHandlerServer();

    private NBTBasedTileHandlerServer() {
    }

    @Nullable
    public IMessage onMessage(NBTBasedTileMessage message, MessageContext ctx) {
        FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
            int dimensionId = message.getDimensionId();
            WorldServer world = DimensionManager.getWorld((int)dimensionId);
            if (world != null) {
                BlockPos pos = new BlockPos(message.getPosX(), message.getPosY(), message.getPosZ());
                if (world.func_175667_e(pos)) {
                    Block block;
                    EntityPlayerMP sender = ctx.getServerHandler().field_147369_b;
                    TileEntity tile = world.func_175625_s(pos);
                    if (tile != null && tile instanceof INBTMessageReceiver) {
                        ((INBTMessageReceiver)tile).receiveFromClient(sender, message.getCompound());
                    }
                    if ((block = world.func_180495_p(pos).func_177230_c()) instanceof INBTMessageReceiver) {
                        ((INBTMessageReceiver)block).receiveFromClient(sender, message.getCompound());
                    }
                } else {
                    MMDLib.logger.error("Message received for a block position that is not loaded..");
                }
            } else {
                MMDLib.logger.error("Message received for an unknown dimension.");
            }
        });
        return null;
    }
}

