/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.item;

import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.item.MMDItemHelper;
import com.mcmoddev.lib.material.IMMDObject;
import com.mcmoddev.lib.material.MMDMaterial;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMMDPickaxe
extends ItemPickaxe
implements IMMDObject {
    private final MMDMaterial material;
    private final Set<String> toolTypes;

    public ItemMMDPickaxe(MMDMaterial material) {
        super(Materials.getToolMaterialFor(material));
        this.material = material;
        this.func_77656_e(this.material.getToolDurability());
        this.field_77864_a = this.material.getToolEfficiency();
        this.toolTypes = new HashSet<String>();
        this.toolTypes.add(Names.PICKAXE.toString());
    }

    public int func_77619_b() {
        return this.field_77862_b.func_77995_e();
    }

    public String func_77861_e() {
        return this.field_77862_b.toString();
    }

    public boolean func_82789_a(ItemStack intputItem, ItemStack repairMaterial) {
        return MMDItemHelper.isToolRepairable(repairMaterial, this.material.getCapitalizedName());
    }

    public boolean func_77644_a(ItemStack item, EntityLivingBase target, EntityLivingBase attacker) {
        super.func_77644_a(item, target, attacker);
        if (this.getMMDMaterial().hasEffect(item, target)) {
            this.getMMDMaterial().applyEffect(item, target);
        }
        return true;
    }

    public boolean func_150897_b(IBlockState target) {
        if (this.toolTypes.contains(target.func_177230_c().getHarvestTool(target))) {
            return this.material.getToolHarvestLevel() >= target.func_177230_c().getHarvestLevel(target);
        }
        return super.func_150897_b(target);
    }

    public void func_77622_d(ItemStack item, World world, EntityPlayer crafter) {
        super.func_77622_d(item, world, crafter);
        if (this.getMMDMaterial().hasEffect(item, crafter)) {
            this.getMMDMaterial().applyEffect(item, crafter);
        }
    }

    public void func_77663_a(ItemStack item, World world, Entity player, int inventoryIndex, boolean isHeld) {
        MMDItemHelper.doRegeneration(item, world, isHeld, this.material.regenerates());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        List<String> tt = this.getMMDMaterial().getTooltipFor(Names.PICKAXE);
        if (!tt.isEmpty()) {
            tooltip.addAll(tt);
        }
    }

    @Override
    public MMDMaterial getMMDMaterial() {
        return this.material;
    }
}

