/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.item;

import com.mcmoddev.lib.common.item.IHorseArmor;
import com.mcmoddev.lib.item.GenericMMDItem;
import com.mcmoddev.lib.material.MMDMaterial;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.HorseArmorType;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.EnumHelper;

public class ItemMMDHorseArmor
extends GenericMMDItem
implements IHorseArmor {
    private final HorseArmorType myArmorType;

    public ItemMMDHorseArmor(MMDMaterial material) {
        super(material);
        this.func_77625_d(1);
        this.myArmorType = ItemMMDHorseArmor.addArmorType(material.getName(), material.getHorseArmorProtection());
    }

    @Override
    public HorseArmorType getHorseArmorType(@Nullable ItemStack stack) {
        if (stack != null && stack.func_77973_b() != this) {
            return HorseArmorType.NONE;
        }
        return this.myArmorType;
    }

    @Override
    public String getHorseArmorTexture(EntityLiving entity, ItemStack stack) {
        return stack.func_77973_b() == this ? this.getArmorTexture() : "";
    }

    private String getArmorTexture() {
        return this.getRegistryName().func_110624_b() + ":textures/entity/horse/armor/horse_armor_" + this.getMMDMaterial().getName() + ".png";
    }

    private static HorseArmorType addArmorType(String materialName, int protectionLevel) {
        return (HorseArmorType)EnumHelper.addEnum(HorseArmorType.class, (String)("MMDLIB_" + materialName.toUpperCase(Locale.ROOT)), (Class[])new Class[]{Integer.TYPE, String.class, String.class}, (Object[])new Object[]{protectionLevel, materialName, "mmdlib_" + materialName});
    }
}

