/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.inventory;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandlerModifiable;

public abstract class ItemHandlerWrapper
implements IItemHandlerModifiable,
INBTSerializable<NBTTagCompound> {
    private final IItemHandlerModifiable internal;

    public ItemHandlerWrapper(IItemHandlerModifiable internal) {
        this.internal = internal;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.internal.setStackInSlot(slot, stack);
        this.onChanged(slot);
    }

    public int getSlots() {
        return this.internal.getSlots();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.internal.getStackInSlot(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        ItemStack result = this.internal.insertItem(slot, stack, simulate);
        if (!simulate && result.func_190916_E() != stack.func_190916_E()) {
            this.onChanged(slot);
        }
        return result;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack result = this.internal.extractItem(slot, amount, simulate);
        if (!simulate && !result.func_190926_b()) {
            this.onChanged(slot);
        }
        return result;
    }

    public int getSlotLimit(int slot) {
        return this.internal.getSlotLimit(slot);
    }

    protected abstract void onChanged(int var1);

    public NBTTagCompound serializeNBT() {
        return this.internal instanceof INBTSerializable ? (NBTTagCompound)((INBTSerializable)this.internal).serializeNBT() : new NBTTagCompound();
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (this.internal instanceof INBTSerializable) {
            ((INBTSerializable)this.internal).deserializeNBT((NBTBase)nbt);
        }
    }
}

