/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.inventory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class CombinedItemHandler
implements IItemHandler {
    protected final List<IItemHandler> handlers = new ArrayList<IItemHandler>();

    public CombinedItemHandler(IItemHandler ... handlers) {
        if (handlers.length > 0) {
            this.handlers.addAll(Arrays.asList(handlers));
        }
    }

    public void addItemHandler(IItemHandler handler) {
        this.handlers.add(handler);
    }

    @Nullable
    protected ItemHandlerPosition findActualSlot(int slotIn) {
        IItemHandler handler;
        int slots = 0;
        for (int handlerIndex = 0; slots <= slotIn && handlerIndex < this.handlers.size(); slots += handler.getSlots(), ++handlerIndex) {
            int local = slotIn - slots;
            handler = this.handlers.get(handlerIndex);
            if (local >= handler.getSlots()) continue;
            return new ItemHandlerPosition(handler, local);
        }
        return null;
    }

    public int getSlots() {
        return this.handlers.stream().mapToInt(IItemHandler::getSlots).sum();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        ItemHandlerPosition pos = this.findActualSlot(slot);
        return pos != null ? pos.handler.getStackInSlot(pos.slot) : ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        ItemHandlerPosition pos = this.findActualSlot(slot);
        return pos == null ? stack : pos.handler.insertItem(pos.slot, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemHandlerPosition pos = this.findActualSlot(slot);
        return pos == null ? ItemStack.field_190927_a : pos.handler.extractItem(pos.slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        ItemHandlerPosition pos = this.findActualSlot(slot);
        return pos == null ? 0 : pos.handler.getSlotLimit(pos.slot);
    }

    protected static class ItemHandlerPosition {
        final IItemHandler handler;
        final int slot;

        ItemHandlerPosition(IItemHandler handler, int slot) {
            this.handler = handler;
            this.slot = slot;
        }
    }
}

