/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.integration.plugins.tinkers.modifiers;

import com.mcmoddev.lib.energy.ForgeEnergyStorage;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.modifiers.ModifierTrait;
import slimeknights.tconstruct.library.tinkering.TinkersItem;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public class ModifierEnergized
extends ModifierTrait {
    public static final String KEY = "mmd_energized";
    public static final int ENERGY_PER_DAMAGE_POINT = 50;

    public ModifierEnergized() {
        super(KEY, Color.CYAN.getRGB());
        this.addItem(Items.field_151172_bF);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int onToolDamage(ItemStack tool, int damage, int newDamage, EntityLivingBase entity) {
        if (entity.func_130014_f_().field_72995_K) {
            return 0;
        }
        IEnergyStorage battery = (IEnergyStorage)tool.getCapability(CapabilityEnergy.ENERGY, null);
        if (battery != null) {
            int toDrain = newDamage * 50;
            int drained = battery.extractEnergy(toDrain, false);
            return toDrain == drained ? 0 : (toDrain - drained) / 50;
        }
        return newDamage;
    }

    public String getTooltip(NBTTagCompound modifierTag, boolean detailed) {
        return String.format("%d FE / %d FE", modifierTag.func_74762_e("energy"), modifierTag.func_74762_e("capacity"));
    }

    public List<String> getExtraInfo(ItemStack tool, NBTTagCompound modifierTag) {
        ArrayList<String> info = new ArrayList<String>();
        IEnergyStorage battery = (IEnergyStorage)tool.getCapability(CapabilityEnergy.ENERGY, null);
        if (battery != null) {
            info.add(String.format("%d FE / %d FE", battery.getEnergyStored(), battery.getMaxEnergyStored()));
        }
        return info;
    }

    @SubscribeEvent
    public void hackCapabilities(AttachCapabilitiesEvent<ItemStack> ev) {
        ItemStack stack = (ItemStack)ev.getObject();
        if (stack.func_77973_b() instanceof TinkersItem) {
            ev.addCapability(new ResourceLocation("mmdlib", KEY), new ForgeEnergyStorage(0, 42000).setInputRate(80).setoutputRate(80).getProviderForItemStack(stack, (s, c) -> {
                TinkersItem tinkers = s.func_77973_b() instanceof TinkersItem ? (TinkersItem)s.func_77973_b() : null;
                return tinkers != null && TinkerUtil.hasModifier((NBTTagCompound)TagUtil.getTagSafe((ItemStack)s), (String)KEY);
            }, (s, e) -> {
                if (e != null) {
                    NBTTagCompound nbt = TinkerUtil.getModifierTag((ItemStack)s, (String)KEY);
                    nbt.func_74768_a("energy", e.getEnergyStored());
                    nbt.func_74768_a("capacity", e.getMaxEnergyStored());
                }
            }));
        }
    }
}

