/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.integration.plugins.tinkers;

import com.mcmoddev.lib.data.MaterialStats;
import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.integration.plugins.tinkers.TraitRegistry;
import com.mcmoddev.lib.material.MMDMaterial;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import slimeknights.tconstruct.library.fluid.FluidMolten;
import slimeknights.tconstruct.library.materials.ArrowShaftMaterialStats;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.BowStringMaterialStats;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.FletchingMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.shared.TinkerFluids;

public class TCMaterial {
    private String name;
    private int tintColor;
    private MMDMaterial material;
    private Material tinkersMaterial;
    private boolean configured = false;
    private Map<String, List<String>> traits = new HashMap<String, List<String>>();
    private Map<String, List<ITrait>> resolvedTraits = new HashMap<String, List<ITrait>>();
    private Map<String, Integer> extraMelting = new HashMap<String, Integer>();
    private int headDurability;
    private float miningSpeed;
    private int miningLevel;
    private float headAttackDamage;
    private int bodyDurability;
    private float bodyModifier;
    private int extraDurability;
    private float bowDrawingSpeed;
    private float bowDamage;
    private float bowRange;
    private float bowstringModifier;
    private float shaftModifier;
    private float fletchingAccuracy;
    private float fletchingModifier;
    private int shaftBonusAmmo;
    private boolean castable = true;
    private boolean craftable = false;
    private int ingotAmount;
    private boolean toolForge = false;
    private Item repItem;
    private String repName;
    private HeadMaterialStats headStats;
    private HandleMaterialStats handleStats;
    private ExtraMaterialStats extraStats;
    private BowMaterialStats bowStats;
    private BowStringMaterialStats bowStringStats;
    private ArrowShaftMaterialStats arrowShaftStats;
    private FletchingMaterialStats fletchingStats;

    private TCMaterial() {
    }

    private TCMaterial(String name) {
        this();
        this.name = name;
    }

    private TCMaterial(String name, int color) {
        this(name);
        this.tintColor = color;
    }

    public TCMaterial(MMDMaterial material) {
        this();
        this.material = material;
        this.genStatsInternal();
    }

    public TCMaterial(MMDMaterial material, String name) {
        this(material);
        this.name = name;
    }

    public TCMaterial(MMDMaterial material, String name, int color) {
        this(material, name);
        this.tintColor = color;
    }

    public static TCMaterial get() {
        return new TCMaterial();
    }

    public static TCMaterial get(@Nonnull String name) {
        return new TCMaterial(name);
    }

    public static TCMaterial get(@Nonnull String name, @Nonnull int color) {
        return new TCMaterial(name, color);
    }

    public static TCMaterial get(@Nonnull MMDMaterial material) {
        return new TCMaterial(material);
    }

    public static TCMaterial get(@Nonnull MMDMaterial material, @Nonnull String name) {
        return new TCMaterial(material, name);
    }

    public static TCMaterial get(@Nonnull MMDMaterial material, @Nonnull String name, @Nonnull int color) {
        return new TCMaterial(material, name, color);
    }

    public void genStatsFromSource() {
        if (this.material != null) {
            this.genStatsInternal();
            this.configured = true;
        }
    }

    public TCMaterial addTrait(@Nonnull String location, @Nonnull String name) {
        List traitsAtLoc = this.traits.getOrDefault(location, new ArrayList());
        if (traitsAtLoc.contains(name)) {
            return this;
        }
        traitsAtLoc.add(name);
        this.traits.put(location, traitsAtLoc);
        return this;
    }

    public TCMaterial setSourceMaterial(@Nonnull MMDMaterial material) {
        this.material = material;
        if (this.name == null) {
            this.name = material.getName();
        }
        if (this.tintColor == 0) {
            this.tintColor = material.getTintColor();
        }
        return this;
    }

    public TCMaterial setCastable() {
        this.castable = true;
        this.craftable = !this.castable;
        this.configured = true;
        return this;
    }

    public TCMaterial setCraftable() {
        this.craftable = true;
        this.castable = !this.craftable;
        this.configured = true;
        return this;
    }

    public TCMaterial setHeadDurability(@Nonnull int durability) {
        this.headDurability = durability;
        this.configured = true;
        return this;
    }

    public TCMaterial setBodyDurability(@Nonnull int durability) {
        this.bodyDurability = durability;
        this.configured = true;
        return this;
    }

    public TCMaterial setExtraDurability(@Nonnull int durability) {
        this.extraDurability = durability;
        this.configured = true;
        return this;
    }

    public TCMaterial setMiningSpeed(@Nonnull float speed) {
        this.miningSpeed = speed;
        this.configured = true;
        return this;
    }

    public TCMaterial setminingLevel(@Nonnull int level) {
        this.miningLevel = level;
        this.configured = true;
        return this;
    }

    public TCMaterial setBodyModifier(@Nonnull float modifier) {
        this.bodyModifier = modifier;
        this.configured = true;
        return this;
    }

    public TCMaterial setBowDrawingSpeed(@Nonnull float drawingSpeed) {
        this.bowDrawingSpeed = drawingSpeed;
        this.configured = true;
        return this;
    }

    public TCMaterial setBowDamage(@Nonnull float damage) {
        this.bowDamage = damage;
        this.configured = true;
        return this;
    }

    public TCMaterial setBowRange(@Nonnull float range) {
        this.bowRange = range;
        this.configured = true;
        return this;
    }

    public TCMaterial setBowstringModifier(@Nonnull float modifier) {
        this.bowstringModifier = modifier;
        this.configured = true;
        return this;
    }

    public TCMaterial setShaftModifier(@Nonnull float modifier) {
        this.shaftModifier = modifier;
        this.configured = true;
        return this;
    }

    public TCMaterial setFletchingAccuracy(@Nonnull float accuracy) {
        this.fletchingAccuracy = accuracy;
        this.configured = true;
        return this;
    }

    public TCMaterial setFletchingModifier(@Nonnull float modifier) {
        this.fletchingModifier = modifier;
        this.configured = true;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public int getTintColor() {
        return this.tintColor;
    }

    public MMDMaterial getMMDMaterial() {
        return this.material;
    }

    public int getHeadDurability() {
        return this.headDurability;
    }

    public float getMiningSpeed() {
        return this.miningSpeed;
    }

    public int getMiningLevel() {
        return this.miningLevel;
    }

    public float getHeadAttackDamage() {
        return this.headAttackDamage;
    }

    public int getBodyDurability() {
        return this.bodyDurability;
    }

    public float getBodyModifier() {
        return this.bodyModifier;
    }

    public int getExtraDurability() {
        return this.extraDurability;
    }

    public float getBowDrawingSpeed() {
        return this.bowDrawingSpeed;
    }

    public float getBowDamage() {
        return this.bowDamage;
    }

    public float getBowRange() {
        return this.bowRange;
    }

    public float getBowstringModifier() {
        return this.bowstringModifier;
    }

    public float getShaftModifier() {
        return this.shaftModifier;
    }

    public float getFletchingAccuracy() {
        return this.fletchingAccuracy;
    }

    public float getFletchingModifier() {
        return this.fletchingModifier;
    }

    public int getShaftBonusAmmo() {
        return this.shaftBonusAmmo;
    }

    public boolean getCastable() {
        return this.castable;
    }

    public boolean getCraftable() {
        return this.craftable;
    }

    public HeadMaterialStats getHeadStats() {
        if (this.headStats == null) {
            this.headStats = new HeadMaterialStats(this.headDurability, this.miningSpeed, this.headAttackDamage, this.miningLevel);
        }
        return this.headStats;
    }

    public HandleMaterialStats getHandleStats() {
        if (this.handleStats == null) {
            this.handleStats = new HandleMaterialStats(this.bodyModifier, this.bodyDurability);
        }
        return this.handleStats;
    }

    public ExtraMaterialStats getExtraStats() {
        if (this.extraStats == null) {
            this.extraStats = new ExtraMaterialStats(this.extraDurability);
        }
        return this.extraStats;
    }

    public BowMaterialStats getBowStats() {
        if (this.bowStats == null) {
            this.bowStats = new BowMaterialStats(this.bowDrawingSpeed, this.bowRange, this.bowDamage);
        }
        return this.bowStats;
    }

    public BowStringMaterialStats getBowStringStats() {
        if (this.bowStringStats == null) {
            this.bowStringStats = new BowStringMaterialStats(this.bowstringModifier);
        }
        return this.bowStringStats;
    }

    public ArrowShaftMaterialStats getArrowStats() {
        if (this.arrowShaftStats == null) {
            this.arrowShaftStats = new ArrowShaftMaterialStats(this.shaftModifier, this.shaftBonusAmmo);
        }
        return this.arrowShaftStats;
    }

    public FletchingMaterialStats getFletchingStats() {
        if (this.fletchingStats == null) {
            this.fletchingStats = new FletchingMaterialStats(this.fletchingAccuracy, this.fletchingModifier);
        }
        return this.fletchingStats;
    }

    public Material getMaterial() {
        if (this.tinkersMaterial == null) {
            String posName = this.material != null ? this.material.getName() : "i_is_b0rken";
            String workingName = this.name != null ? this.name : posName;
            int posCol = this.material != null ? this.material.getTintColor() : -1;
            int color = this.tintColor != 0 ? this.tintColor : posCol;
            this.tinkersMaterial = new Material(workingName, color, false);
            if (this.name == null) {
                this.name = workingName;
            }
        }
        return this.tinkersMaterial;
    }

    public TCMaterial setHeadStats(HeadMaterialStats headStats) {
        this.headStats = headStats;
        this.headDurability = headStats.durability;
        this.headAttackDamage = headStats.attack;
        this.miningSpeed = headStats.miningspeed;
        this.miningLevel = headStats.harvestLevel;
        this.configured = true;
        return this;
    }

    public TCMaterial setHandleStats(HandleMaterialStats handleStats) {
        this.handleStats = handleStats;
        this.bodyDurability = handleStats.durability;
        this.bodyModifier = handleStats.modifier;
        this.configured = true;
        return this;
    }

    public TCMaterial setExtraStats(ExtraMaterialStats extraStats) {
        this.extraStats = extraStats;
        this.extraDurability = extraStats.extraDurability;
        this.configured = true;
        return this;
    }

    public TCMaterial setBowStats(BowMaterialStats bowStats) {
        this.bowStats = bowStats;
        this.bowDamage = bowStats.bonusDamage;
        this.bowDrawingSpeed = bowStats.drawspeed;
        this.bowRange = bowStats.range;
        this.configured = true;
        return this;
    }

    public TCMaterial setArrowShaftStats(ArrowShaftMaterialStats arrowShaftStats) {
        this.arrowShaftStats = arrowShaftStats;
        this.shaftBonusAmmo = arrowShaftStats.bonusAmmo;
        this.shaftModifier = arrowShaftStats.modifier;
        this.configured = true;
        return this;
    }

    public TCMaterial setBowStringStats(BowStringMaterialStats bowStringStats) {
        this.bowStringStats = bowStringStats;
        this.bowstringModifier = bowStringStats.modifier;
        this.configured = true;
        return this;
    }

    public TCMaterial setFletchingStats(FletchingMaterialStats fletchingStats) {
        this.fletchingStats = fletchingStats;
        this.fletchingAccuracy = fletchingStats.accuracy;
        this.fletchingModifier = fletchingStats.modifier;
        this.configured = true;
        return this;
    }

    private Fluid getActualFluid(@Nonnull MMDMaterial mat) {
        FluidMolten outFluid;
        switch (mat.getName()) {
            case "iron": {
                outFluid = TinkerFluids.iron;
                break;
            }
            case "gold": {
                outFluid = TinkerFluids.gold;
                break;
            }
            case "emerald": {
                outFluid = TinkerFluids.emerald;
                break;
            }
            case "aluminumbrass": {
                outFluid = TinkerFluids.alubrass;
                break;
            }
            case "aluminum": {
                outFluid = TinkerFluids.aluminum;
                break;
            }
            case "copper": {
                outFluid = TinkerFluids.copper;
                break;
            }
            case "brass": {
                outFluid = TinkerFluids.brass;
                break;
            }
            case "tin": {
                outFluid = TinkerFluids.tin;
                break;
            }
            case "bronze": {
                outFluid = TinkerFluids.bronze;
                break;
            }
            case "zinc": {
                outFluid = TinkerFluids.zinc;
                break;
            }
            case "lead": {
                outFluid = TinkerFluids.lead;
                break;
            }
            case "nickel": {
                outFluid = TinkerFluids.nickel;
                break;
            }
            case "silver": {
                outFluid = TinkerFluids.silver;
                break;
            }
            case "electrum": {
                outFluid = TinkerFluids.electrum;
                break;
            }
            case "steel": {
                outFluid = TinkerFluids.steel;
                break;
            }
            default: {
                outFluid = mat.getFluid();
            }
        }
        if (outFluid == null) {
            outFluid = FluidRegistry.getFluid((String)mat.getName());
        }
        return outFluid;
    }

    public Fluid getFluid() {
        return this.getActualFluid(this.material);
    }

    public TCMaterial setFluid(@Nonnull Fluid fluid) {
        Fluid f = this.getFluid();
        if (f.equals(fluid)) {
            this.tinkersMaterial.setFluid(fluid);
        } else {
            this.tinkersMaterial.setFluid(f);
        }
        return this;
    }

    public TCMaterial setIngotAmount(@Nonnull int amount) {
        this.ingotAmount = amount;
        return this;
    }

    public int getIngotAmount() {
        return this.ingotAmount;
    }

    public TCMaterial setRepresentativeItem(@Nullable String itemName) {
        this.repName = itemName;
        if (this.material != null) {
            this.repItem = this.material.hasItem(itemName) ? this.material.getItem(itemName) : (this.material.hasItem(Names.INGOT) ? this.material.getItem(Names.INGOT) : null);
        }
        return this;
    }

    public Item getRepresentativeItem() {
        this.setRepresentativeItem(Names.INGOT.toString());
        return this.repItem;
    }

    public String getRepresentativeItemName() {
        if (this.repName == null) {
            return "ingot" + this.material.getName();
        }
        return this.repName;
    }

    public TCMaterial setToolForge() {
        this.toolForge = true;
        return this;
    }

    public boolean toolForge() {
        return this.toolForge;
    }

    public TCMaterial addExtraMelting(@Nonnull String itemName, @Nonnull int fluidValue) {
        if (!this.extraMelting.containsKey(itemName)) {
            this.extraMelting.put(itemName, fluidValue);
        }
        return this;
    }

    public Map<String, Integer> getExtraMelting() {
        if (this.extraMelting.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.extraMelting);
    }

    public void settle() {
        if (this.tinkersMaterial == null) {
            this.tinkersMaterial = this.getMaterial();
            this.configured = false;
        }
        this.tinkersMaterial.setFluid(this.getFluid());
        this.tinkersMaterial.setVisible();
        if (!this.configured) {
            this.genStatsInternal();
            this.setHeadStats(this.getHeadStats());
            this.setBowStats(this.getBowStats());
            this.setBowStringStats(this.getBowStringStats());
            this.setExtraStats(this.getExtraStats());
            this.setHandleStats(this.getHandleStats());
            this.setArrowShaftStats(this.getArrowStats());
            this.setFletchingStats(this.getFletchingStats());
            if (this.ingotAmount == 0) {
                switch (this.material.getType()) {
                    case GEM: {
                        this.ingotAmount = 666;
                        break;
                    }
                    default: {
                        this.ingotAmount = 144;
                    }
                }
            }
        }
    }

    public void resolveTraits() {
        for (Map.Entry<String, List<String>> ent : this.traits.entrySet()) {
            String loc = ent.getKey();
            List resTraits = this.resolvedTraits.getOrDefault(loc, new ArrayList());
            for (String traitName : ent.getValue()) {
                ITrait temp = TraitRegistry.get(traitName);
                if (temp == null) continue;
                resTraits.add(temp);
            }
            this.resolvedTraits.put(loc, resTraits);
        }
    }

    public Map<String, List<ITrait>> getTraits() {
        if (this.resolvedTraits.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.resolvedTraits);
    }

    private void genStatsInternal() {
        this.headDurability = this.material.getToolDurability();
        this.miningSpeed = this.material.getStat(MaterialStats.HARDNESS) * 0.85f;
        this.miningLevel = this.material.getToolHarvestLevel();
        this.headAttackDamage = this.material.getBaseAttackDamage() * 2.0f;
        this.bodyDurability = this.material.getToolDurability() / 7;
        this.bodyModifier = (this.material.getStat(MaterialStats.HARDNESS) + this.material.getStat(MaterialStats.MAGICAFFINITY) * 2.0f) / 9.0f;
        this.extraDurability = this.material.getToolDurability() / 10;
        this.bowDrawingSpeed = this.calcDrawSpeed(this.material.getToolDurability());
        this.bowDamage = this.material.getBaseAttackDamage() + 3.0f;
        this.bowRange = 15.0f;
        this.bowstringModifier = 1.0f;
        this.shaftModifier = 1.0f;
        this.fletchingAccuracy = 1.0f;
        this.fletchingModifier = 1.0f;
        this.shaftBonusAmmo = 1;
    }

    private float calcDrawSpeed(int durability) {
        float val;
        if (durability < 204) {
            val = 1.0f;
        } else {
            val = (float)(durability - 200 + 1) / 10.0f;
            val = (float)((double)val - Math.floor(val));
        }
        return val;
    }
}

