/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.integration.plugins.tinkers;

import com.mcmoddev.lib.MMDLib;
import com.mcmoddev.lib.integration.plugins.tinkers.modifiers.ModifierFakeDiamond;
import com.mcmoddev.lib.integration.plugins.tinkers.modifiers.ModifierLeadPlated;
import com.mcmoddev.lib.integration.plugins.tinkers.modifiers.ModifierToxic;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.modifiers.Modifier;

public class ModifierRegistry {
    private static final Map<String, Modifier> modifiers = new HashMap<String, Modifier>();

    private ModifierRegistry() {
        throw new IllegalAccessError("Not an instantiable class");
    }

    public static void setModifierRecipe(@Nonnull String name, ItemStack ... ingredients) {
        Modifier t = modifiers.get(name);
        if (t == null) {
            MMDLib.logger.error("Trying to add a recipe to unknown modifier %s, ignoring.", (Object)name);
            return;
        }
        t.addRecipeMatch((RecipeMatch)new RecipeMatch.ItemCombination(1, ingredients));
        modifiers.put(name, t);
    }

    public static void setModifierItem(@Nonnull String name, @Nonnull ItemStack item) {
        ModifierRegistry.setModifierItem(name, item.func_77973_b());
    }

    public static void setModifierItem(@Nonnull String name, @Nonnull Item item) {
        Modifier t = modifiers.get(name);
        if (t == null) {
            MMDLib.logger.error("Trying to add an item to unknown modifier %s, ignoring.", (Object)name);
            return;
        }
        t.addItem(item);
        ((Modifier)TinkerRegistry.getModifier((String)t.getIdentifier())).addItem(item);
        modifiers.put(name, t);
    }

    public static void initModifiers() {
        modifiers.put("toxic", (Modifier)new ModifierToxic());
        modifiers.put("plated", (Modifier)new ModifierLeadPlated());
        modifiers.put("fake-diamond", (Modifier)new ModifierFakeDiamond());
    }

    public static void registerModifiers() {
    }

    public static Map<String, String> getModifierDetails(@Nonnull String name) {
        HashMap<String, String> rv = new HashMap<String, String>();
        if (modifiers.containsKey(name)) {
            Modifier t = modifiers.get(name);
            rv.put("name", t.getLocalizedName());
            rv.put("desc", t.getLocalizedDesc());
            return rv;
        }
        return Collections.emptyMap();
    }
}

