/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.integration.plugins;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mcmoddev.lib.MMDLib;
import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.integration.IIntegration;
import com.mcmoddev.lib.integration.IntegrationInitEvent;
import com.mcmoddev.lib.integration.IntegrationPostInitEvent;
import com.mcmoddev.lib.integration.IntegrationPreInitEvent;
import com.mcmoddev.lib.integration.plugins.tinkers.TinkerModifierRegistry;
import com.mcmoddev.lib.integration.plugins.tinkers.TinkerTraitLocation;
import com.mcmoddev.lib.integration.plugins.tinkers.TinkerTraitRegistry;
import com.mcmoddev.lib.integration.plugins.tinkers.TinkersMaterial;
import com.mcmoddev.lib.integration.plugins.tinkers.events.MaterialRegistrationEvent;
import com.mcmoddev.lib.integration.plugins.tinkers.events.ModifierRegistrationEvent;
import com.mcmoddev.lib.integration.plugins.tinkers.events.TinkersAlloyRecipeEvent;
import com.mcmoddev.lib.integration.plugins.tinkers.events.TinkersExtraMeltingsEvent;
import com.mcmoddev.lib.integration.plugins.tinkers.events.TraitRegistrationEvent;
import com.mcmoddev.lib.integration.plugins.tinkers.modifiers.ModifierFakeDiamond;
import com.mcmoddev.lib.integration.plugins.tinkers.modifiers.ModifierLeadPlated;
import com.mcmoddev.lib.integration.plugins.tinkers.modifiers.ModifierToxic;
import com.mcmoddev.lib.integration.plugins.tinkers.traits.MMDTraits;
import com.mcmoddev.lib.material.MMDMaterial;
import com.mcmoddev.lib.util.Config;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import org.apache.commons.lang3.tuple.Pair;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.smeltery.AlloyRecipe;
import slimeknights.tconstruct.library.traits.ITrait;

public class TinkersConstruct
implements IIntegration {
    public static final String PLUGIN_MODID = "tconstruct";
    private static boolean initDone = false;
    private static final IForgeRegistry<TinkersMaterial> materialsRegistry = new RegistryBuilder().disableSaving().setMaxID(65535).setName(new ResourceLocation("mmdlib", "tinker_registry")).setType(TinkersMaterial.class).create();
    private static final TinkerTraitRegistry traitsRegistry = new TinkerTraitRegistry();
    private static final TinkerModifierRegistry modifiersRegistry = new TinkerModifierRegistry();
    private static final List<Pair<FluidStack, List<FluidStack>>> alloys = Lists.newCopyOnWriteArrayList();
    private static final List<Pair<ItemStack, FluidStack>> extraMeltings = Lists.newCopyOnWriteArrayList();
    public static final TinkersConstruct INSTANCE = new TinkersConstruct();
    private static final Deque<Material> materialsToAdd = Queues.newArrayDeque();

    protected static IForgeRegistry<TinkersMaterial> getMaterialsRegistry() {
        return materialsRegistry;
    }

    protected static TinkerTraitRegistry getTraitsRegistry() {
        return traitsRegistry;
    }

    protected static TinkerModifierRegistry getModifiersRegistry() {
        return modifiersRegistry;
    }

    @Override
    public void init() {
        if (!TConstruct.pulseManager.isPulseLoaded("TinkerSmeltery")) {
            MMDLib.logger.fatal("module not enabled, not sending any cruft through");
            initDone = true;
            return;
        }
        if (!Config.Options.isModEnabled(PLUGIN_MODID) || initDone) {
            return;
        }
        initDone = true;
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.registerInternalTraits();
        this.registerInternalModifiers();
        MinecraftForge.EVENT_BUS.post((Event)new TraitRegistrationEvent(traitsRegistry));
        MinecraftForge.EVENT_BUS.post((Event)new ModifierRegistrationEvent(modifiersRegistry));
    }

    @SubscribeEvent
    public void preInit(IntegrationPreInitEvent event) {
        MinecraftForge.EVENT_BUS.post((Event)new MaterialRegistrationEvent(materialsRegistry));
        MinecraftForge.EVENT_BUS.post((Event)new TinkersAlloyRecipeEvent(materialsRegistry));
        MinecraftForge.EVENT_BUS.post((Event)new TinkersExtraMeltingsEvent());
        this.addMaterialStats();
        this.materialIntegrationPreInit();
        this.addMaterials();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void materialSetup(RegistryEvent.Register<IRecipe> ev) {
        this.setupMaterialItems();
    }

    @SubscribeEvent
    public void init(IntegrationInitEvent event) {
        this.addTraitsToMaterials();
        modifiersRegistry.get(new ResourceLocation("lead_plated")).addItem("plateLead");
        modifiersRegistry.get(new ResourceLocation("toxic")).addItem("dustMercury");
        this.setupExtraSmeltingRecipes();
        this.registerAlloys();
    }

    protected void setupMaterialItems() {
        materialsRegistry.getEntries().stream().forEach(ent -> {
            TinkersMaterial tm = (TinkersMaterial)ent.getValue();
            Material m = TinkerRegistry.getMaterial((String)tm.getName());
            MMDMaterial base = tm.getMMDMaterial();
            if (base.hasItem(Names.INGOT)) {
                m.setRepresentativeItem(base.getItem(Names.INGOT));
            } else if (base.hasItem(Names.ORE)) {
                m.setRepresentativeItem(base.getBlockItemStack(Names.ORE));
            }
            m.addCommonItems(base.getCapitalizedName());
        });
    }

    @SubscribeEvent
    public void postInit(IntegrationPostInitEvent event) {
    }

    public void addAlloyRecipe(String outputName, Integer outputAmount, Object ... recipe) {
        FluidStack output = FluidRegistry.getFluidStack((String)outputName, (int)outputAmount);
        CopyOnWriteArrayList ingredients = Lists.newCopyOnWriteArrayList();
        for (int i = 0; i < recipe.length; ++i) {
            if (recipe[i] instanceof String) {
                ingredients.add(FluidRegistry.getFluidStack((String)((String)recipe[i]), (int)((Integer)recipe[++i])));
                continue;
            }
            if (recipe[i] instanceof Fluid) {
                ingredients.add(new FluidStack((Fluid)recipe[i], ((Integer)recipe[++i]).intValue()));
                continue;
            }
            if (recipe[i] instanceof FluidStack) {
                ingredients.add((FluidStack)recipe[i]);
                continue;
            }
            throw new IllegalArgumentException(String.format("Item of unknown type %s (%s) for an alloy recipe found in recipe for %d mB of %s, parameter %d", recipe[i].getClass().getName(), recipe[i].toString(), outputAmount, outputName, i + 2));
        }
        alloys.add((Pair<FluidStack, List<FluidStack>>)Pair.of((Object)output, (Object)ingredients));
    }

    public void addExtraMelting(String outputFluid, Integer amount, Item item) {
        this.addExtraMelting(outputFluid, amount, new ItemStack(item));
    }

    public void addExtraMelting(String outputFluid, Integer amount, Block block) {
        this.addExtraMelting(outputFluid, amount, Item.func_150898_a((Block)block));
    }

    public void addExtraMelting(String outputFluid, Integer amount, ItemStack itemStack) {
        this.addExtraMelting(FluidRegistry.getFluidStack((String)outputFluid, (int)amount), itemStack);
    }

    public void addExtraMelting(FluidStack output, ItemStack itemStack) {
        extraMeltings.add((Pair<ItemStack, FluidStack>)Pair.of((Object)itemStack, (Object)output));
    }

    private void addMaterials() {
        while (!materialsToAdd.isEmpty()) {
            Material material = materialsToAdd.pop();
            if (TinkerRegistry.getMaterial((String)material.getIdentifier()) == Material.UNKNOWN) {
                TinkerRegistry.addMaterial((Material)material);
                continue;
            }
            if (!Config.Options.isForcedTrait(material.getIdentifier())) continue;
            this.addExistingMaterial(material);
        }
    }

    private void addExistingMaterial(Material material) {
        for (TinkerTraitLocation stat : TinkerTraitLocation.values()) {
            for (ITrait trait : material.getAllTraitsForStats(stat.toString())) {
                Material existingMaterial = TinkerRegistry.getMaterial((String)material.identifier);
                if (existingMaterial.hasTrait(trait.getIdentifier(), stat.toString())) continue;
                existingMaterial.addTrait(trait, stat.toString());
            }
        }
    }

    private void registerInternalTraits() {
        traitsRegistry.register("brittle", (ITrait)MMDTraits.brittle);
        traitsRegistry.register("heavy", (ITrait)MMDTraits.heavy);
        traitsRegistry.register("radioactive", (ITrait)MMDTraits.radioactive);
        traitsRegistry.register("reactive", (ITrait)MMDTraits.reactive);
        traitsRegistry.register("soft", (ITrait)MMDTraits.soft);
        traitsRegistry.register("sparkly", (ITrait)MMDTraits.sparkly);
        traitsRegistry.register("toxic", (ITrait)MMDTraits.toxic);
    }

    private void registerInternalModifiers() {
        modifiersRegistry.register(new ResourceLocation("fake_diamond"), (Modifier)new ModifierFakeDiamond());
        modifiersRegistry.register(new ResourceLocation("lead_plated"), (Modifier)new ModifierLeadPlated());
        modifiersRegistry.register(new ResourceLocation("toxic"), (Modifier)new ModifierToxic());
    }

    private void materialIntegrationPreInit() {
        materialsRegistry.getEntries().stream().forEach(ent -> {
            TinkersMaterial tm = (TinkersMaterial)ent.getValue();
            Material m = TinkerRegistry.getMaterial((String)tm.getName());
            MMDMaterial base = tm.getMMDMaterial();
            if (m == Material.UNKNOWN) {
                m = tm.create().getTinkerMaterial();
            }
            m.setCastable(tm.getCastable()).setCraftable(tm.getCraftable());
            m.addCommonItems(base.getCapitalizedName());
            m.setVisible();
            m.setFluid(base.getFluid());
            if (tm.getToolForge()) {
                TinkerRegistry.integrate((Material)m, (Fluid)base.getFluid(), (String)base.getCapitalizedName()).toolforge();
            } else {
                TinkerRegistry.integrate((Material)m, (Fluid)base.getFluid(), (String)base.getCapitalizedName());
            }
            if (!materialsToAdd.contains(m)) {
                materialsToAdd.addLast(m);
            }
        });
    }

    private void addMaterialStats() {
        materialsRegistry.getEntries().stream().map(ent -> (TinkersMaterial)ent.getValue()).forEach(mat -> TinkerRegistry.addMaterialStats((Material)mat.getTinkerMaterial(), (IMaterialStats)mat.getArrowShaftStats(), (IMaterialStats[])new IMaterialStats[]{mat.getBowStats(), mat.getBowStringStats(), mat.getFletchingStats(), mat.getHeadStats(), mat.getHandleStats(), mat.getExtraStats()}));
    }

    private void addTraitsToMaterials() {
        materialsRegistry.getEntries().stream().map(ent -> (TinkersMaterial)ent.getValue()).filter(tm -> tm.hasTraits()).forEach(tm -> tm.getTraits().stream().forEach(tp -> {
            ITrait trait = traitsRegistry.get((String)tp.getKey());
            Material m = TinkerRegistry.getMaterial((String)tm.getTinkerMaterial().getIdentifier());
            if (m == Material.UNKNOWN) {
                m = tm.getTinkerMaterial();
            }
            if (trait != null) {
                if (tp.getValue() == TinkerTraitLocation.GENERAL) {
                    m.addTrait(trait);
                } else {
                    String loc = ((TinkerTraitLocation)((Object)((Object)((Object)tp.getValue())))).toString().toLowerCase(Locale.US);
                    m.addTrait(trait, loc);
                }
            }
        }));
    }

    private void setupExtraSmeltingRecipes() {
        extraMeltings.stream().forEach(emt -> TinkerRegistry.registerMelting((ItemStack)((ItemStack)emt.getLeft()), (Fluid)((FluidStack)emt.getRight()).getFluid(), (int)((FluidStack)emt.getRight()).amount));
    }

    private void registerAlloys() {
        materialsRegistry.getEntries().stream().map(ent -> (TinkersMaterial)ent.getValue()).filter(tm -> tm.hasAlloyRecipe()).forEach(tm -> {
            List<FluidStack> rawRecipe = tm.getAlloyRecipe();
            FluidStack output = rawRecipe.get(0);
            CopyOnWriteArrayList inputs = Lists.newCopyOnWriteArrayList();
            for (int i = 1; i < rawRecipe.size(); ++i) {
                inputs.add(rawRecipe.get(i));
            }
            AlloyRecipe recipe = new AlloyRecipe(output, inputs.toArray(new FluidStack[inputs.size()]));
            TinkerRegistry.registerAlloy((AlloyRecipe)recipe);
        });
        alloys.stream().forEach(p -> {
            List inputs = (List)p.getRight();
            FluidStack output = (FluidStack)p.getLeft();
            AlloyRecipe recipe = new AlloyRecipe(output, inputs.toArray(new FluidStack[inputs.size()]));
            TinkerRegistry.registerAlloy((AlloyRecipe)recipe);
        });
    }

    public static void registerTableCasting(ItemStack output, ItemStack cast, Fluid fluid, int amount) {
        TinkerRegistry.registerTableCasting((ItemStack)output, (ItemStack)cast, (Fluid)fluid, (int)amount);
    }

    private static void registerBasinCasting(ItemStack output, ItemStack cast, Fluid fluid, int amount) {
        TinkerRegistry.registerBasinCasting((ItemStack)output, (ItemStack)cast, (Fluid)fluid, (int)amount);
    }

    public static void registerBasinCasting(ItemStack output, Fluid fluid, int amount) {
        TinkersConstruct.registerBasinCasting(output, ItemStack.field_190927_a, fluid, amount);
    }
}

