/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.integration.plugins;

import com.mcmoddev.lib.MMDLib;
import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.integration.IIntegration;
import com.mcmoddev.lib.material.MMDMaterial;
import com.mcmoddev.lib.util.Config;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.Recipes;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class IC2
implements IIntegration {
    public static final String PLUGIN_MODID = "ic2";

    @Override
    public void init() {
        if (!Config.Options.isModEnabled(PLUGIN_MODID)) {
            return;
        }
    }

    protected void addForgeHammerRecipe(@Nonnull String materialName) {
        this.addForgeHammerRecipe(Materials.getMaterialByName(materialName));
    }

    private void addForgeHammerRecipe(@Nonnull MMDMaterial material) {
        ItemStack plate = material.getItemStack("ItemBlock_" + material.getName() + "_plate", 1);
        ItemStack casing = material.getItemStack(Names.CASING, 2);
        if (plate.func_190926_b()) {
            return;
        }
        List<IRecipeInput> inputsPlate = Arrays.asList(Recipes.inputFactory.forOreDict("craftingToolForgeHammer"), Recipes.inputFactory.forOreDict("ingot" + material.getCapitalizedName()));
        List<IRecipeInput> inputsCasing = Arrays.asList(Recipes.inputFactory.forOreDict("craftingToolForgeHammer"), Recipes.inputFactory.forOreDict("plate" + material.getCapitalizedName()));
        Recipes.advRecipes.addShapelessRecipe(casing, inputsCasing.toArray());
        Recipes.advRecipes.addShapelessRecipe(plate, inputsPlate.toArray());
    }

    protected void registerVanillaRecipes(@Nonnull String materialName) {
        this.registerVanillaRecipes(Materials.getMaterialByName(materialName));
    }

    protected void registerVanillaRecipes(@Nonnull MMDMaterial material) {
        ItemStack ingot = material.getItemStack(Names.INGOT, 1);
        GameRegistry.addSmelting((ItemStack)material.getItemStack(Names.CRUSHED), (ItemStack)ingot, (float)0.0f);
        GameRegistry.addSmelting((ItemStack)material.getItemStack(Names.CRUSHED_PURIFIED), (ItemStack)ingot, (float)0.0f);
    }

    protected void addMaceratorRecipes(@Nonnull String materialName) {
        this.addMaceratorRecipes(Materials.getMaterialByName(materialName));
    }

    protected void addMaceratorRecipes(@Nonnull MMDMaterial material) {
        String oreDictName = material.getCapitalizedName();
        IRecipeInput inputOre = Recipes.inputFactory.forOreDict("ore" + oreDictName);
        IRecipeInput inputDensePlate = Recipes.inputFactory.forOreDict("plateDense" + oreDictName);
        if (!material.getItemStack(Names.CRUSHED).func_190926_b()) {
            Recipes.macerator.addRecipe(inputOre, null, false, new ItemStack[]{material.getItemStack(Names.CRUSHED, 2)});
        }
        if (!material.getItemStack(Names.POWDER).func_190926_b()) {
            Recipes.macerator.addRecipe(inputDensePlate, null, false, new ItemStack[]{material.getItemStack(Names.POWDER, 8)});
        }
    }

    protected void addMaceratorRecipe(@Nonnull String oreDict, @Nonnull ItemStack output) {
        IRecipeInput input = Recipes.inputFactory.forOreDict(oreDict);
        Recipes.macerator.addRecipe(input, null, false, new ItemStack[]{output});
    }

    protected void addOreWashingPlantRecipes(@Nonnull String materialName) {
        this.addOreWashingPlantRecipes(Materials.getMaterialByName(materialName));
    }

    protected void addOreWashingPlantRecipes(@Nonnull MMDMaterial material) {
        String oreDictName = material.getCapitalizedName();
        IRecipeInput inputOre = Recipes.inputFactory.forOreDict("crushed" + oreDictName);
        NBTTagCompound metadata = new NBTTagCompound();
        metadata.func_74768_a("amount", 1000);
        if (!material.getItemStack(Names.CRUSHED_PURIFIED).func_190926_b()) {
            if (material.hasItem(Names.SMALLPOWDER) && !material.getItemStack(Names.SMALLPOWDER).func_190926_b()) {
                Recipes.oreWashing.addRecipe(inputOre, metadata, false, new ItemStack[]{material.getItemStack(Names.CRUSHED_PURIFIED), material.getItemStack(Names.SMALLPOWDER, 2)});
            } else {
                Recipes.oreWashing.addRecipe(inputOre, metadata, false, new ItemStack[]{material.getItemStack(Names.CRUSHED_PURIFIED)});
            }
        }
    }

    protected void addThermalCentrifugeRecipes(@Nonnull String materialName) {
        this.addThermalCentrifugeRecipes(Materials.getMaterialByName(materialName));
    }

    protected void addThermalCentrifugeRecipes(@Nonnull MMDMaterial material) {
        String oreDictName = material.getCapitalizedName();
        int temp = this.getMaterialTemp(material);
        IRecipeInput inputOreCP = Recipes.inputFactory.forOreDict("crushedPurified" + oreDictName);
        IRecipeInput inputOreC = Recipes.inputFactory.forOreDict("crushed" + oreDictName);
        NBTTagCompound metadata = new NBTTagCompound();
        metadata.func_74768_a("minHeat", temp);
        if (!material.getItemStack(Names.POWDER).func_190926_b() && !material.getItemStack(Names.SMALLPOWDER).func_190926_b()) {
            Recipes.centrifuge.addRecipe(inputOreCP, metadata, false, new ItemStack[]{material.getItemStack(Names.POWDER), material.getItemStack(Names.SMALLPOWDER, 2)});
            Recipes.centrifuge.addRecipe(inputOreC, metadata, false, new ItemStack[]{material.getItemStack(Names.POWDER), material.getItemStack(Names.SMALLPOWDER)});
        }
    }

    private int getMaterialTemp(MMDMaterial material) {
        if (material.getFluid() != null) {
            return material.getFluid().getTemperature() / 2;
        }
        return 1000;
    }

    protected void addMetalFormerRecipes(@Nonnull String materialName) {
        this.addMetalFormerRecipes(Materials.getMaterialByName(materialName));
    }

    protected void addMetalFormerRecipes(@Nonnull MMDMaterial material) {
        String oreDictName = material.getCapitalizedName();
        IRecipeInput inputIngot = Recipes.inputFactory.forOreDict("ingot" + oreDictName);
        IRecipeInput inputPlate = Recipes.inputFactory.forOreDict("plate" + oreDictName);
        IRecipeInput inputCasing = Recipes.inputFactory.forOreDict("casing" + oreDictName);
        ItemStack outputPlate = material.getBlockItemStack(Names.PLATE, 1);
        ItemStack outputCasing = material.getItemStack(Names.CASING, 2);
        ItemStack outputFence = material.getBlockItemStack(Names.FENCE, 1);
        if (!outputPlate.func_190926_b()) {
            Recipes.metalformerRolling.addRecipe(inputIngot, null, false, new ItemStack[]{outputPlate});
        } else {
            MMDLib.logger.fatal("Material {} has no plate (getBlockItemStack(Names.PLATE, 1).isEmpty()", (Object)material.getCapitalizedName());
        }
        if (!outputCasing.func_190926_b()) {
            Recipes.metalformerRolling.addRecipe(inputPlate, null, false, new ItemStack[]{outputCasing});
        } else {
            MMDLib.logger.fatal("Material {} has no casing (getItemStack(Names.CASING, 2).isEmpty()", (Object)material.getCapitalizedName());
        }
        if (!outputFence.func_190926_b()) {
            Recipes.metalformerExtruding.addRecipe(inputCasing, null, false, new ItemStack[]{outputFence});
        }
    }

    protected void addCompressorRecipes(@Nonnull String materialName) {
        this.addCompressorRecipes(Materials.getMaterialByName(materialName));
    }

    protected void addCompressorRecipes(@Nonnull MMDMaterial material) {
        String oreDictName = material.getCapitalizedName();
        IRecipeInput inputIngot = Recipes.inputFactory.forOreDict("plate" + oreDictName, 9);
        ItemStack outputDensePlate = material.getItemStack(Names.DENSE_PLATE);
        if (!outputDensePlate.func_190926_b() && material.hasItem(Names.PLATE) && !material.getItemStack(Names.PLATE).func_190926_b()) {
            Recipes.compressor.addRecipe(inputIngot, null, false, new ItemStack[]{outputDensePlate});
        }
    }
}

