/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.integration.plugins;

import com.mcmoddev.lib.integration.IIntegration;
import com.mcmoddev.lib.util.Config;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class DenseOres
implements IIntegration {
    public static final String PLUGIN_MODID = "denseores";

    @Override
    public void init() {
        if (!Config.Options.isModEnabled(PLUGIN_MODID)) {
            return;
        }
    }

    protected static void registerOre(@Nonnull String name, @Nonnull String underlying, @Nonnull int meta) {
        String modID = Loader.instance().activeModContainer().getModId();
        DenseOres.registerOre(name, modID, underlying, meta);
    }

    protected static void registerOre(@Nonnull String name, @Nonnull String modID, @Nonnull String underlying, @Nonnull int meta) {
        NBTTagCompound mess = new NBTTagCompound();
        mess.func_74778_a("baseBlock", String.format("%s:%s", modID, name));
        mess.func_74768_a("baseBlockMeta", meta);
        mess.func_74778_a("underlyingBlockTexture", String.format("blocks/%s", underlying));
        mess.func_74768_a("renderType", 0);
        mess.func_74778_a("config_entry", String.format("%s %s ore", modID, name));
        FMLInterModComms.sendMessage((String)PLUGIN_MODID, (String)"addDenseOre", (NBTTagCompound)mess);
    }

    protected static void registerNetherOre(@Nonnull String name, @Nonnull int meta) {
        String modID = Loader.instance().activeModContainer().getModId();
        DenseOres.registerOre(String.format("nether_%s", name), modID, "netherrack", meta);
    }

    protected static void registerNetherOre(@Nonnull String name, @Nonnull String modID, @Nonnull int meta) {
        DenseOres.registerOre(String.format("nether_%s", name), modID, "netherrack", meta);
    }

    protected static void registerEndOre(@Nonnull String name, @Nonnull int meta) {
        String modID = Loader.instance().activeModContainer().getModId();
        DenseOres.registerOre(String.format("end_%s", name), modID, "end_stone", meta);
    }

    protected static void registerEndOre(@Nonnull String name, @Nonnull String modID, @Nonnull int meta) {
        DenseOres.registerOre(String.format("end_%s", name), modID, "end_stone", meta);
    }
}

