/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.init;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mcmoddev.lib.fluids.CustomFluid;
import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.material.MMDMaterial;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Loader;

public abstract class Fluids {
    private static final BiMap<String, Fluid> fluidRegistry = HashBiMap.create();
    private static final BiMap<String, BlockFluidClassic> fluidBlockRegistry = HashBiMap.create();

    protected Fluids() {
        throw new IllegalAccessError("Not a instantiable class");
    }

    public static void init() {
    }

    protected static Fluid addFluid(@Nonnull String materialName, @Nonnull int density, @Nonnull int viscosity, @Nonnull int temperature, @Nonnull int luminosity) {
        return Fluids.addFluid(Materials.getMaterialByName(materialName), density, viscosity, temperature, luminosity);
    }

    protected static Fluid addFluid(@Nonnull MMDMaterial material, @Nonnull int density, @Nonnull int viscosity, @Nonnull int temperature, @Nonnull int luminosity) {
        if (material.getFluid() != null) {
            return material.getFluid();
        }
        CustomFluid fluid = new CustomFluid(material.getName(), new ResourceLocation(Loader.instance().activeModContainer().getModId(), "blocks/molten_metal_still"), new ResourceLocation(Loader.instance().activeModContainer().getModId(), "blocks/molten_metal_flow"));
        fluid.setDensity(density);
        fluid.setViscosity(viscosity);
        fluid.setTemperature(temperature);
        fluid.setLuminosity(luminosity);
        fluid.setUnlocalizedName(material.getRegistryName().func_110624_b() + "." + material.getName());
        FluidRegistry.registerFluid((Fluid)fluid);
        FluidRegistry.addBucketForFluid((Fluid)fluid);
        material.setFluid(fluid);
        return (Fluid)fluidRegistry.put((Object)material.getName(), (Object)fluid);
    }

    @Nullable
    protected static BlockFluidClassic addFluidBlock(@Nonnull String materialName) {
        return Fluids.addFluidBlock(Materials.getMaterialByName(materialName));
    }

    @Nullable
    protected static BlockFluidClassic addFluidBlock(@Nonnull MMDMaterial material) {
        if (material.getFluidBlock() != null) {
            return material.getFluidBlock();
        }
        String name = material.getName();
        if (name == null) {
            return null;
        }
        BlockFluidClassic block = material.getCustomFluid();
        block.setRegistryName(name);
        block.func_149663_c(block.getRegistryName().func_110624_b() + "." + name);
        material.addNewBlock("fluid", (Block)block);
        block.func_149647_a(CreativeTabs.field_78026_f);
        ItemBlock itemBlock = new ItemBlock((Block)block);
        itemBlock.setRegistryName(name);
        itemBlock.func_77655_b(block.getRegistryName().func_110624_b() + "." + name);
        material.addNewItem("fluidItemBlock", (Item)itemBlock);
        material.setFluidBlock(block);
        return (BlockFluidClassic)fluidBlockRegistry.put((Object)name, (Object)block);
    }

    @Nullable
    public static Fluid getFluidByName(@Nonnull String name) {
        return (Fluid)fluidRegistry.get((Object)name);
    }

    @Nullable
    public static String getNameOfFluid(@Nonnull Fluid fluid) {
        return (String)fluidRegistry.inverse().get((Object)fluid);
    }

    public static Map<String, Fluid> getFluidRegistry() {
        return Collections.unmodifiableMap(fluidRegistry);
    }

    @Nullable
    public static BlockFluidBase getFluidBlockByName(@Nonnull String name) {
        return (BlockFluidBase)fluidBlockRegistry.get((Object)name);
    }

    @Nullable
    public static String getNameOfFluidBlock(@Nonnull BlockFluidBase block) {
        return (String)fluidBlockRegistry.inverse().get((Object)block);
    }

    public static Map<String, BlockFluidBase> getFluidBlockRegistry() {
        return Collections.unmodifiableMap(fluidBlockRegistry);
    }
}

