/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.fluids;

import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.material.MMDMaterial;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;

public class CustomFluid
extends Fluid {
    public CustomFluid(String fluidName, ResourceLocation still, ResourceLocation flowing) {
        super(fluidName, still, flowing);
        MMDMaterial material = Materials.getMaterialByName(fluidName);
        if (!material.isEmpty()) {
            this.color = material.getTintColor();
        }
        this.checkColor();
    }

    public CustomFluid(String fluidName, ResourceLocation still, ResourceLocation flowing, int tintARGB) {
        super(fluidName, still, flowing);
        this.color = tintARGB;
        this.checkColor();
    }

    public CustomFluid(String fluidName) {
        this(fluidName, new ResourceLocation(Loader.instance().activeModContainer().getModId(), "blocks/molten_metal_still"), new ResourceLocation(Loader.instance().activeModContainer().getModId(), "blocks/molten_metal_flow"));
    }

    public CustomFluid(String fluidName, int tintARGB) {
        super(fluidName, new ResourceLocation(Loader.instance().activeModContainer().getModId(), "blocks/molten_metal_still"), new ResourceLocation(Loader.instance().activeModContainer().getModId(), "blocks/molten_metal_flow"));
        this.color = tintARGB;
        this.checkColor();
    }

    public int getColor() {
        return this.color;
    }

    public String getLocalizedName(FluidStack stack) {
        String s = this.getUnlocalizedName();
        return s == null ? "" : new TextComponentTranslation(String.format("%s.name", s), new Object[0]).func_150254_d();
    }

    private void checkColor() {
        if ((this.color >> 24 & 0xFF) == 0) {
            this.color |= 0xFF000000;
        }
    }
}

