/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.feature;

import com.mcmoddev.lib.feature.IFeature;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.EnumFacing;

public interface ISidedFeature
extends IFeature {
    public int getColor();

    public int getPriorityIndex();

    public EnumFacing[] getFacings();

    public void setFacings(EnumFacing[] var1);

    default public void enableFacing(EnumFacing facing) {
        if (!this.isFacingEnabled(facing)) {
            EnumFacing[] facings = this.getFacings();
            if (facings == null || facings.length == 0) {
                this.setFacings(new EnumFacing[]{facing});
            } else {
                List<EnumFacing> list = Arrays.asList(facings);
                list.add(facing);
                this.setFacings(list.toArray(new EnumFacing[facings.length + 1]));
            }
        }
    }

    default public void disableFacing(EnumFacing facing) {
        if (this.isFacingEnabled(facing)) {
            this.setFacings((EnumFacing[])Arrays.stream(this.getFacings()).filter(f -> f != facing).toArray(EnumFacing[]::new));
        }
    }

    default public boolean isFacingEnabled(EnumFacing facing) {
        EnumFacing[] facings = this.getFacings();
        return Arrays.stream(facings).anyMatch(f -> f == facing);
    }
}

