/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.energy.util;

import com.mcmoddev.lib.energy.EnergySystemRegistry;
import com.mcmoddev.lib.energy.ForgeEnergyValue;
import com.mcmoddev.lib.energy.IEnergyValue;

public final class EnergyValueUtils {
    protected EnergyValueUtils() {
    }

    public static boolean canGetForgeEnergy(IEnergyValue value) {
        return value instanceof ForgeEnergyValue || value.getSystem().isCompatibleWith(EnergySystemRegistry.FORGE_ENERGY);
    }

    public static int getForgeEnergy(IEnergyValue value) {
        if (value instanceof ForgeEnergyValue) {
            return (Integer)((ForgeEnergyValue)value).getValue();
        }
        if (EnergySystemRegistry.FORGE_ENERGY.isCompatibleWith(value.getSystem())) {
            ForgeEnergyValue energy = EnergySystemRegistry.FORGE_ENERGY.convertFrom(value);
            return energy == null ? 0 : (Integer)energy.getValue();
        }
        return 0;
    }
}

