/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.energy.tesla;

import com.mcmoddev.lib.energy.BaseEnergyValue;
import com.mcmoddev.lib.energy.EnergySystemRegistry;
import com.mcmoddev.lib.energy.IEnergyValue;
import java.text.NumberFormat;

public class TeslaEnergyValue
extends BaseEnergyValue<Long> {
    public TeslaEnergyValue(long value) {
        super(EnergySystemRegistry.TESLA, value);
    }

    @Override
    public IEnergyValue<Long> add(IEnergyValue other) {
        if (!this.isCompatible(other)) {
            return this;
        }
        TeslaEnergyValue otherTesla = EnergySystemRegistry.TESLA.convertToTesla(other);
        return new TeslaEnergyValue((Long)this.getValue() + (otherTesla == null ? 0L : (Long)otherTesla.getValue()));
    }

    @Override
    public IEnergyValue<Long> subtract(IEnergyValue other) {
        if (!this.isCompatible(other)) {
            return this;
        }
        TeslaEnergyValue otherTesla = EnergySystemRegistry.TESLA.convertToTesla(other);
        return new TeslaEnergyValue((Long)this.getValue() - (otherTesla == null ? 0L : (Long)otherTesla.getValue()));
    }

    @Override
    public IEnergyValue<Long> copy() {
        return new TeslaEnergyValue((Long)this.getValue());
    }

    public String toString() {
        return NumberFormat.getNumberInstance().format(this.getValue()) + " T";
    }
}

