/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.energy.tesla;

import com.mcmoddev.lib.energy.EnergySystemRegistry;
import com.mcmoddev.lib.energy.IEnergyAdapter;
import com.mcmoddev.lib.energy.IEnergySystem;
import com.mcmoddev.lib.energy.IEnergyValue;
import com.mcmoddev.lib.energy.tesla.TeslaEnergyValue;
import javax.annotation.Nullable;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;

public class TeslaEnergyAdapter
implements IEnergyAdapter {
    private final ITeslaConsumer consumer;
    private final ITeslaHolder holder;
    private final ITeslaProducer producer;

    public TeslaEnergyAdapter(@Nullable ITeslaConsumer consumer, @Nullable ITeslaHolder holder, @Nullable ITeslaProducer producer) {
        this.consumer = consumer;
        this.holder = holder;
        this.producer = producer;
    }

    @Override
    public IEnergySystem getSystem() {
        return EnergySystemRegistry.TESLA;
    }

    private TeslaEnergyValue makeValue(long value) {
        return new TeslaEnergyValue(value);
    }

    @Override
    public IEnergyValue getCapacity() {
        return this.makeValue(this.holder == null ? 0L : this.holder.getCapacity());
    }

    @Override
    public IEnergyValue getValue() {
        return this.makeValue(this.holder == null ? 0L : this.holder.getStoredPower());
    }

    @Override
    public IEnergyValue charge(IEnergyValue value, boolean doCharge) {
        IEnergyValue ours;
        if (this.consumer != null && (ours = this.getSystem().convertFrom(value)) instanceof TeslaEnergyValue) {
            long energy = (Long)((TeslaEnergyValue)ours).getValue();
            return this.makeValue(this.consumer.givePower(energy, !doCharge));
        }
        return this.makeValue(0L);
    }

    @Override
    public IEnergyValue discharge(IEnergyValue value, boolean doDischarge) {
        IEnergyValue ours;
        if (this.producer != null && (ours = this.getSystem().convertFrom(value)) instanceof TeslaEnergyValue) {
            long energy = (Long)((TeslaEnergyValue)ours).getValue();
            return this.makeValue(this.producer.takePower(energy, !doDischarge));
        }
        return this.makeValue(0L);
    }
}

