/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.energy.rf;

import com.mcmoddev.lib.energy.BaseEnergyValue;
import com.mcmoddev.lib.energy.EnergySystemRegistry;
import com.mcmoddev.lib.energy.IEnergyValue;
import java.text.NumberFormat;

public class RFEnergyValue
extends BaseEnergyValue<Integer> {
    public RFEnergyValue(int value) {
        super(EnergySystemRegistry.RF, value);
    }

    @Override
    public IEnergyValue<Integer> add(IEnergyValue other) {
        if (!this.isCompatible(other)) {
            return this;
        }
        RFEnergyValue otherRf = EnergySystemRegistry.RF.convertToRF(other);
        return new RFEnergyValue((Integer)this.getValue() + (otherRf == null ? 0 : (Integer)otherRf.getValue()));
    }

    @Override
    public IEnergyValue<Integer> subtract(IEnergyValue other) {
        if (!this.isCompatible(other)) {
            return this;
        }
        RFEnergyValue otherRf = EnergySystemRegistry.RF.convertToRF(other);
        return new RFEnergyValue((Integer)this.getValue() - (otherRf == null ? 0 : (Integer)otherRf.getValue()));
    }

    @Override
    public IEnergyValue<Integer> copy() {
        return new RFEnergyValue((Integer)this.getValue());
    }

    public String toString() {
        return NumberFormat.getNumberInstance().format(this.getValue()) + " RF";
    }
}

