/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.energy;

import com.mcmoddev.lib.energy.EnergySystemRegistry;
import com.mcmoddev.lib.energy.ForgeEnergyAdapter;
import com.mcmoddev.lib.energy.ForgeEnergyValue;
import com.mcmoddev.lib.energy.IEnergySystem;
import com.mcmoddev.lib.energy.IEnergyValue;
import com.mcmoddev.lib.energy.IForgeEnergyCompatible;
import com.mcmoddev.lib.energy.IGenericEnergyStorage;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class ForgeEnergySystem
implements IForgeEnergyCompatible<Integer> {
    @Override
    public String getDependencyModId() {
        return "minecraft";
    }

    @Override
    @Nullable
    public ForgeEnergyAdapter createAdapter(TileEntity tile, EnumFacing facing) {
        IEnergyStorage storage = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, facing);
        return storage != null ? new ForgeEnergyAdapter(storage) : null;
    }

    @Override
    @Nullable
    public ForgeEnergyAdapter createAdapter(ItemStack stack) {
        IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        return storage != null ? new ForgeEnergyAdapter(storage) : null;
    }

    @Override
    public boolean isCompatibleWith(IEnergySystem system) {
        return system == EnergySystemRegistry.FORGE_ENERGY || system instanceof IForgeEnergyCompatible;
    }

    @Nullable
    public ForgeEnergyValue convertFrom(IEnergyValue value) {
        if (value instanceof ForgeEnergyValue) {
            return (ForgeEnergyValue)ForgeEnergyValue.class.cast(value);
        }
        if (value.getSystem() instanceof IForgeEnergyCompatible) {
            return ((IForgeEnergyCompatible)value.getSystem()).convertToFE(value);
        }
        return null;
    }

    @Override
    @Nullable
    public ForgeEnergyValue convertToFE(IEnergyValue value) {
        return value instanceof ForgeEnergyValue ? (ForgeEnergyValue)value : null;
    }

    @Override
    @Nullable
    public IEnergyValue<Integer> convertFromFE(ForgeEnergyValue value) {
        return value;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, IGenericEnergyStorage storage) {
        return capability == CapabilityEnergy.ENERGY && storage.getBaseSystem() instanceof IForgeEnergyCompatible;
    }

    @Override
    @Nullable
    public <C> C getCapability(Capability<C> capability, IGenericEnergyStorage storage) {
        if (this.hasCapability(capability, storage)) {
            return (C)CapabilityEnergy.ENERGY.cast((Object)new CapabilityStorage(storage));
        }
        return null;
    }

    private static class CapabilityStorage
    implements IEnergyStorage {
        private final IGenericEnergyStorage storage;
        private final IForgeEnergyCompatible compatible;

        CapabilityStorage(IGenericEnergyStorage storage) {
            this.storage = storage;
            this.compatible = (IForgeEnergyCompatible)storage.getBaseSystem();
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return (Integer)Objects.requireNonNull(this.compatible.convertToFE(this.storage.storeValue(new ForgeEnergyValue(maxReceive), !simulate))).getValue();
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return (Integer)Objects.requireNonNull(this.compatible.convertToFE(this.storage.takeValue(new ForgeEnergyValue(maxExtract), !simulate))).getValue();
        }

        public int getEnergyStored() {
            return (Integer)EnergySystemRegistry.FORGE_ENERGY.convertToFE(this.storage.getStoredValue()).getValue();
        }

        public int getMaxEnergyStored() {
            return (Integer)EnergySystemRegistry.FORGE_ENERGY.convertToFE(this.storage.getCapacityValue()).getValue();
        }

        public boolean canExtract() {
            return this.storage.canTake();
        }

        public boolean canReceive() {
            return this.storage.canStore();
        }
    }
}

