/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.energy;

import com.mcmoddev.lib.energy.BaseGenericEnergyStorage;
import com.mcmoddev.lib.energy.EnergySystemRegistry;
import com.mcmoddev.lib.energy.ForgeEnergyValue;
import com.mcmoddev.lib.energy.IEnergyValue;
import net.minecraft.nbt.NBTTagCompound;

public class ForgeEnergyStorage
extends BaseGenericEnergyStorage<Integer> {
    public ForgeEnergyStorage(int capacity) {
        this(0, capacity);
    }

    public ForgeEnergyStorage(int initial, int capacity) {
        super(new ForgeEnergyValue(initial), new ForgeEnergyValue(capacity), EnergySystemRegistry.getAllCompatible(EnergySystemRegistry.FORGE_ENERGY));
    }

    @Override
    protected void writeValueToNBT(NBTTagCompound nbt, String key, Integer energy) {
        nbt.func_74768_a(key, energy.intValue());
    }

    @Override
    protected IEnergyValue<Integer> readValueFromNBT(NBTTagCompound nbt, String key) {
        return new ForgeEnergyValue(nbt.func_74762_e(key));
    }

    @Override
    protected IEnergyValue<Integer> getZeroEnergy() {
        return new ForgeEnergyValue(0);
    }

    @Override
    public Integer store(Integer toStore, boolean doStore) {
        return (Integer)this.storeValue(new ForgeEnergyValue(toStore), doStore).getValue();
    }

    @Override
    public Integer take(Integer toTake, boolean doTake) {
        return (Integer)this.takeValue(new ForgeEnergyValue(toTake), doTake).getValue();
    }

    public ForgeEnergyStorage setInputRate(int value) {
        this.setInputRateValue(new ForgeEnergyValue(value));
        return this;
    }

    public ForgeEnergyStorage setoutputRate(int value) {
        this.setOutputRateValue(new ForgeEnergyValue(value));
        return this;
    }
}

