/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.energy;

import com.mcmoddev.lib.energy.ForgeEnergySystem;
import com.mcmoddev.lib.energy.IEnergyAdapter;
import com.mcmoddev.lib.energy.IEnergySystem;
import com.mcmoddev.lib.energy.rf.RFEnergySystem;
import com.mcmoddev.lib.energy.tesla.TeslaEnergySystem;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public final class EnergySystemRegistry {
    public static final ForgeEnergySystem FORGE_ENERGY = new ForgeEnergySystem();
    public static final TeslaEnergySystem TESLA = new TeslaEnergySystem();
    public static final RFEnergySystem RF = new RFEnergySystem();
    public static final IEnergySystem[] ALL = new IEnergySystem[]{FORGE_ENERGY, TESLA, RF};

    public static IEnergySystem[] getAllCompatible(IEnergySystem baseSystem) {
        return (IEnergySystem[])Arrays.stream(ALL).filter(IEnergySystem::isAvailable).filter(baseSystem::isCompatibleWith).toArray(IEnergySystem[]::new);
    }

    @Nullable
    public static IEnergyAdapter findAdapter(IEnergySystem baseSystem, TileEntity tile, @Nullable EnumFacing facing) {
        return Arrays.stream(EnergySystemRegistry.getAllCompatible(baseSystem)).map(s -> s.createAdapter(tile, facing)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Nullable
    public static IEnergyAdapter findAdapter(IEnergySystem baseSystem, ItemStack stack) {
        return Arrays.stream(EnergySystemRegistry.getAllCompatible(baseSystem)).map(s -> s.createAdapter(stack)).filter(Objects::nonNull).findFirst().orElse(null);
    }
}

