/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.container.widget;

import com.mcmoddev.lib.MMDLib;
import com.mcmoddev.lib.container.IContainerSlot;
import com.mcmoddev.lib.container.gui.GuiContext;
import com.mcmoddev.lib.container.widget.ActionTextWidget;
import com.mcmoddev.lib.container.widget.BaseWidget;
import com.mcmoddev.lib.container.widget.IProxiedWidget;
import com.mcmoddev.lib.container.widget.IProxyWidget;
import com.mcmoddev.lib.container.widget.IWidget;
import com.mcmoddev.lib.util.NBTUtils;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.TriConsumer;

public class DataWidget
extends BaseWidget
implements IProxyWidget,
INBTSerializable<NBTTagCompound> {
    private final List<DataHandler<?>> dataHandlers = new ArrayList();

    protected DataWidget(String key) {
        super(key, false);
        HashMap<String, DataProvider> providers = new HashMap<String, DataProvider>();
        for (Field field : this.getClass().getFields()) {
            DataField thing = field.getAnnotation(DataField.class);
            if (thing == null) continue;
            providers.put(field.getName(), new FieldDataProvider(field));
        }
        HashMap<String, Method> getters = new HashMap<String, Method>();
        HashMap<String, Method> setters = new HashMap<String, Method>();
        for (Method method : this.getClass().getMethods()) {
            DataGetter getter = method.getAnnotation(DataGetter.class);
            if (getter != null) {
                String getterName = getter.value();
                if (getterName.isEmpty() && (getterName = method.getName()).startsWith("get")) {
                    getterName = StringUtils.uncapitalize((String)getterName.substring(3));
                }
                getters.put(getterName, method);
                continue;
            }
            DataSetter setter = method.getAnnotation(DataSetter.class);
            if (setter == null) continue;
            String setterName = setter.value();
            if (setterName.isEmpty() && (setterName = method.getName()).startsWith("set")) {
                setterName = StringUtils.uncapitalize((String)setterName.substring(3));
            }
            setters.put(setterName, method);
        }
        for (String methodKey : getters.keySet()) {
            Method getter = getters.getOrDefault(methodKey, null);
            Method setter = setters.getOrDefault(methodKey, null);
            if (getter == null || setter == null) continue;
            if (setter.getParameterCount() != 1 || !getter.getReturnType().equals(setter.getParameterTypes()[0])) {
                MMDLib.logger.warn("Type mismatch between data widget getter and setter for data: '" + methodKey + "'.");
                continue;
            }
            providers.put(methodKey, new MethodDataProvider(getter, setter));
        }
        for (String providerKey : providers.keySet()) {
            DataHandler handler = DataWidget.getDataHandler((DataProvider)providers.get(providerKey), providerKey);
            if (handler == null) {
                MMDLib.logger.warn("Could not find data handler for data widget field: '" + providerKey + "'.");
                continue;
            }
            this.dataHandlers.add(handler);
        }
    }

    public void setValue(String valueKey, Object value) {
        for (DataHandler<?> handler : this.dataHandlers) {
            if (!((DataHandler)handler).providerKey.equals(valueKey) || !((DataHandler)handler).expectedType.isInstance(value)) continue;
            handler.setValue(this, ((DataHandler)handler).expectedType.cast(value));
            break;
        }
    }

    @Nullable
    public Object getValue(String valueKey) {
        for (DataHandler<?> handler : this.dataHandlers) {
            if (!((DataHandler)handler).providerKey.equals(valueKey)) continue;
            return handler.getValue(this);
        }
        return null;
    }

    @Nullable
    public <T> T getValue(Class<T> expected, String valueKey) {
        for (DataHandler<?> handler : this.dataHandlers) {
            if (!((DataHandler)handler).providerKey.equals(valueKey) || !expected.isAssignableFrom(((DataHandler)handler).expectedType)) continue;
            return expected.cast(handler.getValue(this));
        }
        return expected.cast(null);
    }

    @Nullable
    private static DataHandler getDataHandler(DataProvider provider, String key) {
        Class<?> type = provider.getDataType();
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return new IntegerHandler(provider, key);
        }
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            return new FloatHandler(provider, key);
        }
        if (type.equals(String.class)) {
            return new StringHandler(provider, key);
        }
        return null;
    }

    @Override
    public IWidget getContextualWidget(GuiContext context) {
        return new DataWidgetProxy();
    }

    private NBTTagCompound getSnapshot() {
        NBTTagCompound nbt = new NBTTagCompound();
        for (DataHandler<?> handler : this.dataHandlers) {
            handler.writeToNBT(nbt, this);
        }
        return nbt;
    }

    private void refreshData(NBTTagCompound nbt) {
        for (DataHandler<?> handler : this.dataHandlers) {
            if (!nbt.func_74764_b(((DataHandler)handler).providerKey)) continue;
            handler.readFromNBT(nbt, this);
        }
    }

    @Override
    public void handleMessageFromClient(NBTTagCompound tag) {
        MMDLib.logger.info("Data Widget info received from client :: " + tag.toString());
        this.refreshData(tag);
    }

    @Override
    public void handleMessageFromServer(NBTTagCompound tag) {
        MMDLib.logger.info("Data Widget info received from server :: " + tag.toString());
        this.refreshData(tag);
    }

    public NBTTagCompound serializeNBT() {
        return this.getSnapshot();
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.refreshData(nbt);
    }

    @Nullable
    public ActionTextWidget getStringUpdateActionWidget(String widgetKey, String dataKey) {
        DataHandler rawHandler = this.dataHandlers.stream().filter(w -> w.getProviderKey().equals(dataKey)).findFirst().orElse(null);
        if (rawHandler == null || !(rawHandler instanceof StringHandler)) {
            return null;
        }
        StringHandler handler = (StringHandler)rawHandler;
        ActionTextWidget widget = new ActionTextWidget(widgetKey, (String)handler.getValue(this));
        widget.setServerSideTextConsumer(text -> handler.setValue(this, text));
        return widget;
    }

    private class DataWidgetProxy
    implements IWidget,
    IProxiedWidget {
        private NBTTagCompound snapshot;

        @Override
        public String getKey() {
            return DataWidget.this.getKey();
        }

        @Override
        public Collection<IContainerSlot> getSlots() {
            return DataWidget.this.getSlots();
        }

        @Override
        public void handleMessageFromClient(NBTTagCompound tag) {
            DataWidget.this.handleMessageFromClient(tag);
        }

        @Override
        public void handleMessageFromServer(NBTTagCompound tag) {
            DataWidget.this.handleMessageFromServer(tag);
        }

        @Override
        public boolean isDirty() {
            NBTTagCompound nbt = DataWidget.this.getSnapshot();
            return this.snapshot == null || !nbt.equals((Object)this.snapshot);
        }

        @Override
        public void resetDirtyFlag() {
            this.snapshot = DataWidget.this.getSnapshot();
        }

        @Override
        @Nullable
        public NBTTagCompound getUpdateCompound() {
            NBTTagCompound snapshot = DataWidget.this.getSnapshot();
            return this.snapshot == null ? snapshot : NBTUtils.getPatch(this.snapshot, snapshot);
        }

        @Override
        public IWidget getOriginalWidget() {
            return DataWidget.this;
        }
    }

    private static final class StringHandler
    extends DataHandler<String> {
        private StringHandler(DataProvider provider, String providerKey) {
            super(String.class, provider, providerKey, NBTTagCompound::func_74779_i, (nbt, key, value) -> {
                if (value == null) {
                    nbt.func_74778_a(key, "");
                } else {
                    nbt.func_74778_a(key, value);
                }
            });
        }
    }

    private static final class FloatHandler
    extends DataHandler<Float> {
        private FloatHandler(DataProvider provider, String providerKey) {
            super(Float.class, provider, providerKey, NBTTagCompound::func_74760_g, NBTTagCompound::func_74776_a);
        }
    }

    private static final class IntegerHandler
    extends DataHandler<Integer> {
        private IntegerHandler(DataProvider provider, String providerKey) {
            super(Integer.class, provider, providerKey, NBTTagCompound::func_74762_e, NBTTagCompound::func_74768_a);
        }
    }

    private static abstract class DataHandler<T> {
        private final Class<T> expectedType;
        private final DataProvider provider;
        private final String providerKey;
        private final BiFunction<NBTTagCompound, String, T> getter;
        private final TriConsumer<NBTTagCompound, String, T> setter;

        protected DataHandler(Class<T> expectedType, DataProvider provider, String providerKey, BiFunction<NBTTagCompound, String, T> getter, TriConsumer<NBTTagCompound, String, T> setter) {
            this.expectedType = expectedType;
            this.provider = provider;
            this.providerKey = providerKey;
            this.getter = getter;
            this.setter = setter;
        }

        protected T getValue(DataWidget widget) {
            return this.expectedType.cast(this.provider.getValue(widget));
        }

        protected void setValue(DataWidget widget, T value) {
            this.provider.setValue(widget, value);
        }

        public void readFromNBT(NBTTagCompound nbt, DataWidget widget) {
            this.provider.setValue(widget, this.getter.apply(nbt, this.providerKey));
        }

        public void writeToNBT(NBTTagCompound nbt, DataWidget widget) {
            this.setter.accept((Object)nbt, (Object)this.providerKey, this.expectedType.cast(this.provider.getValue(widget)));
        }

        public String getProviderKey() {
            return this.providerKey;
        }
    }

    private class FieldDataProvider
    extends DataProvider {
        private final Field field;

        private FieldDataProvider(Field field) {
            this.field = field;
            this.field.setAccessible(true);
        }

        @Override
        @Nullable
        public Object getValue(DataWidget widget) {
            try {
                return this.field.get(widget);
            }
            catch (IllegalAccessException e) {
                MMDLib.logger.error("Error getting data widget value.", (Throwable)e);
                return null;
            }
        }

        @Override
        public void setValue(DataWidget widget, Object value) {
            try {
                this.field.set(widget, value);
            }
            catch (IllegalAccessException e) {
                MMDLib.logger.error("Error setting data widget value.", (Throwable)e);
            }
        }

        @Override
        public Class<?> getDataType() {
            return this.field.getType();
        }
    }

    private class MethodDataProvider
    extends DataProvider {
        private final Method getter;
        private final Method setter;

        public MethodDataProvider(Method getter, Method setter) {
            this.getter = getter;
            this.getter.setAccessible(true);
            this.setter = setter;
            this.setter.setAccessible(true);
        }

        @Override
        @Nullable
        public Object getValue(DataWidget widget) {
            try {
                return this.getter.invoke((Object)widget, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                MMDLib.logger.error("Error getting data widget value.", (Throwable)e);
                return null;
            }
        }

        @Override
        public void setValue(DataWidget widget, Object value) {
            try {
                this.setter.invoke((Object)widget, value);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                MMDLib.logger.error("Error setting data widget value.", (Throwable)e);
            }
        }

        @Override
        public Class<?> getDataType() {
            return this.getter.getReturnType();
        }
    }

    private abstract class DataProvider {
        private DataProvider() {
        }

        @Nullable
        public abstract Object getValue(DataWidget var1);

        public abstract void setValue(DataWidget var1, Object var2);

        public abstract Class<?> getDataType();
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface DataField {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface DataSetter {
        public String value() default "";
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface DataGetter {
        public String value() default "";
    }
}

