/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.container.widget;

import com.mcmoddev.lib.container.gui.GuiContext;
import com.mcmoddev.lib.container.widget.BaseContextualWidget;
import com.mcmoddev.lib.network.NBTBasedPlayerMessage;
import com.mcmoddev.lib.util.NBTUtils;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ActionWidget
extends BaseContextualWidget {
    private static final String ACTION_CALL_TAG_NAME = "_invokeAction";
    private BiConsumer<GuiContext, NBTTagCompound> clientConsumer = null;
    private BiConsumer<GuiContext, NBTTagCompound> serverConsumer = null;

    public ActionWidget(String key) {
        this(key, false);
    }

    protected ActionWidget(String key, boolean canBeDirty) {
        super(key, canBeDirty);
    }

    public ActionWidget setClientSideConsumer(Consumer<NBTTagCompound> consumer) {
        this.clientConsumer = (context, nbt) -> consumer.accept((NBTTagCompound)nbt);
        return this;
    }

    public ActionWidget setClientSideConsumer(BiConsumer<GuiContext, NBTTagCompound> consumer) {
        this.clientConsumer = consumer;
        return this;
    }

    public ActionWidget setClientSideConsumer(Runnable consumer) {
        return this.setClientSideConsumer((NBTTagCompound nbt) -> consumer.run());
    }

    public ActionWidget setServerSideConsumer(BiConsumer<GuiContext, NBTTagCompound> consumer) {
        this.serverConsumer = consumer;
        return this;
    }

    public ActionWidget setServerSideConsumer(Consumer<NBTTagCompound> consumer) {
        this.serverConsumer = (context, nbt) -> consumer.accept((NBTTagCompound)nbt);
        return this;
    }

    public ActionWidget setServerSideConsumer(Runnable consumer) {
        return this.setServerSideConsumer((NBTTagCompound nbt) -> consumer.run());
    }

    @Override
    public void handleMessageFromClient(NBTTagCompound tag) {
        if (this.serverConsumer != null && tag.func_150297_b(ACTION_CALL_TAG_NAME, 10)) {
            this.serverConsumer.accept(this.getContext(), tag.func_74775_l(ACTION_CALL_TAG_NAME));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void actionPerformed() {
        this.actionPerformed(new NBTTagCompound());
    }

    @SideOnly(value=Side.CLIENT)
    public void actionPerformed(NBTTagCompound data) {
        if (this.clientConsumer != null) {
            this.clientConsumer.accept(this.getContext(), data);
        }
        if (this.serverConsumer != null) {
            NBTTagCompound nbt = NBTUtils.wrapCompound(data, this.getKey(), ACTION_CALL_TAG_NAME);
            NBTBasedPlayerMessage.sendToServer(Minecraft.func_71410_x().field_71439_g, nbt);
        }
    }
}

