/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.container.widget;

import com.mcmoddev.lib.container.widget.ActionWidget;
import com.mcmoddev.lib.util.NBTUtils;
import java.util.function.IntConsumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ActionIntWidget
extends ActionWidget {
    public static final String NBT_VALUE_KEY = "_value";
    private int value;

    public ActionIntWidget(String key, int initialValue) {
        super(key, true);
        this.value = initialValue;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        if (value == this.value) {
            return;
        }
        this.value = value;
        this.setDirty();
    }

    public ActionIntWidget setClientSideConsumer(IntConsumer consumer) {
        super.setClientSideConsumer((NBTTagCompound nbt) -> consumer.accept(this.getValueFromNBT((NBTTagCompound)nbt)));
        return this;
    }

    public ActionIntWidget setServerSideConsumer(IntConsumer consumer) {
        super.setServerSideConsumer((NBTTagCompound nbt) -> consumer.accept(this.getValueFromNBT((NBTTagCompound)nbt)));
        return this;
    }

    @Override
    @Nullable
    public NBTTagCompound getUpdateCompound() {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.value != 0) {
            nbt.func_74768_a(NBT_VALUE_KEY, this.value);
        }
        return nbt;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleMessageFromServer(NBTTagCompound tag) {
        this.value = this.getValueFromNBT(tag);
    }

    @Override
    public void handleMessageFromClient(NBTTagCompound tag) {
        this.setValue(this.getValueFromNBT(tag));
    }

    private int getValueFromNBT(NBTTagCompound tag) {
        return tag.func_150297_b(NBT_VALUE_KEY, 3) ? tag.func_74762_e(NBT_VALUE_KEY) : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static NBTTagCompound getActionNBT(String widgetKey, int newValue) {
        NBTTagCompound data = new NBTTagCompound();
        if (newValue != 0) {
            data.func_74768_a(NBT_VALUE_KEY, newValue);
        }
        return NBTUtils.wrapCompound(data, widgetKey);
    }
}

