/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.container.gui.sprite;

import com.mcmoddev.lib.container.gui.IGuiSprite;
import com.mcmoddev.lib.container.gui.IGuiTexture;
import com.mcmoddev.lib.container.gui.sprite.MinecraftStitchedTextures;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FluidSprite
implements IGuiSprite {
    private final Fluid fluid;
    private final int width;
    private final int height;

    public FluidSprite(Fluid fluid, int width, int height) {
        this.fluid = fluid;
        this.width = width;
        this.height = height;
    }

    @Override
    public IGuiTexture getTexture() {
        return MinecraftStitchedTextures.INSTANCE;
    }

    @Override
    public int getLeft() {
        return 0;
    }

    @Override
    public int getTop() {
        return 0;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean needsAlpha() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiScreen screen, int left, int top) {
        this.draw(screen, left, top, this.getWidth(), this.getHeight());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiScreen screen, int left, int top, int width, int height, boolean clip) {
        this.draw(screen, left, top, this.getWidth(), this.getHeight());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiScreen screen, int left, int top, int width, int height) {
        this.draw(screen, left, top, 0, 0, width, height);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiScreen screen, int left, int top, int texLeft, int texTop, int texWidth, int texHeight) {
        ResourceLocation still = this.fluid.getStill();
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(still.toString());
        int spriteWidth = sprite.func_94211_a();
        int spriteHeight = sprite.func_94216_b();
        this.getTexture().bind();
        Color color = new Color(this.fluid.getColor(), true);
        GlStateManager.func_179131_c((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        double u = sprite.func_94214_a(0.0);
        double v = sprite.func_94207_b(0.0);
        for (int tileY = texTop; tileY < texHeight; tileY += spriteHeight) {
            for (int tileX = texLeft; tileX < texWidth; tileX += spriteWidth) {
                double x = left + tileX;
                double y = top + tileY;
                double w = Math.min(tileX + spriteWidth, this.width) - tileX;
                double h = Math.min(tileY + spriteHeight, this.height) - tileY;
                double ur = w / (double)spriteWidth;
                double vb = h / (double)spriteHeight;
                double uu = sprite.func_94214_a(ur * 16.0);
                double vv = sprite.func_94207_b(vb * 16.0);
                bufferbuilder.func_181662_b(x, y + h, 0.0).func_187315_a(u, v).func_181675_d();
                bufferbuilder.func_181662_b(x + w, y + h, 0.0).func_187315_a(uu, v).func_181675_d();
                bufferbuilder.func_181662_b(x + w, y, 0.0).func_187315_a(uu, vv).func_181675_d();
                bufferbuilder.func_181662_b(x, y, 0.0).func_187315_a(u, vv).func_181675_d();
            }
        }
        tessellator.func_78381_a();
    }
}

