/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.container.gui;

import com.mcmoddev.lib.MMDLib;
import com.mcmoddev.lib.container.gui.BaseWidgetGui;
import com.mcmoddev.lib.container.gui.GuiContext;
import com.mcmoddev.lib.container.gui.GuiPieceLayer;
import com.mcmoddev.lib.container.gui.IFocusableHandler;
import com.mcmoddev.lib.container.gui.IFocusableWidgetGui;
import com.mcmoddev.lib.container.gui.MMDGuiContainer;
import com.mcmoddev.lib.container.widget.ActionTextWidget;
import com.mcmoddev.lib.container.widget.ActionWidget;
import com.mcmoddev.lib.container.widget.DataWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiTextField;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TextEditWidgetGui
extends BaseWidgetGui
implements IFocusableWidgetGui {
    public static final int DEFAULT_HEIGHT = 18;
    private final GuiTextField textField;
    private String dataWidgetKey = null;
    private String dataWidgetDataKey = null;
    private String actionWidgetKey = null;
    private String lastDataWidgetText = null;
    private String lastActionWidgetText = null;
    private IFocusableHandler focusableHandler = null;

    public TextEditWidgetGui(int par5Width) {
        super(par5Width, 18);
        this.textField = new GuiTextField(0, Minecraft.func_71410_x().field_71466_p, 0, 0, par5Width, 18);
    }

    public TextEditWidgetGui connectDataWidget(String widgetKey, String dataKey) {
        this.dataWidgetKey = widgetKey;
        this.dataWidgetDataKey = dataKey;
        return this;
    }

    public TextEditWidgetGui connectActionWidget(String widgetKey) {
        this.actionWidgetKey = widgetKey;
        return this;
    }

    public TextEditWidgetGui setMaxLength(int length) {
        this.textField.func_146203_f(length);
        return this;
    }

    public String getText() {
        return this.textField.func_146179_b();
    }

    public void setText(String text) {
        this.textField.func_146180_a(text);
    }

    @Override
    public GuiPieceLayer[] getLayers() {
        return new GuiPieceLayer[]{GuiPieceLayer.FOREGROUND};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawForegroundLayer(MMDGuiContainer container, int mouseX, int mouseY) {
        this.textField.func_146194_f();
    }

    @Override
    public void setFocusableHandler(IFocusableHandler handler) {
        this.focusableHandler = handler;
    }

    @Override
    public void onFocus() {
        this.textField.func_146195_b(true);
    }

    @Override
    public void onBlur() {
        this.textField.func_146195_b(false);
    }

    @Override
    public void focus() {
        if (this.focusableHandler != null) {
            this.focusableHandler.setFocus(this);
        }
    }

    @Override
    public boolean handleKeyPress(char typedChar, int keyCode) {
        return this.textField.func_146201_a(typedChar, keyCode);
    }

    @Override
    public boolean mouseReleased(MMDGuiContainer container, int mouseX, int mouseY, int state) {
        if (this.isInside(mouseX, mouseY)) {
            this.focus();
            return true;
        }
        return false;
    }

    @Override
    public void tick(GuiContext context) {
        DataWidget widget;
        if (this.dataWidgetKey != null && !this.dataWidgetKey.isEmpty() && (widget = (DataWidget)DataWidget.class.cast(context.findWidgetByKey(this.dataWidgetKey))) != null) {
            String value;
            Object rawValue = widget.getValue(this.dataWidgetDataKey);
            String string = value = rawValue == null ? "" : rawValue.toString();
            if (!value.equals(this.lastDataWidgetText)) {
                MMDLib.logger.info("Text changed on widget: " + value);
                this.setText(value);
                this.lastDataWidgetText = this.getText();
            } else {
                String text = this.getText();
                if (!text.equals(this.lastDataWidgetText)) {
                    MMDLib.logger.info("Sending text change to data widget: " + text);
                    this.lastDataWidgetText = text;
                    widget.setValue(this.dataWidgetDataKey, this.lastDataWidgetText);
                }
            }
        }
        if (this.actionWidgetKey != null && !this.actionWidgetKey.isEmpty()) {
            String text = this.getText();
            ActionWidget action = (ActionWidget)ActionWidget.class.cast(context.findWidgetByKey(this.actionWidgetKey));
            if (action != null && !text.equals(this.lastActionWidgetText)) {
                MMDLib.logger.info("Sending text change to action widget: " + text);
                this.lastActionWidgetText = text;
                action.actionPerformed(ActionTextWidget.getActionNBT(this.lastActionWidgetText));
            }
        }
    }
}

