/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.container.gui;

import com.mcmoddev.lib.MMDLib;
import com.mcmoddev.lib.container.IWidgetContainer;
import com.mcmoddev.lib.container.MMDContainer;
import com.mcmoddev.lib.container.gui.GuiContext;
import com.mcmoddev.lib.container.gui.GuiSprites;
import com.mcmoddev.lib.container.gui.IFocusableHandler;
import com.mcmoddev.lib.container.gui.IFocusableWidgetGui;
import com.mcmoddev.lib.container.gui.IGuiSprite;
import com.mcmoddev.lib.container.gui.IWidgetGui;
import com.mcmoddev.lib.container.gui.IWidgetGuiDebugInfo;
import com.mcmoddev.lib.container.gui.IWidgetLayout;
import com.mcmoddev.lib.container.gui.IWidgetLayoutDebugInfo;
import com.mcmoddev.lib.container.gui.util.Padding;
import com.mcmoddev.lib.container.gui.util.Size2D;
import com.mcmoddev.lib.container.gui.util.TexturedRectangleRenderer;
import com.mcmoddev.lib.container.gui.util.WidgetGuiIterable;
import com.mcmoddev.lib.container.widget.IWidget;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.util.TriConsumer;

public class MMDGuiContainer
extends GuiContainer
implements IFocusableHandler {
    protected final IWidgetContainer holder;
    protected final EntityPlayer player;
    private int specifiedWidth = 0;
    private int specifiedHeight = 0;
    private int specifiedPadding = 7;
    private int piecesOffsetX = 0;
    private int piecesOffsetY = 0;
    protected IWidgetGui rootPiece;
    private final MMDContainer container;
    private IFocusableWidgetGui currentFocus = null;
    private List<IFocusableWidgetGui> focusables = null;
    private int currentFocusIndex = -1;

    public MMDGuiContainer(IWidgetContainer holder, EntityPlayer player, MMDContainer container, int padding) {
        this(holder, player, container);
        this.specifiedPadding = padding;
    }

    public MMDGuiContainer(IWidgetContainer holder, EntityPlayer player, MMDContainer container, int width, int height) {
        this(holder, player, container);
        this.specifiedWidth = width;
        this.specifiedHeight = height;
    }

    public MMDGuiContainer(IWidgetContainer holder, EntityPlayer player, MMDContainer container) {
        super((Container)container);
        this.container = container;
        this.holder = holder;
        this.player = player;
    }

    public int getRenderLeft() {
        return this.piecesOffsetX + this.getGuiLeft();
    }

    public int getRenderTop() {
        return this.piecesOffsetY + this.getGuiTop();
    }

    public Size2D getRenderOffset(IWidgetGui piece) {
        Size2D initial = piece.getRenderOffset();
        return new Size2D(initial.width + this.piecesOffsetX, initial.height + this.piecesOffsetY);
    }

    public void func_73866_w_() {
        Padding padding;
        boolean firstRun = this.rootPiece == null;
        GuiContext context = new GuiContext(this.player, this.container, this, this.holder);
        if (this.rootPiece == null) {
            this.rootPiece = this.holder.getRootWidgetGui(context);
            this.focusables = new ArrayList<IFocusableWidgetGui>();
            WidgetGuiIterable.forEach(this.rootPiece, widget -> {
                widget.init(context);
                if (widget instanceof IFocusableWidgetGui) {
                    ((IFocusableWidgetGui)widget).setFocusableHandler(this);
                    this.focusables.add((IFocusableWidgetGui)widget);
                }
            });
            if (this.focusables.size() > 0) {
                this.currentFocusIndex = 0;
                this.setFocus(this.focusables.get(0));
            }
        }
        if ((padding = this.rootPiece.getPadding()).isEmpty()) {
            padding = new Padding(this.specifiedPadding);
        }
        Size2D rootSize = this.rootPiece.getSize().add(padding.getHorizontal(), padding.getVertical());
        this.piecesOffsetX = padding.left;
        this.piecesOffsetY = padding.top;
        this.logRootPiece();
        this.field_146999_f = this.specifiedWidth > 0 ? this.specifiedWidth : rootSize.width;
        this.field_147000_g = this.specifiedHeight > 0 ? this.specifiedHeight : rootSize.height;
        super.func_73866_w_();
        if (this.rootPiece != null) {
            WidgetGuiIterable.forEach(this.rootPiece, widget -> widget.postInit(context));
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.rootPiece != null) {
            GuiContext context = new GuiContext(this.player, this.container, this, this.holder);
            WidgetGuiIterable.forEach(this.rootPiece, widget -> widget.tick(context));
        }
    }

    private void logRootPiece() {
        if (this.rootPiece == null) {
            MMDLib.logger.info("GUI Opened WITHOUT a root piece.");
            return;
        }
        MMDLib.logger.info("GUI Opened with:");
        this.logPiece(null, this.rootPiece, 0);
        MMDLib.logger.info("End of GUI tree.");
    }

    private void logPiece(@Nullable IWidgetLayout layout, IWidgetGui piece, int level) {
        String prefix = new String(new char[level]).replace('\u0000', '\t') + "- ";
        String line = prefix + piece.getClass().getName();
        if (layout != null && layout instanceof IWidgetLayoutDebugInfo) {
            line = line + " {" + ((IWidgetLayoutDebugInfo)IWidgetLayoutDebugInfo.class.cast(layout)).getDebugInfo(piece) + "}";
        }
        if (piece instanceof IWidgetGuiDebugInfo) {
            line = line + " [" + ((IWidgetGuiDebugInfo)IWidgetGuiDebugInfo.class.cast(piece)).getDebugInfo() + "]";
        }
        MMDLib.logger.info(line);
        if (piece instanceof IWidgetLayout) {
            IWidgetLayout container = (IWidgetLayout)IWidgetLayout.class.cast(piece);
            for (IWidgetGui child : container.getChildren()) {
                this.logPiece(container, child, level + 1);
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        Slot hoveredSlot;
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        FontRenderer font = null;
        ItemStack forStack = ItemStack.field_190927_a;
        ArrayList<String> tooltip = new ArrayList<String>();
        if (this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && (hoveredSlot = this.getSlotUnderMouse()) != null && hoveredSlot.func_75216_d() && !(forStack = hoveredSlot.func_75211_c()).func_190926_b()) {
            tooltip.addAll(this.func_191927_a(forStack));
            font = forStack.func_77973_b().getFontRenderer(forStack);
        }
        if (this.rootPiece != null) {
            if (this.rootPiece instanceof IWidgetLayout) {
                ((IWidgetLayout)this.rootPiece).hitTest(mouseX - this.getRenderLeft(), mouseY - this.getRenderTop()).forEach(gui -> gui.getTooltip(tooltip));
            } else {
                this.rootPiece.getTooltip(tooltip);
            }
        }
        if (!tooltip.isEmpty()) {
            if (font == null) {
                font = this.field_146289_q;
            }
            if (!forStack.func_190926_b()) {
                GuiUtils.preItemToolTip((ItemStack)forStack);
                this.drawHoveringText(tooltip, mouseX, mouseY, font);
                GuiUtils.postItemToolTip();
            } else {
                this.drawHoveringText(tooltip, mouseX, mouseY, font);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    private void renderRootPiece(TriConsumer<IWidgetGui, Integer, Integer> renderer, int globalLeft, int globalTop, int mouseX, int mouseY) {
        if (this.rootPiece != null) {
            try {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)globalLeft, (float)globalTop, (float)0.01f);
                renderer.accept((Object)this.rootPiece, (Object)(mouseX - globalLeft), (Object)(mouseY - globalTop));
            }
            finally {
                GlStateManager.func_179121_F();
            }
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        if (this.hasBackground()) {
            IGuiSprite sprite = this.getBackgroundSprite();
            if (sprite != null) {
                sprite.draw((GuiScreen)this, 0, 0);
            } else {
                TexturedRectangleRenderer.drawOnGUI((GuiScreen)this, GuiSprites.MC_DEMO_BACKGROUND, 5, 1, this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g);
            }
        }
        this.renderRootPiece((TriConsumer<IWidgetGui, Integer, Integer>)((TriConsumer)(p, mx, my) -> p.drawBackgroundLayer(this, partialTicks, (int)mx, (int)my)), this.getRenderLeft(), this.getRenderTop(), mouseX, mouseY);
        this.renderRootPiece((TriConsumer<IWidgetGui, Integer, Integer>)((TriConsumer)(p, mx, my) -> p.drawMiddleLayer(this, partialTicks, (int)mx, (int)my)), this.getRenderLeft(), this.getRenderTop(), mouseX, mouseY);
    }

    protected boolean hasBackground() {
        return true;
    }

    @Nullable
    protected IGuiSprite getBackgroundSprite() {
        return null;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.renderRootPiece((TriConsumer<IWidgetGui, Integer, Integer>)((TriConsumer)(p, mx, my) -> p.drawForegroundLayer(this, (int)mx, (int)my)), this.piecesOffsetX, this.piecesOffsetY, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        this.renderRootPiece((TriConsumer<IWidgetGui, Integer, Integer>)((TriConsumer)(p, mx, my) -> p.drawForegroundTopLayer(this, (int)mx, (int)my)), this.piecesOffsetX, this.piecesOffsetY, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
    }

    public void drawFilledRect(int x, int y, int width, int height, int color) {
        this.func_73733_a(x, y, x + width, y + height, color, color);
    }

    public void drawFilledRect(int x, int y, int width, int height, int color, int strokeColor) {
        this.drawFilledRect(x, y, width, height, color);
        this.func_73730_a(x, x + width - 1, y, strokeColor);
        this.func_73728_b(x, y, y + height - 1, strokeColor);
        this.func_73728_b(x + width - 1, y, y + height - 1, strokeColor);
        this.func_73730_a(x, x + width - 1, y + height - 1, strokeColor);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public IWidget findWidgetByKey(String widgetKey) {
        return this.container.findWidgetByKey(widgetKey);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        int rootX = mouseX - this.field_147003_i - this.piecesOffsetX;
        int rootY = mouseY - this.field_147009_r - this.piecesOffsetY;
        if (rootX >= 0 && rootY >= 0) {
            Size2D size = this.rootPiece.getSize();
            if (rootX <= size.width && rootY <= size.height && this.rootPiece.mouseClicked(this, rootX, rootY, mouseButton)) {
                return;
            }
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        int rootX = mouseX - this.field_147003_i - this.piecesOffsetX;
        int rootY = mouseY - this.field_147009_r - this.piecesOffsetY;
        if (rootX >= 0 && rootY >= 0) {
            Size2D size = this.rootPiece.getSize();
            if (rootX <= size.width && rootY <= size.height && this.rootPiece.mouseReleased(this, rootX, rootY, state)) {
                return;
            }
        }
        super.func_146286_b(mouseX, mouseY, state);
    }

    @Override
    @Nullable
    public IFocusableWidgetGui getCurrentFocus() {
        return this.currentFocus;
    }

    @Override
    public void setFocus(@Nullable IFocusableWidgetGui widgetGui) {
        if (this.currentFocus != null) {
            this.currentFocus.onBlur();
        }
        this.currentFocus = widgetGui;
        if (this.currentFocus != null) {
            this.currentFocusIndex = this.focusables.indexOf(this.currentFocus);
            this.currentFocus.onFocus();
        } else {
            this.currentFocusIndex = -1;
        }
    }

    public void clearFocus() {
        this.setFocus(null);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.currentFocus != null && this.currentFocus.handleKeyPress(typedChar, keyCode)) {
            return;
        }
        if (typedChar > '\u0000' && keyCode == 15 && this.focusables != null && this.focusables.size() > 1) {
            this.setFocus(this.focusables.get((this.currentFocusIndex + 1) % this.focusables.size()));
            return;
        }
        super.func_73869_a(typedChar, keyCode);
    }
}

