/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.container.gui;

import com.mcmoddev.lib.container.gui.BaseWidgetGui;
import com.mcmoddev.lib.container.gui.GuiPieceLayer;
import com.mcmoddev.lib.container.gui.MMDGuiContainer;
import com.mcmoddev.lib.container.gui.sprite.FluidSprite;
import com.mcmoddev.lib.container.gui.util.Size2D;
import com.mcmoddev.lib.util.MathUtils;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fluids.Fluid;

public class FluidWidgetGui
extends BaseWidgetGui {
    private final Supplier<Fluid> fluidGetter;
    private final Supplier<Float> percentGetter;
    private final GuiPieceLayer layer;

    public FluidWidgetGui(Fluid fluid, int width, int height, GuiPieceLayer layer) {
        this(fluid, width, height, layer, null);
    }

    public FluidWidgetGui(Fluid fluid, int width, int height, GuiPieceLayer layer, @Nullable Supplier<Float> percentGetter) {
        this(() -> fluid, width, height, layer, percentGetter);
    }

    public FluidWidgetGui(Supplier<Fluid> fluidGetter, int width, int height, GuiPieceLayer layer) {
        this(fluidGetter, width, height, layer, null);
    }

    public FluidWidgetGui(Supplier<Fluid> fluidGetter, int width, int height, GuiPieceLayer layer, @Nullable Supplier<Float> percentGetter) {
        super(width, height);
        this.fluidGetter = fluidGetter;
        this.layer = layer;
        this.percentGetter = percentGetter;
    }

    @Override
    public GuiPieceLayer getLayer() {
        return this.layer;
    }

    @Override
    public void drawBackgroundLayer(MMDGuiContainer container, float partialTicks, int mouseX, int mouseY) {
        this.draw(container);
    }

    @Override
    public void drawMiddleLayer(MMDGuiContainer container, float partialTicks, int mouseX, int mouseY) {
        this.draw(container);
    }

    @Override
    public void drawForegroundLayer(MMDGuiContainer container, int mouseX, int mouseY) {
        this.draw(container);
    }

    @Override
    public void drawForegroundTopLayer(MMDGuiContainer container, int mouseX, int mouseY) {
        this.draw(container);
    }

    private void draw(MMDGuiContainer container) {
        Fluid fluid;
        Fluid fluid2 = fluid = this.fluidGetter == null ? null : this.fluidGetter.get();
        if (fluid == null) {
            return;
        }
        Float percent = Float.valueOf(MathUtils.clampf(this.percentGetter == null ? 1.0f : this.percentGetter.get().floatValue(), 0.0f, 1.0f));
        Size2D size = this.getSize();
        int height = MathUtils.clampi(Math.round((float)size.height * percent.floatValue()), 0, size.height);
        if (height == 0) {
            return;
        }
        int top = fluid.isGaseous() ? 0 : size.height - height;
        FluidSprite sprite = new FluidSprite(fluid, size.width, height);
        sprite.draw((GuiScreen)container, 0, top, size.width, height);
    }
}

