/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.lib.block;

import com.mcmoddev.lib.MMDLib;
import com.mcmoddev.lib.container.GuiHandlerIds;
import com.mcmoddev.lib.container.IGuiProvider;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MMDBlockWithGui
extends Block {
    public MMDBlockWithGui(Material blockMaterialIn, MapColor blockMapColorIn) {
        super(blockMaterialIn, blockMapColorIn);
    }

    public MMDBlockWithGui(Material materialIn) {
        super(materialIn);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        int guiId;
        if (super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ)) {
            return true;
        }
        if (worldIn != null && pos != null && (guiId = this.getGuiId(worldIn, pos, playerIn, hand, facing, hitX, hitY, hitZ)) >= 0) {
            if (worldIn.field_72995_K) {
                return true;
            }
            return this.openGui(guiId, worldIn, pos, playerIn);
        }
        return false;
    }

    protected int getGuiId(World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IGuiProvider) {
            return GuiHandlerIds.GUI_TILE.getValue();
        }
        return -1;
    }

    protected boolean openGui(int guiId, World world, BlockPos pos, EntityPlayer player) {
        player.openGui(this.getModInstance(world, pos), guiId, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    protected Object getModInstance(World world, BlockPos pos) {
        return MMDLib.instance;
    }
}

