/*
 * Decompiled with CFR 0.152.
 */
package jeresources.util;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import jeresources.util.LogHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class MobTableBuilder {
    private final Map<ResourceLocation, EntityLivingBase> mobTables = new HashMap<ResourceLocation, EntityLivingBase>();
    private final World world;

    public MobTableBuilder(World world) {
        this.world = world;
    }

    public <T extends EntityLivingBase> void add(ResourceLocation resourceLocation, Class<T> entityClass) {
        this.add(resourceLocation, entityClass, null);
    }

    public <T extends EntityLivingBase> void add(ResourceLocation resourceLocation, Class<T> entityClass, @Nullable EntityPropertySetter<T> entityPropertySetter) {
        T entityLivingBase = MobTableBuilder.construct(this.world, entityClass);
        if (entityLivingBase != null) {
            if (entityPropertySetter != null) {
                entityPropertySetter.setProperties(entityLivingBase);
            }
            this.mobTables.put(resourceLocation, (EntityLivingBase)entityLivingBase);
        }
    }

    @Nullable
    private static <T extends EntityLivingBase> T construct(World world, Class<T> entityClass) {
        Constructor<T> constructor = MobTableBuilder.getConstructor(entityClass);
        if (constructor != null) {
            try {
                return (T)((EntityLivingBase)constructor.newInstance(world));
            }
            catch (ReflectiveOperationException | RuntimeException e) {
                LogHelper.warn("Could not create entity " + entityClass, e);
                return null;
            }
        }
        return null;
    }

    @Nullable
    private static <T extends EntityLivingBase> Constructor<T> getConstructor(Class<T> entityClass) {
        try {
            return entityClass.getConstructor(World.class);
        }
        catch (NoSuchMethodException e) {
            LogHelper.warn("Could not find constructor for entity " + entityClass, new Object[0]);
            return null;
        }
    }

    public Map<ResourceLocation, EntityLivingBase> getMobTables() {
        return this.mobTables;
    }

    public static interface EntityPropertySetter<T extends EntityLivingBase> {
        public void setProperties(T var1);
    }
}

