/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.jeiutilities.gui.common;

import com.github.vfyjxf.jeiutilities.config.KeyBindings;
import com.github.vfyjxf.jeiutilities.gui.bookmark.AdvancedBookmarkOverlay;
import com.github.vfyjxf.jeiutilities.gui.recipe.RecipePreviewWidget;
import com.github.vfyjxf.jeiutilities.jei.JeiUtilitiesPlugin;
import com.github.vfyjxf.jeiutilities.jei.ingredient.RecipeInfo;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.input.MouseHelper;
import mezz.jei.util.ReflectionUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.input.Keyboard;

public class GuiInputHandler {
    private static GuiInputHandler instance;
    private final IntSet pressedKeys = new IntArraySet();

    public static GuiInputHandler getInstance() {
        if (instance == null) {
            instance = new GuiInputHandler();
        }
        return instance;
    }

    private GuiInputHandler() {
    }

    @SubscribeEvent
    public void onKeyPressed(GuiScreenEvent.KeyboardInputEvent.Post event) {
        RecipePreviewWidget recipeLayout;
        boolean shouldNotHandleKey;
        char typedChar = Keyboard.getEventCharacter();
        int eventKey = Keyboard.getEventKey();
        if (this.pressedKeys.contains(eventKey) && !Keyboard.isKeyDown((int)eventKey)) {
            this.pressedKeys.remove(eventKey);
        }
        boolean shouldHandleInput = eventKey == 0 && typedChar >= ' ' || Keyboard.getEventKeyState();
        boolean bl = shouldNotHandleKey = !shouldHandleInput || this.pressedKeys.contains(eventKey) || GuiInputHandler.isContainerTextFieldFocused() || JeiUtilitiesPlugin.ingredientListOverlay.hasKeyboardFocus();
        if (shouldNotHandleKey) {
            return;
        }
        boolean isTransferRecipe = KeyBindings.isKeyDown(KeyBindings.transferRecipe);
        boolean isTransferRecipeMax = KeyBindings.isKeyDown(KeyBindings.transferRecipeMax);
        if ((isTransferRecipe || isTransferRecipeMax) && (recipeLayout = this.getRecipeLayout()) != null) {
            Minecraft mc = event.getGui().field_146297_k;
            if (mc == null) {
                return;
            }
            if (mc.field_71462_r instanceof GuiContainer) {
                Container container = ((GuiContainer)mc.field_71462_r).field_147002_h;
                IRecipeTransferError error = recipeLayout.transferRecipe(container, (EntityPlayer)mc.field_71439_g, false, false);
                if (error == null) {
                    recipeLayout.transferRecipe(container, (EntityPlayer)mc.field_71439_g, isTransferRecipeMax, true);
                    event.setCanceled(true);
                }
                this.pressedKeys.add(eventKey);
            }
        }
    }

    private RecipePreviewWidget getRecipeLayout() {
        AdvancedBookmarkOverlay bookmarkOverlay;
        Object ingredient;
        if (JeiUtilitiesPlugin.bookmarkOverlay instanceof AdvancedBookmarkOverlay && (ingredient = (bookmarkOverlay = (AdvancedBookmarkOverlay)JeiUtilitiesPlugin.bookmarkOverlay).getIngredientUnderMouse()) instanceof RecipeInfo) {
            RecipeInfo recipeInfo = (RecipeInfo)ingredient;
            if (recipeInfo == bookmarkOverlay.getInfoUnderMouse()) {
                return bookmarkOverlay.getRecipeLayout();
            }
            RecipePreviewWidget recipeLayout = RecipePreviewWidget.createLayout(recipeInfo, MouseHelper.getX(), MouseHelper.getY());
            if (recipeLayout != null) {
                bookmarkOverlay.setRecipeLayout(recipeLayout);
                bookmarkOverlay.setInfoUnderMouse(recipeInfo);
                return recipeLayout;
            }
        }
        return null;
    }

    public static boolean isContainerTextFieldFocused() {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (gui == null) {
            return false;
        }
        GuiTextField textField = (GuiTextField)ReflectionUtil.getFieldWithClass((Object)gui, GuiTextField.class);
        return textField != null && textField.func_146176_q() && textField.func_146206_l();
    }
}

