/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.headcrumbs.eventHandlers;

import com.google.common.base.Predicate;
import com.mojang.authlib.GameProfile;
import ganymedes01.headcrumbs.Headcrumbs;
import ganymedes01.headcrumbs.ModBlocks;
import ganymedes01.headcrumbs.entity.EntityHuman;
import ganymedes01.headcrumbs.entity.vip.direwolf20;
import ganymedes01.headcrumbs.tileentities.TileEntityBlockPlayer;
import ganymedes01.headcrumbs.utils.HeadUtils;
import ganymedes01.headcrumbs.utils.Utils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.block.state.pattern.BlockStateMatcher;
import net.minecraft.block.state.pattern.FactoryBlockPattern;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class HandlerEvents {
    public static final HandlerEvents INSTANCE = new HandlerEvents();
    private static List<String> hardcodedBlacklist = Arrays.asList("Twilight Forest", "Erebus", "The Outer Lands");
    private static Item cleaver;
    private BlockPattern statuePattern;

    @SubscribeEvent
    public static void registerSoundEvents(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().register((IForgeRegistryEntry)direwolf20.takeItEasy);
    }

    @SubscribeEvent
    public void onCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (event.getEntityLiving() instanceof EntityHuman) {
            World world = event.getWorld();
            DimensionType dimType = world.field_73011_w.func_186058_p();
            if (hardcodedBlacklist.contains(dimType.func_186065_b()) || HandlerEvents.isDimensionBlackListed(dimType.func_186068_a())) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    private static boolean isDimensionBlackListed(int dimensionId) {
        for (int id : Headcrumbs.blacklistedDimensions) {
            if (dimensionId != id) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void playerDrop(LivingDeathEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.field_70170_p.func_82736_K().func_82766_b("keepInventory") && entity instanceof EntityPlayerMP) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            ItemStack weapon = this.getWeapon(event.getSource());
            if (weapon != null) {
                int looting = EnchantmentHelper.func_77506_a((Enchantment)Enchantment.func_180305_b((String)"looting"), (ItemStack)weapon);
                this.drop(event.getEntityLiving(), event.getSource(), looting, drops);
                if (!drops.isEmpty()) {
                    for (ItemStack item : drops) {
                        ((EntityPlayerMP)entity).func_71019_a(item, true);
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void dropEvent(LivingDropsEvent event) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        this.drop(event.getEntityLiving(), event.getSource(), event.getLootingLevel(), drops);
        if (!drops.isEmpty()) {
            Entity ent = event.getEntity();
            for (ItemStack item : drops) {
                event.getDrops().add(new EntityItem(ent.field_70170_p, ent.field_70165_t, ent.field_70163_u, ent.field_70161_v, item));
            }
        }
    }

    private void drop(EntityLivingBase entity, DamageSource source, int looting, List<ItemStack> drops) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (entity.func_110143_aJ() > 0.0f) {
            return;
        }
        boolean isPoweredCreeper = this.isPoweredCreeper(source);
        int beheading = this.getBeaheadingLevel(this.getWeapon(source));
        if (isPoweredCreeper || this.shouldDoRandomDrop(entity.field_70170_p.field_73012_v, beheading, looting)) {
            ItemStack stack = HeadUtils.getHeadfromEntity(entity);
            if (stack == null) {
                return;
            }
            if (beheading > 0 && stack.func_77973_b() == Items.field_151144_bL) {
                return;
            }
            stack.func_77955_b(new NBTTagCompound());
            if ((stack.func_77973_b() != Items.field_151144_bL || Headcrumbs.enableVanillaHeadsDrop) && (this.isPlayerHead(stack) || Headcrumbs.enableMobsAndAnimalHeads)) {
                drops.add(stack);
            }
        }
    }

    private boolean isPoweredCreeper(DamageSource source) {
        Entity entity;
        if (source.func_94541_c() && source instanceof EntityDamageSource && (entity = ((EntityDamageSource)source).func_76346_g()) != null && entity instanceof EntityCreeper) {
            return ((EntityCreeper)entity).func_70830_n();
        }
        return false;
    }

    private boolean isPlayerHead(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151144_bL && stack.func_77960_j() == 3;
    }

    private boolean shouldDoRandomDrop(Random rand, int beheading, int looting) {
        if (beheading > 0) {
            return rand.nextInt(100) < beheading * 10;
        }
        int chance = Math.max(1, Headcrumbs.headDropChance / Math.max(looting + 1, 1));
        return Headcrumbs.enableRandomHeadDrop && rand.nextInt(chance) == 0;
    }

    private int getBeaheadingLevel(ItemStack weapon) {
        if (Headcrumbs.isTinkersConstructLoaded) {
            NBTTagCompound infiTool;
            if (cleaver == null) {
                try {
                    Class<?> TinkerTools = Class.forName("tconstruct.tools.TinkerTools");
                    Field field = TinkerTools.getDeclaredField("cleaver");
                    field.setAccessible(true);
                    cleaver = (Item)field.get(null);
                }
                catch (Exception TinkerTools) {
                    // empty catch block
                }
            }
            if (weapon == null || !weapon.func_77942_o()) {
                return 0;
            }
            if (weapon.func_77978_p().func_150297_b("InfiTool", 10) && (infiTool = weapon.func_77978_p().func_74775_l("InfiTool")).func_150297_b("Beheading", 3)) {
                int beheading = infiTool.func_74762_e("Beheading");
                if (cleaver == weapon.func_77973_b()) {
                    beheading += 2;
                }
                return beheading;
            }
        }
        return 0;
    }

    private ItemStack getWeapon(DamageSource source) {
        Entity entity;
        if (source instanceof EntityDamageSource && (entity = ((EntityDamageSource)source).func_76346_g()) instanceof EntityPlayer) {
            return ((EntityPlayer)entity).func_184607_cu();
        }
        return null;
    }

    @SubscribeEvent
    public void onSkullPlacedEvent(BlockEvent.PlaceEvent event) {
        TileEntitySkull tileSkull;
        BlockPos pos;
        if (event.getState().func_177230_c() != Blocks.field_150465_bP) {
            return;
        }
        World world = event.getWorld();
        TileEntity tileEntity = world.func_175625_s(pos = event.getPos());
        if (tileEntity instanceof TileEntitySkull && (tileSkull = (TileEntitySkull)tileEntity).func_145904_a() == 3 && pos.func_177956_o() >= 2 && world.func_175659_aa() != EnumDifficulty.PEACEFUL && !world.field_72995_K) {
            BlockPattern.PatternHelper patternHelper;
            if (this.statuePattern == null) {
                this.statuePattern = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{"^", "#", "#"}).func_177662_a('#', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_150435_aG))).func_177662_a('^', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_150465_bP))).func_177661_b();
            }
            if ((patternHelper = this.statuePattern.func_177681_a(world, pos)) != null) {
                GameProfile profile = tileSkull.func_152108_a();
                for (int i = 0; i < 3; ++i) {
                    BlockWorldState blockWorldState = patternHelper.func_177670_a(0, -i, 0);
                    world.func_180501_a(blockWorldState.func_177508_d(), Blocks.field_150350_a.func_176223_P(), 2);
                }
                world.func_175656_a(pos.func_177982_a(0, -1, 0), ModBlocks.player.func_176223_P());
                Utils.doBreakParticles(world, pos.func_177982_a(0, -1, 0), Blocks.field_150425_aM, 0);
                world.func_175656_a(pos.func_177982_a(0, -2, 0), ModBlocks.empty.func_176223_P());
                Utils.doBreakParticles(world, pos.func_177982_a(0, -2, 0), Blocks.field_150425_aM, 0);
                TileEntityBlockPlayer tile = Utils.getTileEntity((IBlockAccess)world, pos.func_177982_a(0, -1, 0), TileEntityBlockPlayer.class);
                if (tile != null) {
                    tile.func_152106_a(profile);
                    tile.func_145903_a(MathHelper.func_76128_c((double)((double)(event.getPlayer().field_70177_z * 16.0f / 360.0f) + 0.5)) & 0xF);
                    world.func_175685_c(pos, ModBlocks.player, true);
                }
            }
        }
    }
}

