/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.tiles;

import com.zeitheron.hammercore.HammerCore;
import com.zeitheron.hammercore.api.io.NBTSerializationHelper;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import org.zeith.hammerlib.abstractions.sources.IObjectSource;
import org.zeith.hammerlib.api.tiles.IContainerTile;
import org.zeith.hammerlib.api.tiles.ISyncableTile;
import org.zeith.hammerlib.net.properties.IPropertyTile;
import org.zeith.hammerlib.net.properties.PropertyDispatcher;
import org.zeith.hammerlib.tiles.TileSyncableTickable;

public abstract class TileSyncable
extends TileEntity
implements ISyncableTile,
IPropertyTile,
IContainerTile {
    protected World readNBT_world;
    protected final PropertyDispatcher dispatcher = new PropertyDispatcher(IObjectSource.ofTile(this), this::syncProperties);
    protected Random rand = new Random();

    public Random getRNG() {
        if (this.rand == null) {
            this.rand = new Random();
        }
        return this.rand;
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.sync();
    }

    public NBTTagCompound func_189517_E_() {
        return this.writeNBT(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readNBT(pkt.func_148857_g());
    }

    public NetworkRegistry.TargetPoint getSyncPoint(int range) {
        return new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)range);
    }

    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        nbt.func_179237_a(NBTSerializationHelper.serialize(this));
        return nbt;
    }

    public void readNBT(NBTTagCompound nbt) {
        NBTSerializationHelper.deserialize(this, nbt);
    }

    public final NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        NBTTagCompound tag = new NBTTagCompound();
        this.writeNBT(tag);
        nbt.func_74782_a("HL", (NBTBase)tag);
        if (this instanceof TileSyncableTickable) {
            nbt.func_74768_a("TicksExisted", ((TileSyncableTickable)this).ticksExisted);
        }
        return nbt;
    }

    public final void func_145839_a(NBTTagCompound nbt) {
        if (this.readNBT_world == null && this.field_145850_b != null) {
            this.readNBT_world = this.field_145850_b;
        }
        super.func_145839_a(nbt);
        if (!nbt.func_150297_b("HL", 10)) {
            HammerCore.LOG.warn("TileEntity {} tried to load old NBT Key: \"Tags\". It is going to be renamed to \"HL\"!", (Object)this);
        }
        this.readNBT(!nbt.func_150297_b("HL", 10) ? nbt.func_74775_l("Tags") : nbt.func_74775_l("HL"));
        if (this instanceof TileSyncableTickable) {
            ((TileSyncableTickable)this).ticksExisted = nbt.func_74762_e("TicksExisted");
        }
        this.readNBT_world = null;
    }

    protected void func_190201_b(World worldIn) {
        this.field_145850_b = worldIn;
        this.readNBT_world = worldIn;
    }

    public boolean atTickRate(int rate) {
        return (this.field_145850_b.func_82737_E() + this.field_174879_c.func_177986_g()) % (long)rate == 0L;
    }

    public final void tryOpenGui(EntityPlayer player, World world) {
        if (!world.field_72995_K) {
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)HammerCore.instance, (int)0, (World)world, (int)this.field_174879_c.func_177958_n(), (int)this.field_174879_c.func_177956_o(), (int)this.field_174879_c.func_177952_p());
        }
    }

    public void onPlacedBy(EntityPlayer player, EnumHand hand) {
    }

    @Override
    public boolean hasGui() {
        return false;
    }

    @Override
    public Object getServerGuiElement(EntityPlayer player) {
        return null;
    }

    @Override
    public Object getClientGuiElement(EntityPlayer player) {
        return null;
    }

    @Override
    public PropertyDispatcher getProperties() {
        return this.dispatcher;
    }
}

