/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.event.listeners;

import com.zeitheron.hammercore.net.HCNet;
import com.zeitheron.hammercore.net.IPacket;
import com.zeitheron.hammercore.net.internal.PacketSyncAnyTile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.zeith.hammerlib.api.tiles.ISyncableTile;
import org.zeith.hammerlib.net.properties.IBasePropertyHolder;
import org.zeith.hammerlib.net.properties.IPropertyTile;
import org.zeith.hammerlib.util.mcf.LogicalSidePredictor;

@Mod.EventBusSubscriber
public class ServerListener {
    public static final List<TileEntity> NEED_SYNC = new ArrayList<TileEntity>();
    public static final List<TileEntity> NEED_PROP_SYNC = new ArrayList<TileEntity>();
    public static final List<IBasePropertyHolder> NEED_PROP_SYNC_GENERIC = new ArrayList<IBasePropertyHolder>();

    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent e) {
        TileEntity tile;
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        HashSet<BlockPos> processed = new HashSet<BlockPos>();
        while (!NEED_SYNC.isEmpty()) {
            tile = NEED_SYNC.remove(0);
            if (!processed.add(tile.func_174877_v())) continue;
            if (tile instanceof ISyncableTile) {
                ((ISyncableTile)tile).syncNow();
                continue;
            }
            HCNet.INSTANCE.sendToAllAroundTracking((IPacket)new PacketSyncAnyTile(tile), tile);
        }
        processed.clear();
        while (!NEED_PROP_SYNC.isEmpty()) {
            tile = NEED_PROP_SYNC.remove(0);
            if (!processed.add(tile.func_174877_v()) || !(tile instanceof IPropertyTile)) continue;
            ((IPropertyTile)tile).syncPropertiesNow();
        }
        while (!NEED_PROP_SYNC_GENERIC.isEmpty()) {
            IBasePropertyHolder data = NEED_PROP_SYNC_GENERIC.remove(0);
            if (data == null) continue;
            data.syncPropertiesNow();
        }
    }

    public static void syncProperties(IBasePropertyHolder ent) {
        if (LogicalSidePredictor.getCurrentLogicalSide() == Side.SERVER) {
            NEED_PROP_SYNC_GENERIC.add(ent);
        }
    }

    public static void syncTileEntity(TileEntity tileEntity) {
        if (tileEntity != null && tileEntity.func_145831_w() instanceof WorldServer) {
            NEED_SYNC.add(tileEntity);
        }
    }
}

